/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.object;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mrcrayfish.guns.item.IAttachment;
import com.mrcrayfish.guns.object.GripType;
import com.mrcrayfish.guns.object.ServerGun;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class Gun
implements INBTSerializable<NBTTagCompound> {
    @Ignored
    public ServerGun serverGun;
    public String id;
    public General general = new General();
    public Projectile projectile = new Projectile();
    public Sounds sounds = new Sounds();
    public Display display = new Display();
    public Modules modules = new Modules();

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.id);
        tag.func_74782_a("general", (NBTBase)this.general.serializeNBT());
        tag.func_74782_a("projectile", (NBTBase)this.projectile.serializeNBT());
        tag.func_74782_a("sounds", (NBTBase)this.sounds.serializeNBT());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("id", 8)) {
            this.id = tag.func_74779_i("id");
        }
        if (tag.func_150297_b("general", 10)) {
            this.general.deserializeNBT(tag.func_74775_l("general"));
        }
        if (tag.func_150297_b("projectile", 10)) {
            this.projectile.deserializeNBT(tag.func_74775_l("projectile"));
        }
        if (tag.func_150297_b("sounds", 10)) {
            this.sounds.deserializeNBT(tag.func_74775_l("sounds"));
        }
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.serverGun = this.serverGun;
        gun.id = this.id;
        gun.general = this.general.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public void setServerGun(ServerGun serverGun) {
        this.serverGun = serverGun;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getScope(ItemStack gun) {
        NBTTagCompound attachment;
        if (gun.func_77942_o() && gun.func_77978_p().func_150297_b("attachments", 10) && (attachment = gun.func_77978_p().func_74775_l("attachments")).func_150297_b("scope", 10)) {
            return new ItemStack(attachment.func_74775_l("scope"));
        }
        return null;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        NBTTagCompound attachment;
        if (gun.func_77942_o() && gun.func_77978_p().func_150297_b("attachments", 10) && (attachment = gun.func_77978_p().func_74775_l("attachments")).func_150297_b(type.getName(), 10)) {
            return new ItemStack(attachment.func_74775_l(type.getName()));
        }
        return ItemStack.field_190927_a;
    }

    public static class Deserializer
    implements JsonDeserializer<Gun> {
        private Gun base;

        public Deserializer(Gun base) {
            this.base = base;
        }

        public Gun deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject general = JsonUtils.func_152754_s((JsonObject)json.getAsJsonObject(), (String)"General");
            this.base.general.maxAmmo = JsonUtils.func_151208_a((JsonObject)general, (String)"Max Ammo", (int)this.base.general.maxAmmo);
            this.base.general.reloadSpeed = JsonUtils.func_151208_a((JsonObject)general, (String)"Reload Speed", (int)this.base.general.reloadSpeed);
            this.base.general.projectileAmount = JsonUtils.func_151208_a((JsonObject)general, (String)"Projectile Count", (int)this.base.general.projectileAmount);
            this.base.general.alwaysSpread = JsonUtils.func_151209_a((JsonObject)general, (String)"Always Spread", (boolean)this.base.general.alwaysSpread);
            this.base.general.spread = JsonUtils.func_151221_a((JsonObject)general, (String)"Spread", (float)this.base.general.spread);
            JsonObject projectile = JsonUtils.func_152754_s((JsonObject)json.getAsJsonObject(), (String)"Projectile");
            this.base.projectile.damage = JsonUtils.func_151221_a((JsonObject)projectile, (String)"Damage", (float)this.base.projectile.damage);
            this.base.projectile.damageReduceOverLife = JsonUtils.func_151209_a((JsonObject)projectile, (String)"Damage Falloff", (boolean)this.base.projectile.damageReduceOverLife);
            this.base.projectile.gravity = JsonUtils.func_151209_a((JsonObject)projectile, (String)"Gravity", (boolean)this.base.projectile.gravity);
            this.base.projectile.life = JsonUtils.func_151208_a((JsonObject)projectile, (String)"Ticks Before Removed", (int)this.base.projectile.life);
            this.base.projectile.damageReduceIfNotZoomed = JsonUtils.func_151209_a((JsonObject)projectile, (String)"Reduce Damage If Not Zoomed", (boolean)this.base.projectile.damageReduceIfNotZoomed);
            this.base.projectile.size = JsonUtils.func_151221_a((JsonObject)projectile, (String)"Size", (float)this.base.projectile.size);
            this.base.projectile.speed = JsonUtils.func_151221_a((JsonObject)projectile, (String)"Speed", (float)((float)this.base.projectile.speed));
            return this.base;
        }
    }

    public static class Serializer
    implements JsonSerializer<Gun> {
        public JsonElement serialize(Gun gun, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject parent = new JsonObject();
            JsonObject general = new JsonObject();
            general.addProperty("Max Ammo", (Number)gun.general.maxAmmo);
            general.addProperty("Reload Speed", (Number)gun.general.reloadSpeed);
            general.addProperty("Projectile Count", (Number)gun.general.projectileAmount);
            general.addProperty("Always Spread", Boolean.valueOf(gun.general.alwaysSpread));
            general.addProperty("Spread", (Number)Float.valueOf(gun.general.spread));
            parent.add("General", (JsonElement)general);
            JsonObject projectile = new JsonObject();
            projectile.addProperty("Damage", (Number)Float.valueOf(gun.projectile.damage));
            projectile.addProperty("Damage Falloff", Boolean.valueOf(gun.projectile.damageReduceOverLife));
            projectile.addProperty("Gravity", Boolean.valueOf(gun.projectile.gravity));
            projectile.addProperty("Ticks Before Removed", (Number)gun.projectile.life);
            projectile.addProperty("Reduce Damage If Not Zoomed", Boolean.valueOf(gun.projectile.damageReduceIfNotZoomed));
            projectile.addProperty("Size", (Number)Float.valueOf(gun.projectile.size));
            projectile.addProperty("Speed", (Number)gun.projectile.speed);
            parent.add("Projectile", (JsonElement)projectile);
            return parent;
        }
    }

    public static class ResourceLocationDeserializer
    implements JsonDeserializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ResourceLocation(json.getAsString());
        }
    }

    public static class ResourceLocationSerializer
    implements JsonSerializer<ResourceLocation> {
        public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Ignored {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        public double scale = 1.0;
    }

    public static class Positioned {
        @Optional
        public double xOffset;
        @Optional
        public double yOffset;
        @Optional
        public double zOffset;
    }

    public static class Modules {
        @Optional
        public Zoom zoom;
        public Attachments attachments = new Attachments();

        public Modules copy() {
            Modules modules = new Modules();
            if (this.zoom != null) {
                modules.zoom = this.zoom.copy();
            }
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments {
            @Optional
            public Scope scope;
            @Optional
            public Barrel barrel;

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                return attachments;
            }

            public static class Barrel
            extends ScaledPositioned {
                public Barrel copy() {
                    Barrel barrel = new Barrel();
                    barrel.scale = this.scale;
                    barrel.xOffset = this.xOffset;
                    barrel.yOffset = this.yOffset;
                    barrel.zOffset = this.zOffset;
                    return barrel;
                }
            }

            public static class Scope
            extends ScaledPositioned {
                @Optional
                public boolean smooth;

                public Scope copy() {
                    Scope scope = new Scope();
                    scope.smooth = this.smooth;
                    scope.scale = this.scale;
                    scope.xOffset = this.xOffset;
                    scope.yOffset = this.yOffset;
                    scope.zOffset = this.zOffset;
                    return scope;
                }
            }
        }

        public static class Zoom
        extends Positioned {
            @Optional
            public float fovModifier;
            @Optional
            public boolean smooth;

            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.smooth = this.smooth;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }
        }
    }

    public static class Display {
        @Optional
        public Flash flash;

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            return display;
        }

        public static class Flash
        extends ScaledPositioned {
            public Flash copy() {
                Flash flash = new Flash();
                flash.scale = this.scale;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }
        }
    }

    public static class Sounds
    implements INBTSerializable<NBTTagCompound> {
        public String fire = "";
        public String reload = "";
        public String cock = "";
        public String silencedFire = "silenced_fire";

        public String getFire(Gun modifiedGun) {
            String fire = this.fire;
            if (!modifiedGun.sounds.fire.equals(fire)) {
                fire = modifiedGun.sounds.fire;
            }
            return fire;
        }

        public String getReload(Gun modifiedGun) {
            String reload = this.reload;
            if (!modifiedGun.sounds.reload.equals(reload)) {
                reload = modifiedGun.sounds.reload;
            }
            return reload;
        }

        public String getCock(Gun modifiedGun) {
            String cock = this.cock;
            if (!modifiedGun.sounds.cock.equals(cock)) {
                cock = modifiedGun.sounds.cock;
            }
            return cock;
        }

        public String getSilencedFire(Gun modifiedGun) {
            String silencedFire = this.silencedFire;
            if (!modifiedGun.sounds.silencedFire.equals(silencedFire)) {
                silencedFire = modifiedGun.sounds.silencedFire;
            }
            return silencedFire;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fire", this.fire);
            tag.func_74778_a("reload", this.reload);
            tag.func_74778_a("cock", this.cock);
            tag.func_74778_a("silencedFire", this.silencedFire);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            if (tag.func_150297_b("fire", 8)) {
                this.fire = tag.func_74779_i("fire");
            }
            if (tag.func_150297_b("reload", 8)) {
                this.reload = tag.func_74779_i("reload");
            }
            if (tag.func_150297_b("cock", 8)) {
                this.cock = tag.func_74779_i("cock");
            }
            if (tag.func_150297_b("silencedFire", 8)) {
                this.silencedFire = tag.func_74779_i("silencedFire");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            return sounds;
        }
    }

    public static class Projectile
    implements INBTSerializable<NBTTagCompound> {
        public ResourceLocation item;
        @Optional
        public boolean visible;
        public float damage;
        public float size;
        public double speed;
        public int life;
        @Optional
        public boolean gravity;
        @Optional
        public boolean damageReduceOverLife;
        @Optional
        public boolean damageReduceIfNotZoomed;
        @Optional
        public int trailColor = 0xFFFFFF;
        @Optional
        public double trailLengthMultiplier = 1.0;

        public float getDamage(Gun modifiedGun) {
            float damage = this.damage;
            if (modifiedGun.serverGun != null) {
                damage = modifiedGun.serverGun.damage;
            }
            if (modifiedGun.projectile.damage != this.damage && modifiedGun.projectile.damage != damage) {
                damage = modifiedGun.projectile.damage;
            }
            return damage;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("item", this.item.toString());
            tag.func_74757_a("visible", this.visible);
            tag.func_74776_a("damage", this.damage);
            tag.func_74776_a("size", this.size);
            tag.func_74780_a("speed", this.speed);
            tag.func_74768_a("life", this.life);
            tag.func_74757_a("gravity", this.gravity);
            tag.func_74757_a("damageReduceOverLife", this.damageReduceOverLife);
            tag.func_74757_a("damageReduceIfNotZoomed", this.damageReduceIfNotZoomed);
            tag.func_74768_a("trailColor", this.trailColor);
            tag.func_74780_a("trailLengthMultiplier", this.trailLengthMultiplier);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            if (tag.func_150297_b("item", 8)) {
                this.item = new ResourceLocation(tag.func_74779_i("item"));
            }
            if (tag.func_150297_b("visible", 1)) {
                this.visible = tag.func_74767_n("visible");
            }
            if (tag.func_150297_b("damage", 5)) {
                this.damage = tag.func_74760_g("damage");
            }
            if (tag.func_150297_b("size", 5)) {
                this.size = tag.func_74760_g("size");
            }
            if (tag.func_150297_b("speed", 6)) {
                this.speed = tag.func_74769_h("speed");
            }
            if (tag.func_150297_b("life", 3)) {
                this.life = tag.func_74762_e("life");
            }
            if (tag.func_150297_b("gravity", 1)) {
                this.gravity = tag.func_74767_n("gravity");
            }
            if (tag.func_150297_b("damageReduceOverLife", 1)) {
                this.damageReduceOverLife = tag.func_74767_n("damageReduceOverLife");
            }
            if (tag.func_150297_b("damageReduceIfNotZoomed", 1)) {
                this.damageReduceIfNotZoomed = tag.func_74767_n("damageReduceIfNotZoomed");
            }
            if (tag.func_150297_b("trailColor", 3)) {
                this.trailColor = tag.func_74762_e("trailColor");
            }
            if (tag.func_150297_b("trailLengthMultiplier", 6)) {
                this.trailLengthMultiplier = tag.func_74769_h("trailLengthMultiplier");
            }
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.damageReduceIfNotZoomed = this.damageReduceIfNotZoomed;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            return projectile;
        }
    }

    public static class General
    implements INBTSerializable<NBTTagCompound> {
        @Optional
        public boolean auto = false;
        public int rate;
        public GripType gripType = GripType.ONE_HANDED;
        public int maxAmmo;
        @Optional
        public int reloadSpeed = 1;
        @Optional
        public float recoilAngle;
        @Optional
        public float recoilKick;
        @Optional
        public float recoilDurationOffset;
        @Optional
        public int projectileAmount = 1;
        @Optional
        public boolean alwaysSpread;
        @Optional
        public float spread;

        public int getMaxAmmo(Gun modifiedGun) {
            int maxAmmo = this.maxAmmo;
            if (modifiedGun.serverGun != null) {
                maxAmmo = modifiedGun.serverGun.maxAmmo;
            }
            if (modifiedGun.general.maxAmmo != maxAmmo) {
                maxAmmo = modifiedGun.general.maxAmmo;
            }
            return maxAmmo;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("auto", this.auto);
            tag.func_74768_a("rate", this.rate);
            tag.func_74768_a("gripType", this.gripType.ordinal());
            tag.func_74768_a("maxAmmo", this.maxAmmo);
            tag.func_74768_a("reloadSpeed", this.reloadSpeed);
            tag.func_74776_a("recoilAngle", this.recoilAngle);
            tag.func_74776_a("recoilKick", this.recoilKick);
            tag.func_74776_a("recoilDurationOffset", this.recoilDurationOffset);
            tag.func_74768_a("projectileAmount", this.projectileAmount);
            tag.func_74757_a("alwaysSpread", this.alwaysSpread);
            tag.func_74776_a("spread", this.spread);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            if (tag.func_150297_b("auto", 1)) {
                this.auto = tag.func_74767_n("auto");
            }
            if (tag.func_150297_b("rate", 3)) {
                this.rate = tag.func_74762_e("rate");
            }
            if (tag.func_150297_b("gripType", 3)) {
                this.gripType = GripType.values()[tag.func_74762_e("gripType")];
            }
            if (tag.func_150297_b("maxAmmo", 3)) {
                this.maxAmmo = tag.func_74762_e("maxAmmo");
            }
            if (tag.func_150297_b("reloadSpeed", 3)) {
                this.reloadSpeed = tag.func_74762_e("reloadSpeed");
            }
            if (tag.func_150297_b("recoilAngle", 5)) {
                this.recoilAngle = tag.func_74760_g("recoilAngle");
            }
            if (tag.func_150297_b("recoilKick", 5)) {
                this.recoilKick = tag.func_74760_g("recoilKick");
            }
            if (tag.func_150297_b("recoilDurationOffset", 5)) {
                this.recoilDurationOffset = tag.func_74760_g("recoilDurationOffset");
            }
            if (tag.func_150297_b("projectileAmount", 3)) {
                this.projectileAmount = tag.func_74762_e("projectileAmount");
            }
            if (tag.func_150297_b("alwaysSpread", 1)) {
                this.alwaysSpread = tag.func_74767_n("alwaysSpread");
            }
            if (tag.func_150297_b("spread", 5)) {
                this.spread = tag.func_74760_g("spread");
            }
        }

        public General copy() {
            General general = new General();
            general.auto = this.auto;
            general.rate = this.rate;
            general.gripType = this.gripType;
            general.maxAmmo = this.maxAmmo;
            general.reloadSpeed = this.reloadSpeed;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.recoilDurationOffset = this.recoilDurationOffset;
            general.projectileAmount = this.projectileAmount;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            return general;
        }
    }
}

