/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.doors.block.BigDoor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class BigDoorRecipe
implements IRecipe {
    private ResourceLocation registryName;
    private final ItemDoor door;
    private final ItemStack result;

    public BigDoorRecipe(ItemDoor door, ItemStack result) {
        this.door = door;
        this.result = result;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return !this.getMatching(inv).func_190926_b();
    }

    public ItemStack getMatching(InventoryCrafting inv) {
        boolean doorMatch = false;
        ItemStack frame = ItemStack.field_190927_a;
        int frameSize = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == this.door) {
                if (doorMatch) {
                    return ItemStack.field_190927_a;
                }
                doorMatch = true;
                continue;
            }
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            if (block == Blocks.field_150350_a || !frame.func_190926_b() && !ItemUtils.areItemStacksStackable((ItemStack)frame, (ItemStack)itemStack)) {
                return ItemStack.field_190927_a;
            }
            frame = itemStack;
            frameSize += itemStack.func_190916_E();
        }
        return !doorMatch || frameSize < 5 ? ItemStack.field_190927_a : frame;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack frame = this.getMatching(inv);
        if (frame.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = this.result.func_77946_l();
        NBTTagCompound nbt = new NBTTagCompound();
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)ItemUtils.getStateFromItemStack((ItemStack)frame));
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width <= 2 && height <= 2;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int left = 5;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            inv.func_70299_a(i, ItemStack.field_190927_a);
            if (itemStack.func_190926_b()) continue;
            ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(itemStack);
            iss.split(itemStack.func_77973_b() == this.door ? 1 : left);
            itemStacks.set(i, (Object)iss.source);
            if (itemStack.func_77973_b() == this.door) continue;
            left -= iss.amount;
        }
        return itemStacks;
    }

    public static class Factory
    implements IRecipeFactory {
        public BigDoorRecipe parse(JsonContext context, JsonObject json) {
            ItemStack itemStack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"door"), (JsonContext)context);
            if (!(itemStack.func_77973_b() instanceof ItemDoor)) {
                throw new JsonParseException("Ingredient specified is not a door : " + itemStack.func_77973_b().getRegistryName());
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            if (!(result.func_77973_b() instanceof ItemBlock) || !(((ItemBlock)result.func_77973_b()).func_179223_d() instanceof BigDoor)) {
                throw new JsonParseException("Ingredient specified is not a BigDoor : " + result.func_77973_b().getRegistryName());
            }
            return new BigDoorRecipe((ItemDoor)itemStack.func_77973_b(), result);
        }
    }
}

