/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtil {
    private static boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
    private static boolean isRFLoaded = EnergyConfigHandler.isRFAPILoaded();
    private static boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded();
    private static boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded();
    private static boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
    private static boolean isIC2TileLoaded = false;
    private static boolean isBCReallyLoaded = EnergyConfigHandler.isBuildcraftLoaded();
    public static boolean voltageParameterIC2 = false;
    public static Method demandedEnergyIC2 = null;
    public static Method injectEnergyIC2 = null;
    public static Method offeredEnergyIC2 = null;
    public static Method drawEnergyIC2 = null;
    public static Class<?> clazzIC2EnergyTile = null;
    public static Class<?> clazzIC2Cable = null;
    public static Class<?> clazzMekCable = null;
    public static Class<?> clazzEnderIOCable = null;
    public static Class<?> clazzMFRRednetEnergyCable = null;
    public static Class<?> clazzRailcraftEngine = null;
    private static Class<?> clazzPipeTile = null;
    private static Class<?> clazzPipeWood = null;
    public static boolean initialisedIC2Methods = EnergyUtil.initialiseIC2Methods();
    private static Field fieldCableAcceptor = null;
    public static Field fieldEnergyStorage = null;
    public static Field fieldCableOutput = null;
    private static Capability<IStrictEnergyAcceptor> mekCableAcceptor = null;
    public static Capability<IStrictEnergyStorage> mekEnergyStorage = null;
    public static Capability<IStrictEnergyOutputter> mekCableOutput = null;
    public static Capability<ITubeConnection> mekTubeConnection = null;
    public static Capability<IGasHandler> mekGasHandler = null;
    public static Class<?> mekCapabilities;

    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        BlockVec3 thisVec = new BlockVec3(tile);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            IEnergyStorage forgeEnergy;
            TileEntity tileEntity;
            if (tile instanceof IConductor && !((IConductor)tile).canConnect(direction, NetworkType.POWER) || (tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction)) == null) continue;
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.func_176734_d(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isMekLoaded && (tileEntity instanceof IStrictEnergyAcceptor || tileEntity instanceof IStrictEnergyOutputter)) {
                try {
                    if (clazzMekCable != null && clazzMekCable.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(direction.func_176734_d())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof IStrictEnergyOutputter) || !((IStrictEnergyOutputter)tileEntity).canOutputEnergy(direction.func_176734_d())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isBCReallyLoaded) {
                try {
                    if (clazzPipeTile != null && clazzPipeTile.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, MjAPI.CAP_CONNECTOR, direction.func_176734_d()) || EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, MjAPI.CAP_RECEIVER, direction.func_176734_d()) || EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, MjAPI.CAP_PASSIVE_PROVIDER, direction.func_176734_d())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
            }
            if (isRFLoaded && tileEntity instanceof IEnergyConnection) {
                if ((!isRF2Loaded || !(tileEntity instanceof IEnergyProvider) && !(tileEntity instanceof IEnergyReceiver)) && (!isRF1Loaded || !(tileEntity instanceof IEnergyHandler)) && (clazzRailcraftEngine == null || !clazzRailcraftEngine.isInstance(tileEntity)) || clazzMFRRednetEnergyCable != null && clazzMFRRednetEnergyCable.isInstance(tileEntity) || !((IEnergyConnection)tileEntity).canConnectEnergy(direction.func_176734_d())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isIC2Loaded) {
                if (tileEntity instanceof IEnergyConductor) continue;
                if (!tile.func_145831_w().field_72995_K) {
                    TileEntity IC2tile = tileEntity;
                    BlockPos checkingIC2 = thisVec.toBlockPos().func_177972_a(direction);
                    try {
                        IC2tile = EnergyNet.instance.getSubTile(tile.func_145831_w(), checkingIC2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (IC2tile instanceof IEnergyAcceptor && tile instanceof IEnergyEmitter) {
                        if (!((IEnergyAcceptor)IC2tile).acceptsEnergyFrom((IEnergyEmitter)tile, direction.func_176734_d())) continue;
                        adjacentConnections[direction.ordinal()] = tileEntity;
                        continue;
                    }
                    if (IC2tile instanceof IEnergyEmitter && tile instanceof IEnergyAcceptor) {
                        if (!((IEnergyEmitter)IC2tile).emitsEnergyTo((IEnergyAcceptor)tile, direction.func_176734_d())) continue;
                        adjacentConnections[direction.ordinal()] = tileEntity;
                        continue;
                    }
                } else {
                    try {
                        Class<?> clazz;
                        if (clazz.getName().startsWith("ic2")) {
                            Set connections;
                            if (clazz.getName().startsWith("ic2.core.block.wiring.TileEntityTransformer")) {
                                adjacentConnections[direction.ordinal()] = tileEntity;
                                continue;
                            }
                            Field energyField = null;
                            block9: for (clazz = tileEntity.getClass(); energyField == null && clazz != null; clazz = clazz.getSuperclass()) {
                                for (Field f : clazz.getDeclaredFields()) {
                                    if (!f.getName().equals("energy")) continue;
                                    energyField = f;
                                    break block9;
                                }
                            }
                            energyField.setAccessible(true);
                            Object energy = energyField.get(tileEntity);
                            if (tile instanceof IEnergyEmitter && (connections = (Set)energy.getClass().getMethod("getSinkDirs", new Class[0]).invoke(energy, new Object[0])).contains(direction.func_176734_d())) {
                                adjacentConnections[direction.ordinal()] = tileEntity;
                                continue;
                            }
                            if (tile instanceof IEnergyAcceptor && (connections = (Set)energy.getClass().getMethod("getSourceDirs", new Class[0]).invoke(energy, new Object[0])).contains(direction.func_176734_d())) {
                                adjacentConnections[direction.ordinal()] = tileEntity;
                                continue;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, direction.func_176734_d()) || clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity) || (forgeEnergy = (IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, direction.func_176734_d())) == null || (!forgeEnergy.canReceive() || EnergyConfigHandler.disableFEOutput) && (!forgeEnergy.canExtract() || EnergyConfigHandler.disableFEInput)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static void setAdjacentPowerConnections(TileEntity conductor, List<Object> connectedAcceptors, List<EnumFacing> directions) throws Exception {
        BlockVec3 thisVec = new BlockVec3(conductor);
        World world = conductor.func_145831_w();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            IEnergyStorage forgeEnergy;
            TileEntity tileEntity = thisVec.getTileEntityOnSide(world, direction);
            if (tileEntity == null || tileEntity instanceof IConductor) continue;
            EnumFacing sideFrom = direction.func_176734_d();
            if (tileEntity instanceof IElectrical) {
                if (!((IElectrical)tileEntity).canConnect(sideFrom, NetworkType.POWER)) continue;
                connectedAcceptors.add(tileEntity);
                directions.add(sideFrom);
                continue;
            }
            if (isMekLoaded && tileEntity instanceof IStrictEnergyAcceptor) {
                if (clazzMekCable != null && clazzMekCable.isInstance(tileEntity) || !((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(sideFrom)) continue;
                connectedAcceptors.add(tileEntity);
                directions.add(sideFrom);
                continue;
            }
            if (isIC2Loaded && !world.field_72995_K) {
                IEnergyTile IC2tile = null;
                BlockPos checkingIC2 = thisVec.toBlockPos().func_177972_a(direction);
                try {
                    IC2tile = EnergyNet.instance.getSubTile(world, checkingIC2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (IC2tile instanceof IEnergyConductor) continue;
                if (IC2tile instanceof IEnergyAcceptor) {
                    if (!((IEnergyAcceptor)IC2tile).acceptsEnergyFrom((IEnergyEmitter)conductor, sideFrom)) continue;
                    connectedAcceptors.add(IC2tile);
                    directions.add(sideFrom);
                    continue;
                }
            }
            if (isBCReallyLoaded) {
                if (clazzPipeTile != null && clazzPipeTile.isInstance(tileEntity)) continue;
                if (EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, MjAPI.CAP_RECEIVER, sideFrom)) {
                    IMjReceiver bcReceiver = (IMjReceiver)EnergyUtil.getCapability((ICapabilityProvider)tileEntity, MjAPI.CAP_RECEIVER, sideFrom);
                    connectedAcceptors.add(bcReceiver);
                    directions.add(sideFrom);
                    continue;
                }
            }
            if (isRF2Loaded && tileEntity instanceof IEnergyReceiver || isRF1Loaded && tileEntity instanceof IEnergyHandler) {
                if (clazzMFRRednetEnergyCable != null && clazzMFRRednetEnergyCable.isInstance(tileEntity) || !((IEnergyConnection)tileEntity).canConnectEnergy(sideFrom)) continue;
                connectedAcceptors.add(tileEntity);
                directions.add(sideFrom);
                continue;
            }
            if (EnergyConfigHandler.disableFEOutput || !EnergyUtil.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, sideFrom) || clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity) || (forgeEnergy = (IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, sideFrom)) == null || !forgeEnergy.canReceive()) continue;
            connectedAcceptors.add(forgeEnergy);
            directions.add(sideFrom);
        }
    }

    public static float otherModsEnergyTransfer(TileEntity tileAdj, EnumFacing inputAdj, float toSend, boolean simulate) {
        if (isMekLoaded && !EnergyConfigHandler.disableMekanismOutput) {
            IStrictEnergyAcceptor tileMek = null;
            if (mekCableAcceptor == null) {
                EnergyUtil.initialiseMekCapabilities();
            }
            if (tileAdj instanceof IStrictEnergyAcceptor) {
                tileMek = (IStrictEnergyAcceptor)tileAdj;
            } else if (mekCableAcceptor != null && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, mekCableAcceptor, inputAdj)) {
                tileMek = EnergyUtil.getCapability((ICapabilityProvider)tileAdj, mekCableAcceptor, inputAdj);
            }
            if (tileMek != null && tileMek.canReceiveEnergy(inputAdj)) {
                float transferredMek = (float)tileMek.acceptEnergy(inputAdj, (double)(toSend * EnergyConfigHandler.TO_MEKANISM_RATIO), simulate);
                return transferredMek / EnergyConfigHandler.TO_MEKANISM_RATIO;
            }
        } else if (isIC2Loaded && !EnergyConfigHandler.disableIC2Output && tileAdj instanceof IEnergySink) {
            double demanded;
            block19: {
                demanded = 0.0;
                try {
                    demanded = (Double)demandedEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block19;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toSend, (float)demanded / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toSend * EnergyConfigHandler.TO_IC2_RATIO), demanded);
            if (energySendingIC2 >= 1.0) {
                double result;
                block20: {
                    result = 0.0;
                    try {
                        result = voltageParameterIC2 ? energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2, 120.0) : energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block20;
                        ex.printStackTrace();
                    }
                }
                if (result < 0.0) {
                    return 0.0f;
                }
                return (float)result / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            IEnergyStorage forgeEnergy;
            if (isBCReallyLoaded && !EnergyConfigHandler.disableBuildCraftOutput && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_RECEIVER, inputAdj)) {
                IMjReceiver bcReceiver = (IMjReceiver)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_RECEIVER, inputAdj);
                long toSendBC = Math.min((long)(toSend * EnergyConfigHandler.TO_BC_RATIO), bcReceiver.getPowerRequested());
                float sent = (float)(toSendBC - bcReceiver.receivePower(toSendBC, simulate)) / EnergyConfigHandler.TO_BC_RATIO;
                return sent;
            }
            if (isRF2Loaded && !EnergyConfigHandler.disableRFOutput && tileAdj instanceof IEnergyReceiver) {
                float sent = (float)((IEnergyReceiver)tileAdj).receiveEnergy(inputAdj, (int)Math.floor(toSend * EnergyConfigHandler.TO_RF_RATIO), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
            if (!EnergyConfigHandler.disableFEOutput && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj) && (forgeEnergy = (IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj)) != null && forgeEnergy.canReceive()) {
                float sent = (float)forgeEnergy.receiveEnergy((int)Math.floor(toSend * EnergyConfigHandler.TO_RF_RATIO), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
        }
        return 0.0f;
    }

    public static float otherModsEnergyExtract(TileEntity tileAdj, EnumFacing inputAdj, float toPull, boolean simulate) {
        if (isIC2Loaded && !EnergyConfigHandler.disableIC2Input && tileAdj instanceof IEnergySource) {
            double offered;
            block12: {
                offered = 0.0;
                try {
                    offered = (Double)offeredEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block12;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toPull, (float)offered / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toPull * EnergyConfigHandler.TO_IC2_RATIO), offered);
            if (energySendingIC2 >= 1.0) {
                double resultIC2;
                block13: {
                    resultIC2 = 0.0;
                    try {
                        resultIC2 = energySendingIC2 - (Double)drawEnergyIC2.invoke((Object)tileAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block13;
                        ex.printStackTrace();
                    }
                }
                if (resultIC2 < 0.0) {
                    resultIC2 = 0.0;
                }
                return (float)resultIC2 / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            IEnergyStorage forgeEnergy;
            if (isBCReallyLoaded && !EnergyConfigHandler.disableBuildCraftInput && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_PASSIVE_PROVIDER, inputAdj)) {
                IMjPassiveProvider bcEmitter = (IMjPassiveProvider)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_PASSIVE_PROVIDER, inputAdj);
                long toSendBC = (long)(toPull * EnergyConfigHandler.TO_BC_RATIO);
                float sent = (float)bcEmitter.extractPower(toSendBC, toSendBC, simulate) / EnergyConfigHandler.TO_BC_RATIO;
                return sent;
            }
            if (isRF2Loaded && !EnergyConfigHandler.disableRFInput && tileAdj instanceof IEnergyProvider) {
                float sent = (float)((IEnergyProvider)tileAdj).extractEnergy(inputAdj, (int)Math.floor(toPull * EnergyConfigHandler.TO_RF_RATIO), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
            if (!EnergyConfigHandler.disableFEInput && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj) && (forgeEnergy = (IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj)) != null && forgeEnergy.canExtract()) {
                float sent = (float)forgeEnergy.extractEnergy((int)Math.floor(toPull * EnergyConfigHandler.TO_RF_RATIO), simulate) / EnergyConfigHandler.TO_RF_RATIO;
                return sent;
            }
        }
        return 0.0f;
    }

    public static boolean otherModCanReceive(TileEntity tileAdj, EnumFacing inputAdj) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isMekLoaded && tileAdj instanceof IStrictEnergyAcceptor) {
            return ((IStrictEnergyAcceptor)tileAdj).canReceiveEnergy(inputAdj);
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyAcceptor) {
            return ((IEnergyAcceptor)tileAdj).acceptsEnergyFrom(null, inputAdj);
        }
        if (isBCReallyLoaded && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_RECEIVER, inputAdj)) {
            IMjReceiver bcReceiver = (IMjReceiver)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_RECEIVER, inputAdj);
            return bcReceiver.canReceive();
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(inputAdj);
        }
        if (EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj)) {
            return ((IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, inputAdj)).canReceive();
        }
        return false;
    }

    public static boolean otherModCanProduce(TileEntity tileAdj, EnumFacing side) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)tileAdj).emitsEnergyTo(null, side);
        }
        if (isBCReallyLoaded && EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, MjAPI.CAP_PASSIVE_PROVIDER, side)) {
            return true;
        }
        if (EnergyUtil.hasCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)EnergyUtil.getCapability((ICapabilityProvider)tileAdj, CapabilityEnergy.ENERGY, side)).canExtract();
        }
        return false;
    }

    public static boolean initialiseIC2Methods() {
        try {
            clazzMekCable = Class.forName("codechicken.multipart.TileMultipart");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzEnderIOCable = Class.forName("crazypants.enderio.conduits.conduit.TileConduitBundle");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzMFRRednetEnergyCable = Class.forName("powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzRailcraftEngine = Class.forName("mods.railcraft.common.blocks.machine.beta.TileEngine");
        }
        catch (Exception exception) {
            // empty catch block
        }
        clazzPipeTile = CompatibilityManager.classBCTransportPipeTile;
        try {
            clazzPipeWood = Class.forName("buildcraft.transport.pipes.PipePowerWood");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isMekLoaded) {
            try {
                mekCapabilities = Class.forName("mekanism.common.capabilities.Capabilities");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isIC2Loaded) {
            GCLog.debug("Initialising IC2 methods OK");
            try {
                clazzIC2EnergyTile = Class.forName("ic2.core.energy.Tile");
                if (clazzIC2EnergyTile != null) {
                    isIC2TileLoaded = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazzIC2Cable = Class.forName("ic2.api.energy.tile.IEnergyConductor");
                Class<?> clazz = Class.forName("ic2.api.energy.tile.IEnergySink");
                GCLog.debug("Found IC2 IEnergySink class OK");
                try {
                    demandedEnergyIC2 = clazz.getMethod("getDemandedEnergy", new Class[0]);
                }
                catch (Exception e) {
                    try {
                        demandedEnergyIC2 = clazz.getMethod("demandedEnergyUnits", new Class[0]);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                GCLog.debug("Set IC2 demandedEnergy method OK");
                try {
                    injectEnergyIC2 = clazz.getMethod("injectEnergy", EnumFacing.class, Double.TYPE, Double.TYPE);
                    voltageParameterIC2 = true;
                    GCLog.debug("Set IC2 injectEnergy method OK");
                }
                catch (Exception e) {
                    try {
                        injectEnergyIC2 = clazz.getMethod("injectEnergyUnits", EnumFacing.class, Double.TYPE);
                        GCLog.debug("IC2 inject 1.7.2 succeeded");
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                Class<?> clazzSource = Class.forName("ic2.api.energy.tile.IEnergySource");
                offeredEnergyIC2 = clazzSource.getMethod("getOfferedEnergy", new Class[0]);
                drawEnergyIC2 = clazzSource.getMethod("drawEnergy", Double.TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static boolean isElectricItem(Item item) {
        if (item instanceof IItemElectric) {
            return true;
        }
        if (item == null) {
            return false;
        }
        if (EnergyConfigHandler.isRFAPILoaded() && item instanceof IEnergyContainerItem) {
            return true;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            if (item instanceof IElectricItem) {
                return true;
            }
            if (item instanceof ISpecialElectricItem) {
                return true;
            }
        }
        return EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem;
    }

    public static boolean isChargedElectricItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemElectric) {
            return ((IItemElectric)item).getElectricityStored(stack) > 0.0f;
        }
        if (item == Items.field_190931_a) {
            return false;
        }
        if (EnergyConfigHandler.isRFAPILoaded() && item instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)item).getEnergyStored(stack) > 0;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            if (item instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)item;
                return electricItem.getManager(stack).discharge(stack, Double.POSITIVE_INFINITY, 3, true, true, true) > 0.0;
            }
            if (item instanceof IElectricItem) {
                IElectricItem electricItem = (IElectricItem)item;
                return electricItem.canProvideEnergy(stack);
            }
        }
        if (EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem) {
            return ((IEnergizedItem)item).getEnergy(stack) > 0.0;
        }
        return false;
    }

    public static boolean isFillableElectricItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemElectric) {
            return ((IItemElectric)item).getElectricityStored(stack) < ((IItemElectric)item).getMaxElectricityStored(stack);
        }
        if (item == Items.field_190931_a) {
            return false;
        }
        if (EnergyConfigHandler.isRFAPILoaded() && item instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)item).getEnergyStored(stack) < ((IEnergyContainerItem)item).getMaxEnergyStored(stack);
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            if (item instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)item;
                return electricItem.getManager(stack).charge(stack, Double.POSITIVE_INFINITY, 3, true, true) > 0.0;
            }
            if (item instanceof IElectricItem) {
                IElectricItem electricItem = (IElectricItem)item;
                return electricItem.canProvideEnergy(stack);
            }
        }
        if (EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem) {
            return ((IEnergizedItem)item).getEnergy(stack) < ((IEnergizedItem)item).getMaxEnergy(stack);
        }
        return false;
    }

    public static boolean hasCapability(ICapabilityProvider provider, Capability<?> capability, EnumFacing side) {
        return provider == null || capability == null ? false : provider.hasCapability(capability, side);
    }

    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> capability, EnumFacing side) {
        return (T)(provider == null || capability == null ? null : provider.getCapability(capability, side));
    }

    public static void initialiseMekCapabilities() {
        try {
            Field gasTubeConnection;
            Field gasHandlerCapability;
            fieldCableAcceptor = mekCapabilities.getField("ENERGY_ACCEPTOR_CAPABILITY");
            if (fieldCableAcceptor != null) {
                mekCableAcceptor = (Capability)fieldCableAcceptor.get(null);
            }
            if ((fieldEnergyStorage = mekCapabilities.getField("ENERGY_STORAGE_CAPABILITY")) != null) {
                mekEnergyStorage = (Capability)fieldEnergyStorage.get(null);
            }
            if ((gasHandlerCapability = mekCapabilities.getField("GAS_HANDLER_CAPABILITY")) != null) {
                mekGasHandler = (Capability)gasHandlerCapability.get(null);
            }
            if ((gasTubeConnection = mekCapabilities.getField("TUBE_CONNECTION_CAPABILITY")) != null) {
                mekTubeConnection = (Capability)gasTubeConnection.get(null);
            }
            if ((fieldCableOutput = mekCapabilities.getField("ENERGY_OUTPUTTER_CAPABILITY")) != null) {
                mekCableOutput = (Capability)fieldCableOutput.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkMekGasHandler(Capability<?> capability) {
        if (!EnergyConfigHandler.isMekanismLoaded() || capability == null || mekCapabilities == null) {
            return false;
        }
        if (mekGasHandler == null) {
            EnergyUtil.initialiseMekCapabilities();
        }
        return capability == mekGasHandler || capability == mekTubeConnection;
    }
}

