/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CircuitFabricatorRecipes {
    private static List<NonNullList<Object>> recipeInputs = new ArrayList<NonNullList<Object>>();
    private static List<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
    public static ArrayList<ArrayList<ItemStack>> slotValidItems = new ArrayList(5);

    public static void addRecipe(ItemStack output, List<Object> inputList) {
        if (inputList.size() != 5) {
            throw new RuntimeException("Invalid circuit fabricator recipe!  Inputs length should be 5, was " + inputList.size());
        }
        for (Object o : inputList) {
            if (o == null || o instanceof ItemStack || o instanceof List && ((List)o).size() > 0) continue;
            throw new RuntimeException("Invalid circuit fabricator recipe!  Input must be ItemStack or List<ItemStack>: " + o.toString());
        }
        NonNullList inputs = NonNullList.func_191196_a();
        inputs.addAll(inputList);
        recipeInputs.add((NonNullList<Object>)inputs);
        recipeOutputs.add(output);
        CircuitFabricatorRecipes.validateItems(inputList);
    }

    private static void validateItems(List<Object> inputList) {
        int i;
        if (slotValidItems.size() == 0) {
            for (i = 0; i < 5; ++i) {
                ArrayList entry = new ArrayList(3);
                slotValidItems.add(entry);
            }
        }
        for (i = 0; i < 5; ++i) {
            Object input = inputList.get(i);
            if (input instanceof ItemStack) {
                CircuitFabricatorRecipes.validateItem(i, (ItemStack)input);
                continue;
            }
            if (!(input instanceof List)) continue;
            for (ItemStack stack : (List)input) {
                CircuitFabricatorRecipes.validateItem(i, stack);
            }
        }
    }

    private static void validateItem(int i, ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return;
        }
        ArrayList<ItemStack> validItems = slotValidItems.get(i);
        boolean found = false;
        for (int j = 0; j < validItems.size(); ++j) {
            if (!inputStack.func_77969_a(validItems.get(j))) continue;
            found = true;
            break;
        }
        if (!found) {
            validItems.add(inputStack.func_77946_l());
        }
    }

    public static ItemStack getOutputForInput(List<ItemStack> inputList) {
        if (inputList.size() != 5) {
            return ItemStack.field_190927_a;
        }
        int count = 0;
        for (NonNullList<Object> recipe : recipeInputs) {
            boolean found = true;
            for (int i = 0; i < 5; ++i) {
                Object recipeStack = recipe.get(i);
                ItemStack inputStack = inputList.get(i);
                if (recipeStack instanceof ItemStack && ((ItemStack)recipeStack).func_190926_b() || inputStack.func_190926_b()) {
                    if (recipeStack instanceof ItemStack && ((ItemStack)recipeStack).func_190926_b() && inputStack.func_190926_b()) continue;
                    found = false;
                    break;
                }
                if (recipeStack instanceof ItemStack) {
                    ItemStack stack = (ItemStack)recipeStack;
                    if (stack.func_77973_b() == inputStack.func_77973_b() && stack.func_77952_i() == inputStack.func_77952_i() && RecipeUtil.areItemStackTagsEqual(stack, inputStack)) continue;
                    found = false;
                    break;
                }
                if (!(recipeStack instanceof List)) continue;
                boolean listMatchOne = false;
                for (ItemStack stack : (List)recipeStack) {
                    if (stack.func_77973_b() != inputStack.func_77973_b() || stack.func_77952_i() != inputStack.func_77952_i() || !RecipeUtil.areItemStackTagsEqual(stack, inputStack)) continue;
                    listMatchOne = true;
                    break;
                }
                if (listMatchOne) continue;
                found = false;
                break;
            }
            if (found) {
                return recipeOutputs.get(count);
            }
            ++count;
        }
        return ItemStack.field_190927_a;
    }

    public static List<NonNullList<Object>> getRecipes() {
        return recipeInputs;
    }

    public static ItemStack getOutput(int count) {
        return recipeOutputs.get(count);
    }

    public static void removeRecipe(ItemStack match) {
        int count = 0;
        for (ItemStack output : new ArrayList<ItemStack>(recipeOutputs)) {
            if (ItemStack.func_77989_b((ItemStack)match, (ItemStack)output)) {
                recipeInputs.remove(count);
                recipeOutputs.remove(count);
                continue;
            }
            ++count;
        }
    }

    public static void replaceRecipeIngredient(ItemStack ingredient, List<ItemStack> replacement) {
        if (ingredient == null) {
            return;
        }
        slotValidItems.clear();
        List<ItemStack> newIngredient = replacement;
        for (NonNullList<Object> recipe : recipeInputs) {
            block1: for (int i = 0; i < 5; ++i) {
                Object recipeStack = recipe.get(i);
                if (recipeStack == null) continue;
                if (recipeStack instanceof ItemStack) {
                    ItemStack stack = (ItemStack)recipeStack;
                    if (stack.func_77973_b() != ingredient.func_77973_b() || stack.func_77952_i() != ingredient.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)ingredient)) continue;
                    recipe.set(i, newIngredient);
                    continue;
                }
                if (!(recipeStack instanceof List)) continue;
                boolean listMatchOne = false;
                for (ItemStack stack : (List)recipeStack) {
                    if (stack.func_77973_b() != ingredient.func_77973_b() || stack.func_77952_i() != ingredient.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)ingredient)) continue;
                    recipe.set(i, newIngredient);
                    continue block1;
                }
            }
            CircuitFabricatorRecipes.validateItems(recipe);
        }
    }
}

