/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Sphere
implements IShape {
    private Coord start;
    private Coord end;

    public Sphere(Coord start, Coord end) {
        this.start = new Coord(start);
        this.end = new Coord(end);
    }

    @Override
    public Iterator<Coord> iterator() {
        return new SphereIterator(this.start, this.end);
    }

    @Override
    public void fill(IWorldEditor editor, Random rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, Random rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> copy = new ArrayList<Coord>();
        for (Coord pos : this) {
            copy.add(pos);
        }
        return copy;
    }

    private class SphereIterator
    implements Iterator<Coord> {
        private Coord centre;
        private int radius;
        private int layer;
        private int row;
        private int col;
        private Cardinal dir;
        private boolean top;

        public SphereIterator(Coord centre, Coord end) {
            this.centre = new Coord(centre);
            Coord s = new Coord(centre);
            Coord e = new Coord(end);
            Coord.correct(s, e);
            Coord diff = e.sub(s);
            int r = diff.getX();
            r = r < diff.getY() ? diff.getY() : r;
            this.radius = r = r < diff.getZ() ? diff.getZ() : r;
            this.layer = 0;
            this.row = 0;
            this.col = 0;
            this.top = true;
            this.dir = Cardinal.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.layer < this.radius;
        }

        @Override
        public Coord next() {
            Coord toReturn = new Coord(this.centre);
            toReturn.add(this.top ? Cardinal.UP : Cardinal.DOWN, this.layer);
            toReturn.add(this.dir, this.row);
            toReturn.add(Cardinal.left(this.dir), this.col);
            if (this.dir != Cardinal.NORTH || this.top) {
                if (this.dir == Cardinal.NORTH) {
                    this.top = false;
                }
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            ++this.col;
            if (this.inRange(this.col, this.layer, this.row)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.col = 0;
            ++this.row;
            if (this.inRange(this.col, this.layer, this.row)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.row = 0;
            ++this.layer;
            this.dir = Cardinal.left(this.dir);
            this.top = true;
            return toReturn;
        }

        private boolean inRange(int x, int y, int z) {
            return x * x + y * y + z * z < this.radius * this.radius;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

