/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockColumns
extends BlockBase {
    private List<IBlockFactory> blocks = new ArrayList<IBlockFactory>();

    public BlockColumns() {
    }

    public BlockColumns(JsonElement data) throws Exception {
        this();
        for (JsonElement entry : (JsonArray)data) {
            this.addBlock(BlockProvider.create(entry.getAsJsonObject()));
        }
    }

    public void addBlock(IBlockFactory toAdd) {
        this.blocks.add(toAdd);
    }

    @Override
    public boolean set(IWorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        int size = this.blocks.size();
        int choice = Math.abs(pos.getX() % size + pos.getZ() % size) % size;
        IBlockFactory block = this.blocks.get(choice);
        return block.set(editor, rand, pos, fillAir, replaceSolid);
    }
}

