/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.IDungeonFactory;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.segment.ISegmentGenerator;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.filter.Filter;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LevelSettings {
    private static final int NUM_ROOMS = 12;
    private static final int LEVEL_RANGE = 80;
    private static final int SCATTER = 12;
    private int numRooms;
    private int range;
    private int scatter;
    private int levelDifficulty;
    private DungeonFactory rooms;
    private SecretFactory secrets;
    private ITheme theme;
    private SegmentGenerator segments;
    private SpawnerSettings spawners;
    private LevelGenerator generator;
    private Set<Filter> filters;

    public LevelSettings() {
        this.numRooms = 12;
        this.range = 80;
        this.scatter = 12;
        this.spawners = new SpawnerSettings();
        this.rooms = new DungeonFactory();
        this.secrets = new SecretFactory();
        this.filters = new HashSet<Filter>();
        this.levelDifficulty = -1;
    }

    public LevelSettings(LevelSettings toCopy) {
        this.init(toCopy);
    }

    private void init(LevelSettings toCopy) {
        this.numRooms = toCopy.numRooms;
        this.range = toCopy.range;
        this.scatter = toCopy.scatter;
        this.levelDifficulty = toCopy.levelDifficulty;
        this.rooms = toCopy.rooms != null ? new DungeonFactory(toCopy.rooms) : null;
        this.secrets = toCopy.secrets != null ? new SecretFactory(toCopy.secrets) : null;
        this.theme = toCopy.theme != null ? toCopy.theme : null;
        this.segments = toCopy.segments != null ? new SegmentGenerator(toCopy.segments) : null;
        this.spawners = new SpawnerSettings(toCopy.spawners);
        this.filters = new HashSet<Filter>();
        this.filters.addAll(toCopy.filters);
        this.generator = toCopy.generator;
    }

    public LevelSettings(LevelSettings base, LevelSettings other, Set<SettingsType> overrides) {
        this();
        if (base == null && other == null) {
            return;
        }
        if (base == null && other != null) {
            this.init(other);
            return;
        }
        if (base != null && other == null) {
            this.init(base);
            return;
        }
        this.numRooms = other.numRooms != base.numRooms && other.numRooms != 12 ? other.numRooms : base.numRooms;
        this.range = other.range != base.range && other.range != 80 ? other.range : base.range;
        this.scatter = other.scatter != base.scatter && other.scatter != 12 ? other.scatter : base.scatter;
        this.levelDifficulty = base.levelDifficulty != other.levelDifficulty && other.levelDifficulty != -1 || base.levelDifficulty == -1 ? other.levelDifficulty : base.levelDifficulty;
        this.rooms = overrides.contains((Object)SettingsType.ROOMS) ? new DungeonFactory(base.rooms) : new DungeonFactory(base.rooms, other.rooms);
        this.secrets = overrides.contains((Object)SettingsType.SECRETS) ? new SecretFactory(other.secrets) : new SecretFactory(base.secrets, other.secrets);
        if (other.theme != null) {
            this.theme = base.theme == null || overrides.contains((Object)SettingsType.THEMES) ? Theme.create(other.theme) : Theme.create(base.theme, other.theme);
        } else if (base.theme != null) {
            this.theme = Theme.create(base.theme);
        }
        if (base.segments != null || other.segments != null) {
            this.segments = other.segments == null ? new SegmentGenerator(base.segments) : new SegmentGenerator(other.segments);
        }
        this.spawners = new SpawnerSettings(base.spawners, other.spawners);
        this.generator = other.generator == null ? base.generator : other.generator;
        this.filters.addAll(base.filters);
        this.filters.addAll(other.filters);
    }

    public LevelGenerator getGenerator() {
        return this.generator != null ? this.generator : LevelGenerator.CLASSIC;
    }

    public void setGenerator(LevelGenerator type) {
        this.generator = type;
    }

    public int getScatter() {
        return this.scatter;
    }

    public void setScatter(int scatter) {
        this.scatter = scatter;
    }

    public int getNumRooms() {
        return this.numRooms;
    }

    public void setNumRooms(int num) {
        this.numRooms = num;
    }

    public int getDifficulty(Coord pos) {
        if (this.levelDifficulty == -1) {
            return Dungeon.getLevel(pos.getY());
        }
        return this.levelDifficulty;
    }

    public void setDifficulty(int num) {
        this.levelDifficulty = num;
    }

    public IDungeonFactory getRooms() {
        return this.rooms != null ? this.rooms : new DungeonFactory();
    }

    public void setRooms(DungeonFactory rooms) {
        this.rooms = rooms;
    }

    public SecretFactory getSecrets() {
        return this.secrets != null ? this.secrets : new SecretFactory();
    }

    public void setSecrets(SecretFactory secrets) {
        this.secrets = secrets;
    }

    public ISegmentGenerator getSegments() {
        return this.segments != null ? this.segments : new SegmentGenerator();
    }

    public void setSegments(SegmentGenerator segments) {
        this.segments = segments;
    }

    public ITheme getTheme() {
        return this.theme != null ? this.theme : Theme.getTheme(Theme.STONE);
    }

    public void setTheme(ITheme theme) {
        this.theme = theme;
    }

    public SpawnerSettings getSpawners() {
        return this.spawners;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> toReturn = new ArrayList<Filter>();
        toReturn.addAll(this.filters);
        return toReturn;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public boolean equals(Object o) {
        LevelSettings other = (LevelSettings)o;
        if (other.generator != this.generator) {
            return false;
        }
        if (!this.secrets.equals(other.secrets)) {
            return false;
        }
        return this.rooms.equals(other.rooms);
    }
}

