/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.decorative;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.block.base.BlockButtonBase;
import com.progwml6.natura.common.block.base.BlockFenceBase;
import com.progwml6.natura.common.block.base.BlockFenceGateBase;
import com.progwml6.natura.common.block.base.BlockPressurePlateBase;
import com.progwml6.natura.common.block.base.BlockTrapDoorBase;
import com.progwml6.natura.decorative.block.bookshelves.BlockNetherBookshelves;
import com.progwml6.natura.decorative.block.bookshelves.BlockOverworldBookshelves;
import com.progwml6.natura.decorative.block.workbenches.BlockNetherWorkbenches;
import com.progwml6.natura.decorative.block.workbenches.BlockOverworldWorkbenches;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.library.enums.WoodTypes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaDecorative", description="Everything that's decorative for Natura. (bookshelfs, etc)")
public class NaturaDecorative
extends NaturaPulse {
    public static final String PulseId = "NaturaDecorative";
    static final Logger log = Util.getLogger("NaturaDecorative");
    @SidedProxy(clientSide="com.progwml6.natura.decorative.DecorativeClientProxy", serverSide="com.progwml6.natura.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block[] buttons;
    public static Block[] pressurePlates;
    public static Block[] trapDoors;
    public static Block[] fences;
    public static Block[] fenceGates;
    public static BlockOverworldBookshelves overworldBookshelves;
    public static BlockNetherBookshelves netherBookshelves;
    public static BlockOverworldWorkbenches overworldWorkbenches;
    public static BlockNetherWorkbenches netherWorkbenches;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        if (NaturaDecorative.isOverworldLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.OVERWORLD) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockButtonBase(), type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockPressurePlateBase(), type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockTrapDoorBase(), type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockFenceBase(), type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockFenceGateBase(), type.func_176610_l() + "_fence_gate");
            }
            overworldBookshelves = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockOverworldBookshelves(), "overworld_bookshelves");
            overworldWorkbenches = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockOverworldWorkbenches(), "overworld_workbenches");
        }
        if (NaturaDecorative.isNetherLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.NETHER) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockButtonBase(), type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockPressurePlateBase(), type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockTrapDoorBase(), type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockFenceBase(), type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockFenceGateBase(), type.func_176610_l() + "_fence_gate");
            }
            netherBookshelves = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockNetherBookshelves(), "nether_bookshelves");
            netherWorkbenches = NaturaDecorative.registerBlock((IForgeRegistry<Block>)registry, new BlockNetherWorkbenches(), "nether_workbenches");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (NaturaDecorative.isOverworldLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.OVERWORLD) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, buttons[type.ordinal()], type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, pressurePlates[type.ordinal()], type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, trapDoors[type.ordinal()], type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, fences[type.ordinal()], type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, fenceGates[type.ordinal()], type.func_176610_l() + "_fence_gate");
            }
            overworldBookshelves = NaturaDecorative.registerEnumItemBlock((IForgeRegistry<Item>)registry, overworldBookshelves, "overworld_bookshelves");
            overworldWorkbenches = NaturaDecorative.registerEnumItemBlock((IForgeRegistry<Item>)registry, overworldWorkbenches, "overworld_workbenches");
        }
        if (NaturaDecorative.isNetherLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.NETHER) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, buttons[type.ordinal()], type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, pressurePlates[type.ordinal()], type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, trapDoors[type.ordinal()], type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, fences[type.ordinal()], type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerItemBlock((IForgeRegistry<Item>)registry, fenceGates[type.ordinal()], type.func_176610_l() + "_fence_gate");
            }
            netherBookshelves = NaturaDecorative.registerEnumItemBlock((IForgeRegistry<Item>)registry, netherBookshelves, "nether_bookshelves");
            netherWorkbenches = NaturaDecorative.registerEnumItemBlock((IForgeRegistry<Item>)registry, netherWorkbenches, "nether_workbenches");
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    static {
        buttons = new Block[WoodTypes.values().length];
        pressurePlates = new Block[WoodTypes.values().length];
        trapDoors = new Block[WoodTypes.values().length];
        fences = new Block[WoodTypes.values().length];
        fenceGates = new Block[WoodTypes.values().length];
    }
}

