/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import java.io.File;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigManagerMars {
    public static boolean loaded;
    public static Configuration config;
    public static int dimensionIDMars;
    public static int idSchematicRocketT2;
    public static int idSchematicCargoRocket;
    public static boolean launchControllerChunkLoad;
    public static boolean launchControllerAllDims;
    public static boolean disableDeshGen;
    public static boolean disableTinGen;
    public static boolean disableCopperGen;
    public static boolean disableIronGen;

    public ConfigManagerMars(File file, boolean update) {
        if (!loaded) {
            config = new Configuration(file);
            ConfigManagerMars.syncConfig(true, update);
        }
    }

    public static void syncConfig(boolean load, boolean update) {
        try {
            if (!ConfigManagerMars.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDMars", -29);
            prop.setComment("Dimension ID for Mars");
            prop.setLanguageKey("gc.configgui.dimension_id_mars").setRequiresMcRestart(true);
            dimensionIDMars = prop.getInt();
            GalacticraftPlanets.finishProp(prop, "dimensions");
            prop = config.get("schematic", "idSchematicRocketT2", 2);
            prop.setComment("Schematic ID for Tier 2 Rocket, must be unique.");
            prop.setLanguageKey("gc.configgui.id_schematic_rocket_t2");
            idSchematicRocketT2 = prop.getInt(2);
            GalacticraftPlanets.finishProp(prop, "schematic");
            prop = config.get("schematic", "idSchematicCargoRocket", 3);
            prop.setComment("Schematic ID for Cargo Rocket, must be unique.");
            prop.setLanguageKey("gc.configgui.id_schematic_cargo_rocket");
            idSchematicCargoRocket = prop.getInt(3);
            GalacticraftPlanets.finishProp(prop, "schematic");
            prop = config.get("general", "launchControllerChunkLoad", true);
            prop.setComment("Whether or not the launch controller acts as a chunk loader. Will cause issues if disabled!");
            prop.setLanguageKey("gc.configgui.launch_controller_chunk_load");
            launchControllerChunkLoad = prop.getBoolean(true);
            GalacticraftPlanets.finishProp(prop, "general");
            prop = config.get("general", "launchControllerAllDims", false);
            prop.setComment("May rarely cause issues if enabled, depends on how the other mod's dimensions are.");
            prop.setLanguageKey("gc.configgui.launch_controller_all_dims");
            launchControllerAllDims = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "general");
            prop = config.get(update ? "general" : "worldgen", "Disable Iron Ore Gen on Mars", false);
            prop.setComment("Disable Iron Ore Gen on Mars.");
            prop.setLanguageKey("gc.configgui.disable_iron_gen_mars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableIronGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get(update ? "general" : "worldgen", "Disable Copper Ore Gen on Mars", false);
            prop.setComment("Disable Copper Ore Gen on Mars.");
            prop.setLanguageKey("gc.configgui.disable_copper_gen_mars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableCopperGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get(update ? "general" : "worldgen", "Disable Tin Ore Gen on Mars", false);
            prop.setComment("Disable Tin Ore Gen on Mars.");
            prop.setLanguageKey("gc.configgui.disable_tin_gen_mars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableTinGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get(update ? "general" : "worldgen", "Disable Desh Ore Gen on Mars", false);
            prop.setComment("Disable Desh Ore Gen on Mars.");
            prop.setLanguageKey("gc.configgui.disable_desh_gen_mars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableDeshGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Mars (Planets) has a problem loading its config", (Object[])new Object[0]);
        }
    }
}

