/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mezz.jei.api.IIngredientFilter;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.Config;
import mezz.jei.config.EditModeToggleEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilterBackgroundBuilder;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.startup.PlayerJoinedWorldEvent;
import mezz.jei.suffixtree.CombinedSearchTrees;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import mezz.jei.suffixtree.ISearchTree;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IngredientFilter
implements IIngredientFilter,
IIngredientGridSource {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IngredientBlacklistInternal blacklist;
    private final NonNullList<IIngredientListElement> elementList;
    private final GeneralizedSuffixTree searchTree;
    private final Char2ObjectMap<PrefixedSearchTree> prefixedSearchTrees = new Char2ObjectOpenHashMap();
    private final IngredientFilterBackgroundBuilder backgroundBuilder;
    private CombinedSearchTrees combinedSearchTrees;
    @Nullable
    private String filterCached;
    private List<IIngredientListElement> ingredientListCached = Collections.emptyList();
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public IngredientFilter(IngredientBlacklistInternal blacklist) {
        this.blacklist = blacklist;
        this.elementList = NonNullList.func_191196_a();
        this.searchTree = new GeneralizedSuffixTree();
        this.createPrefixedSearchTree('@', Config::getModNameSearchMode, IIngredientListElement::getModNameStrings);
        this.createPrefixedSearchTree('#', Config::getTooltipSearchMode, IIngredientListElement::getTooltipStrings);
        this.createPrefixedSearchTree('$', Config::getOreDictSearchMode, IIngredientListElement::getOreDictStrings);
        this.createPrefixedSearchTree('%', Config::getCreativeTabSearchMode, IIngredientListElement::getCreativeTabsStrings);
        this.createPrefixedSearchTree('^', Config::getColorSearchMode, IIngredientListElement::getColorStrings);
        this.createPrefixedSearchTree('&', Config::getResourceIdSearchMode, element -> Collections.singleton(element.getResourceId()));
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, (Collection<PrefixedSearchTree>)this.prefixedSearchTrees.values());
        this.backgroundBuilder = new IngredientFilterBackgroundBuilder(this.prefixedSearchTrees, this.elementList);
    }

    private static CombinedSearchTrees buildCombinedSearchTrees(ISearchTree searchTree, Collection<PrefixedSearchTree> prefixedSearchTrees) {
        CombinedSearchTrees combinedSearchTrees = new CombinedSearchTrees();
        combinedSearchTrees.addSearchTree(searchTree);
        for (PrefixedSearchTree prefixedTree : prefixedSearchTrees) {
            if (prefixedTree.getMode() != Config.SearchMode.ENABLED) continue;
            combinedSearchTrees.addSearchTree(prefixedTree.getTree());
        }
        return combinedSearchTrees;
    }

    private void createPrefixedSearchTree(char prefix, PrefixedSearchTree.IModeGetter modeGetter, PrefixedSearchTree.IStringsGetter stringsGetter) {
        GeneralizedSuffixTree tree = new GeneralizedSuffixTree();
        PrefixedSearchTree prefixedTree = new PrefixedSearchTree(tree, stringsGetter, modeGetter);
        this.prefixedSearchTrees.put(prefix, (Object)prefixedTree);
    }

    public void trimToSize() {
        this.searchTree.trimToSize();
        for (PrefixedSearchTree tree : this.prefixedSearchTrees.values()) {
            tree.getTree().trimToSize();
        }
    }

    public void addIngredients(NonNullList<IIngredientListElement> ingredients) {
        ingredients.sort((Comparator)IngredientListElementComparator.INSTANCE);
        long modNameCount = ingredients.stream().map(IIngredientListElement::getModNameForSorting).distinct().count();
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Indexing ingredients", (int)((int)modNameCount));
        String currentModName = null;
        for (IIngredientListElement element : ingredients) {
            String modname = element.getModNameForSorting();
            if (!Objects.equals(currentModName, modname)) {
                currentModName = modname;
                progressBar.step(modname);
            }
            this.addIngredient(element);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public <V> void addIngredient(IIngredientListElement<V> element) {
        this.updateHiddenState(element);
        int index = this.elementList.size();
        this.elementList.add(element);
        this.searchTree.put(Translator.toLowercaseWithLocale(element.getDisplayName()), index);
        for (PrefixedSearchTree prefixedSearchTree : this.prefixedSearchTrees.values()) {
            Config.SearchMode searchMode = prefixedSearchTree.getMode();
            if (searchMode == Config.SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchTree.getStringsGetter().getStrings(element);
            for (String string : strings) {
                prefixedSearchTree.getTree().put(string, index);
            }
        }
        this.filterCached = null;
    }

    public void invalidateCache() {
        this.filterCached = null;
    }

    public <V> List<IIngredientListElement<V>> findMatchingElements(IIngredientListElement<V> element) {
        IIngredientHelper<Object> ingredientHelper = element.getIngredientHelper();
        V ingredient = element.getIngredient();
        String ingredientUid = ingredientHelper.getUniqueId(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElement<V>> matchingElements = new ArrayList<IIngredientListElement<V>>();
        IntSet matchingIndexes = this.searchTree.search(Translator.toLowercaseWithLocale(element.getDisplayName()));
        IntIterator iterator = matchingIndexes.iterator();
        while (iterator.hasNext()) {
            Object castMatchingIngredient;
            String matchingUid;
            int index = iterator.nextInt();
            IIngredientListElement matchingElement = (IIngredientListElement)this.elementList.get(index);
            Object matchingIngredient = matchingElement.getIngredient();
            if (!ingredientClass.isInstance(matchingIngredient) || !ingredientUid.equals(matchingUid = ingredientHelper.getUniqueId(castMatchingIngredient = ingredientClass.cast(matchingIngredient)))) continue;
            IIngredientListElement matchingElementCast = matchingElement;
            matchingElements.add(matchingElementCast);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, (Collection<PrefixedSearchTree>)this.prefixedSearchTrees.values());
        this.backgroundBuilder.start();
        this.filterCached = null;
    }

    @SubscribeEvent
    public void onEditModeToggleEvent(EditModeToggleEvent event) {
        this.filterCached = null;
        this.updateHidden();
    }

    @SubscribeEvent
    public void onPlayerJoinedWorldEvent(PlayerJoinedWorldEvent event) {
        this.filterCached = null;
        this.updateHidden();
    }

    public void updateHidden() {
        for (IIngredientListElement element : this.elementList) {
            this.updateHiddenState(element);
        }
    }

    public <V> void updateHiddenState(IIngredientListElement<V> element) {
        IIngredientHelper<V> ingredientHelper;
        boolean visible;
        V ingredient = element.getIngredient();
        boolean bl = visible = !this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper = element.getIngredientHelper()) && ingredientHelper.isIngredientOnServer(ingredient) && (Config.isEditModeEnabled() || !Config.isIngredientOnConfigBlacklist(ingredient, ingredientHelper));
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            this.filterCached = null;
        }
    }

    @Override
    public List<IIngredientListElement> getIngredientList() {
        String filterText = Translator.toLowercaseWithLocale(Config.getFilterText());
        if (!filterText.equals(this.filterCached)) {
            List<IIngredientListElement> ingredientList = this.getIngredientListUncached(filterText);
            ingredientList.sort(IngredientListElementComparator.INSTANCE);
            this.ingredientListCached = Collections.unmodifiableList(ingredientList);
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    @Override
    public ImmutableList<Object> getFilteredIngredients() {
        List<IIngredientListElement> elements = this.getIngredientList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public void setFilterText(String filterText) {
        ErrorUtil.checkNotNull(filterText, "filterText");
        if (Config.setFilterText(filterText)) {
            this.notifyListenersOfChange();
        }
    }

    private List<IIngredientListElement> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        IntSet matches = null;
        for (String filter : filters) {
            IntSet elements = this.getElements(filter);
            if (elements == null) continue;
            if (matches == null) {
                matches = elements;
                continue;
            }
            matches.addAll((IntCollection)elements);
        }
        ArrayList<IIngredientListElement> matchingIngredients = new ArrayList<IIngredientListElement>();
        if (matches == null) {
            for (IIngredientListElement element : this.elementList) {
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        } else {
            int[] matchesList = matches.toIntArray();
            Arrays.sort(matchesList);
            for (int match : matchesList) {
                IIngredientListElement element = (IIngredientListElement)this.elementList.get(match);
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        }
        return matchingIngredients;
    }

    public <T> List<IIngredientListElement<T>> getMatches(IIngredientListElement<T> ingredientListElement, Function<IIngredientListElement<?>, String> uidFunction) {
        String uid = uidFunction.apply(ingredientListElement);
        List<IIngredientListElement<T>> matchingElements = this.findMatchingElements(ingredientListElement);
        IntOpenHashSet matchingIndexes = new IntOpenHashSet(50);
        IntOpenHashSet startingIndexes = new IntOpenHashSet(matchingElements.size());
        for (IIngredientListElement<T> matchingElement : matchingElements) {
            int index = this.elementList.indexOf(matchingElement);
            startingIndexes.add(index);
            matchingIndexes.add(index);
        }
        IntIterator iterator = startingIndexes.iterator();
        while (iterator.hasNext()) {
            IIngredientListElement castElement;
            IIngredientListElement element;
            String elementWildcardId;
            int i;
            int startingIndex = iterator.nextInt();
            for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i) && uid.equals(elementWildcardId = uidFunction.apply(element = (IIngredientListElement)this.elementList.get(i))); --i) {
                matchingIndexes.add(i);
                castElement = element;
                matchingElements.add(castElement);
            }
            for (i = startingIndex + 1; i < this.elementList.size() && !matchingIndexes.contains(i) && uid.equals(elementWildcardId = uidFunction.apply(element = (IIngredientListElement)this.elementList.get(i))); ++i) {
                matchingIndexes.add(i);
                castElement = element;
                matchingElements.add(castElement);
            }
        }
        return matchingElements;
    }

    @Nullable
    private IntSet getElements(String filterText) {
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        IntSet matches = null;
        IntSet removeMatches = null;
        while (filterMatcher.find()) {
            IntSet searchResults;
            String token = filterMatcher.group(1);
            boolean remove = token.startsWith("-");
            if (remove) {
                token = token.substring(1);
            }
            if ((searchResults = this.getSearchResults(token = QUOTE_PATTERN.matcher(token).replaceAll(""))) == null) continue;
            if (remove) {
                if (removeMatches == null) {
                    removeMatches = searchResults;
                    continue;
                }
                removeMatches.addAll((IntCollection)searchResults);
                continue;
            }
            if (!(matches = matches == null ? searchResults : IngredientFilter.intersection(matches, searchResults)).isEmpty()) continue;
            break;
        }
        if (matches != null && removeMatches != null) {
            matches.removeAll(removeMatches);
        }
        return matches;
    }

    @Nullable
    private IntSet getSearchResults(String token) {
        if (token.isEmpty()) {
            return null;
        }
        char firstChar = token.charAt(0);
        PrefixedSearchTree prefixedSearchTree = (PrefixedSearchTree)this.prefixedSearchTrees.get(firstChar);
        if (prefixedSearchTree != null && prefixedSearchTree.getMode() != Config.SearchMode.DISABLED) {
            if ((token = token.substring(1)).isEmpty()) {
                return null;
            }
            GeneralizedSuffixTree tree = prefixedSearchTree.getTree();
            return tree.search(token);
        }
        return this.combinedSearchTrees.search(token);
    }

    private static IntSet intersection(IntSet set1, IntSet set2) {
        if (set1.size() > set2.size()) {
            set2.retainAll((IntCollection)set1);
            return set2;
        }
        set1.retainAll((IntCollection)set2);
        return set1;
    }

    @Override
    public int size() {
        return this.getIngredientList().size();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

