/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerUtils {
    private PlayerUtils() {
    }

    public static <T extends EntityPlayer> T getPlayerFromName(String name) {
        List players = null;
        players = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? Minecraft.func_71410_x().field_71441_e.field_73010_i : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        if (players != null) {
            for (EntityPlayer player : players) {
                if (!player.func_70005_c_().equals(name)) continue;
                return (T)player;
            }
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i);
                if (player == null || !player.func_70005_c_().equals(name)) continue;
                return true;
            }
            return false;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name) != null;
    }

    public static void sendMessageToPlayer(EntityPlayer player, ITextComponent prefix, ITextComponent text, TextFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(EntityPlayer player, ITextComponent prefix, ITextComponent text, TextFormatting color, boolean shouldSendFromClient) {
        if (player.field_70170_p.field_72995_K == shouldSendFromClient) {
            player.func_145747_a(new TextComponentString("[").func_150257_a(prefix.func_150255_a(new Style().func_150238_a(color))).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "] ")).func_150257_a(text));
        }
    }

    public static ItemStack getItemStackFromAnyHand(EntityPlayer player, Item item) {
        if (player.field_71071_by.func_70448_g().func_77973_b() == item) {
            return player.field_71071_by.func_70448_g();
        }
        if (((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b() == item) {
            return (ItemStack)player.field_71071_by.field_184439_c.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPlayerMountedOnCamera(EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_70170_p.field_72995_K) {
            return ClientProxy.isPlayerMountedOnCamera();
        }
        return ((EntityPlayerMP)player).func_175398_C() instanceof SecurityCamera;
    }

    public static ITextComponent getOwnerComponent(Owner owner) {
        TeamUtils.TeamRepresentation teamRepresentation;
        if (ConfigHandler.enableTeamOwnership && (teamRepresentation = TeamUtils.getTeamRepresentation(owner)) != null) {
            return Utils.localize("messages.securitycraft:teamOwner", new TextComponentString(teamRepresentation.name()).func_150255_a(new Style().func_150238_a(teamRepresentation.color()))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }
        return new TextComponentString(owner.getName());
    }

    public static Owner getSkullOwner(EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (stack.func_77973_b() == Items.field_151144_bL && stack.func_77942_o()) {
            NBTTagCompound stackTag = stack.func_77978_p();
            if (stackTag.func_150297_b("SkullOwner", 8)) {
                return new Owner(stackTag.func_74779_i("SkullOwner"), "ownerUUID");
            }
            if (stackTag.func_150297_b("SkullOwner", 10)) {
                GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)stackTag.func_74775_l("SkullOwner"));
                String name = "ownerName";
                String uuid = "ownerUUID";
                if (profile.getName() != null) {
                    name = profile.getName();
                }
                if (profile.getId() != null) {
                    uuid = profile.getId().toString();
                }
                return new Owner(name, uuid);
            }
        }
        return null;
    }
}

