/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiUtils {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation POTION_ICONS = new ResourceLocation("minecraft:textures/gui/container/inventory.png");
    public static final ItemStack REDSTONE = new ItemStack(Items.field_151137_ax);
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/items/module_background.png"), new ResourceLocation("securitycraft", "textures/items/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/items/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/items/harming_module.png"), new ResourceLocation("securitycraft", "textures/items/smart_module.png"), new ResourceLocation("securitycraft", "textures/items/storage_module.png"), new ResourceLocation("securitycraft", "textures/items/disguise_module.png"), new ResourceLocation("securitycraft", "textures/items/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/items/redstone_dust.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/items/sugar.png");
    private static final TextComponentTranslation REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
    private static final TextComponentTranslation SMART_MODULE_NOTE = Utils.localize("gui.securitycraft:camera.smartModuleNote", new Object[0]);
    private static final CameraKeyInfoEntry[] CAMERA_KEY_INFO_LIST = new CameraKeyInfoEntry[]{new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.lookAround", options.field_74351_w.getDisplayName(), options.field_74370_x.getDisplayName(), options.field_74368_y.getDisplayName(), options.field_74366_z.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.exit", options.field_74311_E.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.getDisplayName(), KeyBindings.cameraZoomOut.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> ConfigHandler.allowCameraNightVision, $ -> Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.getDisplayName()), $ -> true), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.getDisplayName()), be -> be.isModuleEnabled(ModuleType.REDSTONE)), new CameraKeyInfoEntry(() -> true, $ -> REDSTONE_NOTE, be -> be.isModuleEnabled(ModuleType.REDSTONE)), new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.setDefaultViewingDirection", KeyBindings.setDefaultViewingDirection.getDisplayName()), be -> be.isModuleEnabled(ModuleType.SMART)), new CameraKeyInfoEntry(() -> true, $ -> SMART_MODULE_NOTE, be -> be.isModuleEnabled(ModuleType.SMART))};

    private GuiUtils() {
    }

    public static void drawCameraOverlay(Minecraft mc, Gui gui, ScaledResolution resolution, EntityPlayer player, World world, BlockPos pos) {
        if (mc.field_71474_y.field_74330_P) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof SecurityCameraBlockEntity)) {
            return;
        }
        int scaledWidth = resolution.func_78326_a();
        int scaledHeight = resolution.func_78328_b();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        SecurityCameraBlockEntity te = (SecurityCameraBlockEntity)tile;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        IBlockState state = world.func_180495_p(pos);
        long worldTime = Minecraft.func_71410_x().field_71441_e.field_73011_w.getWorldTime();
        int hours24 = (int)((float)worldTime / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)worldTime / 16.666666f % 60.0f);
        String time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        int timeY = 25;
        if (te.func_145818_k_()) {
            String cameraName = te.func_70005_c_();
            font.func_175063_a(cameraName, (float)(scaledWidth - font.func_78256_a(cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.func_175063_a(time, (float)(scaledWidth - font.func_78256_a(time) - 4), (float)timeY, 0xFFFFFF);
        int heightOffset = 10;
        for (int i = CAMERA_KEY_INFO_LIST.length - 1; i >= 0; --i) {
            CameraKeyInfoEntry entry = CAMERA_KEY_INFO_LIST[i];
            if (!entry.enabled().get().booleanValue()) continue;
            entry.drawString(settings, font, scaledWidth, scaledHeight, heightOffset, te);
            heightOffset += 10;
        }
        mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(5, 0, 0, 0, 90, 20);
        gui.func_73729_b(scaledWidth - 70, 5, 190, 0, 65, 30);
        if (player.func_70660_b(Potion.func_180142_b((String)"night_vision")) == null) {
            gui.func_73729_b(28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(POTION_ICONS);
            gui.func_73729_b(25, 2, 70, 218, 19, 16);
        }
        if (state.func_185911_a((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) == 0) {
            if (!te.isModuleEnabled(ModuleType.REDSTONE)) {
                CameraRedstoneModuleState.NOT_INSTALLED.render(gui, 12, 2);
            } else {
                CameraRedstoneModuleState.DEACTIVATED.render(gui, 12, 2);
            }
        } else {
            CameraRedstoneModuleState.ACTIVATED.render(gui, 12, 2);
        }
    }

    public static void drawItemStackToGui(ItemStack stack, int x, int y, boolean fixLighting) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem renderItem = mc.func_175599_af();
        if (fixLighting) {
            GlStateManager.func_179145_e();
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        renderItem.func_180450_b(stack, x, y);
        renderItem.func_175030_a(mc.field_71466_p, stack, x, y);
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
    }

    public static void renderModuleInfo(ModuleType module, String moduleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(MODULE_TEXTURES[module.ordinal()]);
        GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            mc.func_110434_K().func_110577_a(REDSTONE_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            mc.func_110434_K().func_110577_a(SUGAR_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        if (moduleTooltip != null && !moduleTooltip.isEmpty() && mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(Arrays.asList(moduleTooltip), (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)mc.field_71466_p);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
    }

    private static void drawTexture(Tessellator tess, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleBottom, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleBottom, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleTop, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleTop, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tess.func_78381_a();
    }

    public static final class CameraKeyInfoEntry {
        private final Supplier<Boolean> enabled;
        private final Function<GameSettings, TextComponentTranslation> text;
        private final Predicate<SecurityCameraBlockEntity> whiteText;

        public CameraKeyInfoEntry(Supplier<Boolean> enabled, Function<GameSettings, TextComponentTranslation> text, Predicate<SecurityCameraBlockEntity> whiteText) {
            this.enabled = enabled;
            this.text = text;
            this.whiteText = whiteText;
        }

        public void drawString(GameSettings options, FontRenderer font, int scaledWidth, int scaledHeight, int heightOffset, SecurityCameraBlockEntity be) {
            String formattedText = this.text().apply(options).func_150254_d();
            boolean shouldTextBeWhite = this.whiteText().test(be);
            font.func_175063_a(formattedText, (float)(scaledWidth - font.func_78256_a(formattedText) - 8), (float)(scaledHeight - heightOffset), shouldTextBeWhite ? 0xFFFFFF : 0xFF3377);
        }

        public Supplier<Boolean> enabled() {
            return this.enabled;
        }

        public Function<GameSettings, TextComponentTranslation> text() {
            return this.text;
        }

        public Predicate<SecurityCameraBlockEntity> whiteText() {
            return this.whiteText;
        }
    }
}

