/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class CameraMonitorScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private InventoryPlayer playerInventory;
    private CameraMonitorItem cameraMonitor;
    private NBTTagCompound nbtTag;
    private GuiButton[] cameraButtons = new GuiButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private StringHoverChecker[] tpHoverCheckers = new StringHoverChecker[10];
    private SecurityCameraBlockEntity[] cameraTEs = new SecurityCameraBlockEntity[10];
    private String[] cameraNames = new String[10];
    private int[] cameraViewDim = new int[10];
    private CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int page = 1;

    public CameraMonitorScreen(InventoryPlayer inventory, CameraMonitorItem item, NBTTagCompound itemNBTTag) {
        super((Container)new GenericMenu(null));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(InventoryPlayer inventory, CameraMonitorItem item, NBTTagCompound itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        GuiButton prevPageButton = new GuiButton(-1, this.field_146294_l / 2 - 25, this.field_146295_m / 2 + 57, 20, 20, "<");
        GuiButton nextPageButton = new GuiButton(0, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 57, 20, 20, ">");
        List<Pair<CameraView, String>> views = CameraMonitorItem.getCameraPositions(this.nbtTag);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.field_146292_n.add(prevPageButton);
        this.field_146292_n.add(nextPageButton);
        for (i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.field_147003_i + 18 + i % 5 * 30;
            int y = this.field_147009_r + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            Pair<CameraView, String> pair = views.get(camID - 1);
            CameraView view = (CameraView)pair.getLeft();
            GuiButton cameraButton = new GuiButton(buttonId, x, y, 20, 20, "#" + camID);
            GuiButton unbindButton = new GuiButton(buttonId + 10, x + 19, aboveCameraButton, 8, 8, "x");
            this.cameraButtons[i] = cameraButton;
            this.field_146292_n.add(cameraButton);
            this.field_146292_n.add(unbindButton);
            if (view != null) {
                TileEntity te;
                BlockPos pos = view.getPos();
                if (view.getDimension() != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
                    this.cameraViewDim[i] = view.getDimension();
                }
                this.cameraTEs[i] = (te = world.func_175625_s(pos)) instanceof SecurityCameraBlockEntity ? (SecurityCameraBlockEntity)te : null;
                this.cameraNames[i] = (String)pair.getRight();
                this.hoverCheckers[i] = new HoverChecker(cameraButton);
                if (this.cameraNames[i] == null && this.cameraTEs[i] != null && this.cameraTEs[i].func_145818_k_()) {
                    this.cameraNames[i] = this.cameraTEs[i].func_70005_c_();
                }
                if (this.cameraTEs[i] != null) {
                    IBlockState state = world.func_180495_p(pos);
                    if (this.cameraTEs[i].isDisabled() || this.cameraTEs[i].isShutDown()) {
                        cameraButton.field_146124_l = false;
                    }
                    this.redstoneModuleStates[i] = state.func_185911_a((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) == 0 ? (!this.cameraTEs[i].isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (!player.func_184812_l_()) continue;
                GuiButton tpButton = this.func_189646_b((GuiButton)new ClickButton(buttonId + 20, x, aboveCameraButton, 8, 8, "", b -> {
                    if (player.field_71093_bK == view.getDimension()) {
                        player.func_71165_d(String.format("/tp @p %s %s %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    } else {
                        player.func_71165_d(String.format("/forge setdim @p %s %s %s %s", view.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    }
                    this.field_146297_k.func_147108_a(null);
                }));
                this.tpHoverCheckers[i] = new StringHoverChecker(tpButton, Utils.localize("securitycraft.teleport", new Object[0]).func_150254_d());
                continue;
            }
            cameraButton.field_146124_l = false;
            unbindButton.field_146124_l = false;
            this.cameraTEs[i] = null;
        }
        if (this.page == 1) {
            prevPageButton.field_146124_l = false;
        }
        if (this.page == 3 || CameraMonitorItem.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            nextPageButton.field_146124_l = false;
        }
        for (i = CameraMonitorItem.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].field_146124_l = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (this.cameraTEs[i] != null && (this.cameraTEs[i].isDisabled() || this.cameraTEs[i].isShutDown())) {
                this.func_146279_a(Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]).func_150254_d(), mouseX, mouseY);
                continue;
            }
            if (this.cameraNames[i] == null) continue;
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(Utils.localize("gui.securitycraft:monitor.cameraName", new Object[0]).func_150254_d().replace("#", this.cameraNames[i]), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
        for (i = 0; i < this.tpHoverCheckers.length; ++i) {
            if (this.tpHoverCheckers[i] == null || !this.tpHoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            this.func_146279_a(this.tpHoverCheckers[i].getName(), mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -1) {
            this.field_146297_k.func_147108_a((GuiScreen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1));
        } else if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1));
        } else if (button.field_146127_k < 11) {
            SecurityCameraBlockEntity be;
            int camID = button.field_146127_k + (this.page - 1) * 10;
            BlockPos cameraPos = ((CameraView)CameraMonitorItem.getCameraPositions(this.nbtTag).get(camID - 1).getLeft()).getPos();
            TileEntity te = this.field_146297_k.field_71441_e.func_175625_s(cameraPos);
            if (te instanceof SecurityCameraBlockEntity && ((SecurityCameraBlockEntity)te).isDisabled() && ((be = (SecurityCameraBlockEntity)te).isDisabled() || be.isShutDown())) {
                button.field_146124_l = false;
                return;
            }
            SecurityCraft.network.sendToServer((IMessage)new MountCamera(cameraPos));
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        } else if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        } else {
            int camID = button.field_146127_k - 10 + (this.page - 1) * 10;
            int i = (camID - 1) % 10;
            SecurityCraft.network.sendToServer((IMessage)new RemoveCameraTag(camID));
            this.nbtTag.func_82580_o(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, (CameraView)CameraMonitorItem.getCameraPositions(this.nbtTag).get(camID - 1).getLeft()));
            button.field_146124_l = false;
            this.cameraButtons[i].field_146124_l = false;
            this.redstoneModuleStates[i] = null;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]).func_150254_d(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]).func_150254_d()) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < 10; ++i) {
            GuiButton button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render((Gui)this, button.field_146128_h + 4, button.field_146129_i + 25);
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

