/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ToggleModule
implements IMessage {
    private BlockPos pos;
    private ModuleType moduleType;

    public ToggleModule() {
    }

    public ToggleModule(BlockPos pos, ModuleType moduleType) {
        this.pos = pos;
        this.moduleType = moduleType;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.moduleType.ordinal(), (int)5);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.moduleType = ModuleType.values()[ByteBufUtils.readVarInt((ByteBuf)buf, (int)5)];
    }

    public static class Handler
    implements IMessageHandler<ToggleModule, IMessage> {
        public IMessage onMessage(ToggleModule message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntity be = player.field_70170_p.func_175625_s(message.pos);
                if (be instanceof IModuleInventory && (!(be instanceof IOwnable) || ((IOwnable)be).isOwnedBy((Entity)player))) {
                    IModuleInventory moduleInv = (IModuleInventory)be;
                    if (moduleInv.isModuleEnabled(message.moduleType)) {
                        moduleInv.removeModule(message.moduleType, true);
                        if (be instanceof LinkableBlockEntity) {
                            LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                            linkable.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(message.moduleType, true), linkable);
                        }
                    } else {
                        moduleInv.insertModule(moduleInv.getModule(message.moduleType), true);
                        if (be instanceof LinkableBlockEntity) {
                            LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                            ItemStack stack = moduleInv.getModule(message.moduleType);
                            linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.func_77973_b(), true), linkable);
                        }
                    }
                    if (be instanceof CustomizableBlockEntity) {
                        ((CustomizableBlockEntity)be).sync();
                    }
                }
            });
            return null;
        }
    }
}

