/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SyncTrophySystem
implements IMessage {
    private BlockPos pos;
    private String projectileTypeLocation;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityEntry projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileTypeLocation = projectileType.getRegistryName().toString();
        this.allowed = allowed;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.projectileTypeLocation);
        buf.writeBoolean(this.allowed);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.projectileTypeLocation = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.allowed = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<SyncTrophySystem, IMessage> {
        public IMessage onMessage(SyncTrophySystem message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityEntry projectileType = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(message.projectileTypeLocation));
                if (projectileType != null) {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    World world = player.field_70170_p;
                    TileEntity te = world.func_175625_s(message.pos);
                    if (te instanceof TrophySystemBlockEntity && ((TrophySystemBlockEntity)te).isOwnedBy((Entity)player)) {
                        IBlockState state = world.func_180495_p(message.pos);
                        ((TrophySystemBlockEntity)te).setFilter(projectileType, message.allowed);
                        world.func_184138_a(message.pos, state, state, 2);
                    }
                }
            });
            return null;
        }
    }
}

