/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadDoorBlockEntity;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetPasscode
implements IMessage {
    private String passcode;
    private int x;
    private int y;
    private int z;

    public SetPasscode() {
    }

    public SetPasscode(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.passcode);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.passcode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<SetPasscode, IMessage> {
        public IMessage onMessage(SetPasscode message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof IPasscodeProtected && (!(tile instanceof IOwnable) || ((IOwnable)tile).isOwnedBy((Entity)player))) {
                    IPasscodeProtected be = (IPasscodeProtected)tile;
                    be.hashAndSetPasscode(message.passcode, arg_0 -> Handler.lambda$null$0(be, (EntityPlayer)player, pos, arg_0));
                    if (be instanceof KeypadChestBlockEntity) {
                        this.checkAndUpdateAdjacentChest((KeypadChestBlockEntity)be, world, pos, message.passcode, be.getSalt());
                    } else if (be instanceof KeypadDoorBlockEntity) {
                        this.checkAndUpdateAdjacentDoor((KeypadDoorBlockEntity)be, world, message.passcode, be.getSalt());
                    }
                }
            });
            return null;
        }

        private void checkAndUpdateAdjacentChest(KeypadChestBlockEntity te, World world, BlockPos pos, String codeToSet, byte[] salt) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos offsetPos = pos.func_177972_a(facing);
                TileEntity otherTe = world.func_175625_s(offsetPos);
                if (!(otherTe instanceof KeypadChestBlockEntity) || !te.getOwner().owns((KeypadChestBlockEntity)otherTe)) continue;
                IBlockState state = world.func_180495_p(offsetPos);
                te.hashAndSetPasscode(codeToSet, salt);
                world.func_184138_a(offsetPos, state, state, 2);
                break;
            }
        }

        private void checkAndUpdateAdjacentDoor(KeypadDoorBlockEntity be, World level, String codeToSet, byte[] salt) {
            be.runForOtherHalf(otherBe -> {
                BlockPos otherPos = otherBe.func_174877_v();
                IBlockState state = level.func_180495_p(otherPos);
                if (be.getOwner().owns((IOwnable)otherBe)) {
                    otherBe.hashAndSetPasscode(codeToSet, salt);
                    level.func_184138_a(otherPos, state, state, 2);
                }
            });
        }

        private static /* synthetic */ void lambda$null$0(IPasscodeProtected be, EntityPlayer player, BlockPos pos, byte[] b) {
            be.openPasscodeGUI(player.field_70170_p, pos, player);
        }
    }
}

