/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MountCamera
implements IMessage {
    private BlockPos pos;

    public MountCamera() {
    }

    public MountCamera(BlockPos pos) {
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public static class Handler
    implements IMessageHandler<MountCamera, IMessage> {
        public IMessage onMessage(MountCamera message, MessageContext context) {
            Utils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                IBlockState state = world.func_180495_p(message.pos);
                if (world.func_175667_e(message.pos) && state.func_177230_c() == SCContent.securityCamera) {
                    SecurityCameraBlockEntity cam;
                    TileEntity te = world.func_175625_s(message.pos);
                    if (te instanceof SecurityCameraBlockEntity && !(cam = (SecurityCameraBlockEntity)te).isDisabled() && !cam.isShutDown()) {
                        if (cam.isOwnedBy((Entity)player) || cam.isAllowed((Entity)player)) {
                            ((SecurityCameraBlock)state.func_177230_c()).mountCamera(world, message.pos.func_177958_n(), message.pos.func_177956_o(), message.pos.func_177952_p(), (EntityPlayer)player);
                        } else {
                            PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)Utils.localize(SCContent.cameraMonitor.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", cam.getOwner().getName()), TextFormatting.RED);
                        }
                    }
                    return;
                }
                PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)Utils.localize(SCContent.cameraMonitor.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", message.pos), TextFormatting.RED);
            });
            return null;
        }
    }
}

