/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.ProtectoBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonBlockEntity;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedGrassBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedWallBlock;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.ColorableItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.renderers.BlockEntityItemRenderer;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.ClaymoreRenderer;
import net.geforcemods.securitycraft.renderers.DisguisableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignRenderer;
import net.geforcemods.securitycraft.renderers.SecureRedstoneInterfaceRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemRenderer;
import net.geforcemods.securitycraft.util.Tinted;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    private static Map<Block, Pair<IBlockColor, IItemColor>> toTint = new HashMap<Block, Pair<IBlockColor, IItemColor>>();

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] mines;
        for (String mine : mines = new String[]{"coal_ore", "cobblestone", "dirt", "emerald_ore", "gravel", "gold_ore", "furnace", "iron_ore", "lapis_ore", "redstone_ore", "sand", "stone", "end_stone", "netherrack"}) {
            ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", mine + "_mine"), new ResourceLocation(mine));
        }
        ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", "diamond_mine"), new ResourceLocation("diamond_ore"));
        ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerBlockMineModel(ModelBakeEvent event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModelRegistry().func_82595_a((Object)mineMrl, (Object)new BlockMineModel((IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation(realBlockRl, "inventory")), (IBakedModel)event.getModelRegistry().func_82594_a((Object)mineMrl)));
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("securitycraft", "particle/floor_trap_cloud"));
    }

    @Override
    public void registerVariants() {
        Item fakeWater = this.findItem("securitycraft", "bogus_water");
        ModelBakery.registerItemVariants((Item)fakeWater, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeWater, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "water"));
        ModelLoader.setCustomStateMapper((Block)SCContent.fakeWater, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "water");
            }
        });
        Item fakeWaterFlowing = this.findItem("securitycraft", "bogus_water_flowing");
        ModelBakery.registerItemVariants((Item)fakeWaterFlowing, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeWaterFlowing, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "water_flowing"));
        ModelLoader.setCustomStateMapper((Block)SCContent.bogusWaterFlowing, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "water_flowing");
            }
        });
        Item fakeLava = this.findItem("securitycraft", "bogus_Lava");
        ModelBakery.registerItemVariants((Item)fakeLava, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeLava, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "lava"));
        ModelLoader.setCustomStateMapper((Block)SCContent.fakeLava, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "lava");
            }
        });
        Item fakeLavaFlowing = this.findItem("securitycraft", "bogus_lava_flowing");
        ModelBakery.registerItemVariants((Item)fakeLavaFlowing, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeLavaFlowing, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "lava_flowing"));
        ModelLoader.setCustomStateMapper((Block)SCContent.bogusLavaFlowing, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "lava_flowing");
            }
        });
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedStainedGlassPanes, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockColored.field_176581_a).func_178439_a("_reinforced_stained_glass_panes").func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedWalls, (IStateMapper)new StateMap.Builder().func_178440_a(ReinforcedWallBlock.VARIANT).func_178439_a("_wall").func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedHopper, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockHopper.field_176429_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedDispenser, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDispenser.field_176440_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedDropper, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDispenser.field_176440_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedOakFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedSpruceFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedBirchFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedJungleFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedDarkOakFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedAcaciaFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
    }

    private Item findItem(String modid, String resourceName) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, resourceName));
    }

    @Override
    public void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(BouncingBetty.class, BouncingBettyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(IMSBomb.class, IMSBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(Sentry.class, SentryRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(Bullet.class, BulletRenderer::new);
    }

    @Override
    public void registerRenderThings() {
        KeyBindings.init();
        ClientRegistry.bindTileEntitySpecialRenderer(KeypadChestBlockEntity.class, (TileEntitySpecialRenderer)new KeypadChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SecurityCameraBlockEntity.class, (TileEntitySpecialRenderer)new SecurityCameraRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(RetinalScannerBlockEntity.class, (TileEntitySpecialRenderer)new RetinalScannerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SecretSignBlockEntity.class, (TileEntitySpecialRenderer)new SecretSignRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TrophySystemBlockEntity.class, (TileEntitySpecialRenderer)new TrophySystemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(BlockPocketManagerBlockEntity.class, (TileEntitySpecialRenderer)new BlockPocketManagerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ProjectorBlockEntity.class, (TileEntitySpecialRenderer)new ProjectorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ReinforcedPistonBlockEntity.class, (TileEntitySpecialRenderer)new ReinforcedPistonRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SonicSecuritySystemBlockEntity.class, (TileEntitySpecialRenderer)new SonicSecuritySystemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DisplayCaseBlockEntity.class, (TileEntitySpecialRenderer)new DisplayCaseRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ClaymoreBlockEntity.class, (TileEntitySpecialRenderer)new ClaymoreRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SecureRedstoneInterfaceBlockEntity.class, (TileEntitySpecialRenderer)new SecureRedstoneInterfaceRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(BlockChangeDetectorBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DisguisableBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CageTrapBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(InventoryScannerBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(KeycardReaderBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(KeypadBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(KeypadFurnaceBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(KeypadTrapdoorBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(LaserBlockBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ProtectoBlockEntity.class, new DisguisableBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(UsernameLoggerBlockEntity.class, new DisguisableBlockEntityRenderer());
        Item.func_150898_a((Block)SCContent.keypadChest).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new BlockEntityItemRenderer((TileEntity)new KeypadChestBlockEntity()));
        Item.func_150898_a((Block)SCContent.displayCase).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new BlockEntityItemRenderer(new DisplayCaseBlockEntity()));
    }

    private static void initTint() {
        if (toTint != null) {
            for (Field field : SCContent.class.getFields()) {
                if (!field.isAnnotationPresent(Tinted.class)) continue;
                int tint = field.getAnnotation(Tinted.class).customTint();
                boolean hasReinforcedTint = field.getAnnotation(Tinted.class).hasReinforcedTint();
                try {
                    Block block = (Block)field.get(null);
                    toTint.put(block, (Pair<IBlockColor, IItemColor>)Pair.of((state, world, pos, tintIndex) -> {
                        if (tintIndex == 0) {
                            return hasReinforcedTint ? ClientProxy.mixWithReinforcedTintIfEnabled(tint) : tint;
                        }
                        return 0xFFFFFF;
                    }, (stack, tintIndex) -> {
                        if (tintIndex == 0) {
                            return hasReinforcedTint ? ClientProxy.mixWithReinforcedTintIfEnabled(tint) : tint;
                        }
                        return 0xFFFFFF;
                    }));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onColorHandlerBlock(ColorHandlerEvent.Block event) {
        ClientProxy.initTint();
        if (toTint != null) {
            toTint.forEach((block, pair) -> event.getBlockColors().func_186722_a((IBlockColor)pair.getLeft(), new Block[]{block}));
            event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
                if (tintIndex == 1 && !((Boolean)state.func_177229_b((IProperty)ReinforcedGrassBlock.SNOWY)).booleanValue()) {
                    int grassTint = world != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                    return ClientProxy.mixWithReinforcedTintIfEnabled(grassTint);
                }
                return ConfigHandler.reinforcedBlockTintColor;
            }, new Block[]{SCContent.reinforcedGrass});
            event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos) : -1, new Block[]{SCContent.fakeWater, SCContent.bogusWaterFlowing});
            event.getBlockColors().func_186722_a((state, level, pos, tintIndex) -> {
                EnumFacing direction = LaserFieldBlock.getFieldDirection(state);
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (int i = 0; i < ConfigHandler.laserBlockRange; ++i) {
                    try {
                        TileEntity te;
                        if (level.func_180495_p((BlockPos)mutablePos).func_177230_c() == SCContent.laserBlock && (te = level.func_175625_s((BlockPos)mutablePos)) instanceof LaserBlockBlockEntity) {
                            ItemStack stack = ((LaserBlockBlockEntity)te).getLensContainer().func_70301_a(direction.func_176734_d().ordinal());
                            if (!(stack.func_77973_b() instanceof ColorableItem)) break;
                            return ((ColorableItem)stack.func_77973_b()).getColor(stack);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    mutablePos.func_189536_c(direction);
                }
                return -1;
            }, new Block[]{SCContent.laserField});
            event.getBlockColors().func_186722_a((state, level, pos, tintIndex) -> {
                EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)InventoryScannerFieldBlock.FACING);
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (int i = 0; i < ConfigHandler.inventoryScannerRange; ++i) {
                    TileEntity te;
                    if (level.func_180495_p((BlockPos)mutablePos).func_177230_c() == SCContent.inventoryScanner && (te = level.func_175625_s((BlockPos)mutablePos)) instanceof InventoryScannerBlockEntity) {
                        ItemStack stack = ((InventoryScannerBlockEntity)te).getLensContainer().func_70301_a(0);
                        if (!(stack.func_77973_b() instanceof ColorableItem)) break;
                        return ((ColorableItem)stack.func_77973_b()).getColor(stack);
                    }
                    mutablePos.func_189536_c(direction);
                }
                return -1;
            }, new Block[]{SCContent.inventoryScannerField});
        }
    }

    @SubscribeEvent
    public static void onColorHandlerItem(ColorHandlerEvent.Item event) {
        if (toTint != null) {
            toTint.forEach((block, pair) -> event.getItemColors().func_186731_a((IItemColor)pair.getRight(), new Block[]{block}));
            event.getItemColors().func_186731_a((stack, tintIndex) -> {
                if (tintIndex == 1) {
                    int grassTint = ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                    return ClientProxy.mixWithReinforcedTintIfEnabled(grassTint);
                }
                return ConfigHandler.reinforcedBlockTintColor;
            }, new Block[]{SCContent.reinforcedGrass});
            event.getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 0 ? ((ColorableItem)stack.func_77973_b()).getColor(stack) : -1, new Item[]{SCContent.briefcase, SCContent.lens});
            toTint = null;
        }
    }

    private static int mixWithReinforcedTintIfEnabled(int tint1) {
        return ConfigHandler.reinforcedBlockTint ? ClientProxy.mixTints(tint1, ConfigHandler.reinforcedBlockTintColor) : tint1;
    }

    private static int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    @Override
    public void addEffect(IParticleFactory factory, World level, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        WorldClient world = mc.field_71441_e;
        if (entity != null && mc.field_71452_i != null) {
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (particleSetting == 1 && world.field_73012_v.nextInt(3) == 0) {
                particleSetting = 2;
            }
            if (particleSetting > 1) {
                return;
            }
            double xDistance = entity.field_70165_t - x;
            double yDistance = entity.field_70163_u - y;
            double zDistance = entity.field_70161_v - z;
            if (xDistance * xDistance + yDistance * yDistance + zDistance * zDistance <= 1024.0) {
                mc.field_71452_i.func_78873_a(factory.func_178902_a(0, (World)world, x, y, z, 0.0, 0.0, 0.0, new int[]{0}));
            }
        }
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientLevel() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void updateBlockColorAroundPosition(BlockPos pos) {
        Minecraft.func_71410_x().field_71438_f.func_184376_a((World)Minecraft.func_71410_x().field_71441_e, pos, null, null, 0);
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.func_71410_x().func_175606_aa() instanceof SecurityCamera;
    }
}

