/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;

public class SaltData
extends WorldSavedData {
    private static final Object DUMMY = new Object();
    private static SaltData instance;
    private final Map<UUID, byte[]> saltMap = new ConcurrentHashMap<UUID, byte[]>();
    private final Map<UUID, Object> saltKeysInUse = new ConcurrentHashMap<UUID, Object>();

    public SaltData(String name) {
        super(name);
    }

    public static void refreshLevel(WorldServer level) {
        WorldSavedData data = level.func_72943_a(SaltData.class, "securitycraft-salts");
        if (data == null) {
            data = new SaltData("securitycraft-salts");
            level.func_72823_a("securitycraft-salts", data);
        }
        if (data instanceof SaltData) {
            instance = (SaltData)data;
        }
    }

    public static void invalidate() {
        instance = null;
    }

    public static boolean containsKey(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltMap.containsKey(saltKey);
    }

    public static void setKeyInUse(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltKeysInUse.put(saltKey, DUMMY);
        }
    }

    public static boolean isKeyInUse(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltKeysInUse.containsKey(saltKey);
    }

    public static byte[] getSalt(UUID saltKey) {
        if (saltKey == null) {
            return null;
        }
        byte[] salt = SaltData.instance.saltMap.get(saltKey);
        return salt == null || salt.length == 0 ? null : salt;
    }

    public static UUID putSalt(byte[] salt) {
        UUID saltKey = UUID.randomUUID();
        SaltData.instance.saltMap.put(saltKey, salt);
        SaltData.setKeyInUse(saltKey);
        instance.func_76185_a();
        return saltKey;
    }

    public static void removeSalt(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltMap.remove(saltKey);
            SaltData.instance.saltKeysInUse.remove(saltKey);
            instance.func_76185_a();
        }
    }

    public static UUID copySaltToNewKey(UUID oldKey) {
        if (oldKey != null) {
            return SaltData.putSalt(SaltData.getSalt(oldKey));
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList listtag = tag.func_150295_c("Salts", 10);
        for (int i = 0; i < listtag.func_74745_c(); ++i) {
            NBTTagCompound saltTag = listtag.func_150305_b(i);
            this.saltMap.put(UUID.fromString(saltTag.func_74779_i("key")), saltTag.func_74770_j("salt"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList saltTable = new NBTTagList();
        for (Map.Entry<UUID, byte[]> saltMapping : this.saltMap.entrySet()) {
            NBTTagCompound saltTag = new NBTTagCompound();
            saltTag.func_74778_a("key", saltMapping.getKey().toString());
            saltTag.func_74773_a("salt", saltMapping.getValue());
            saltTable.func_74742_a((NBTBase)saltTag);
        }
        tag.func_74782_a("Salts", (NBTBase)saltTable);
        return tag;
    }
}

