/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.items.ColorableItem;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DyeItemRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ItemStack colorableItem = ItemStack.field_190927_a;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() instanceof ColorableItem) {
                if (!colorableItem.func_190926_b()) {
                    return false;
                }
                colorableItem = slotStack;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)slotStack)) {
                return false;
            }
            dyes.add(slotStack);
        }
        return !colorableItem.func_190926_b() && !dyes.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack colorableItem = ItemStack.field_190927_a;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() instanceof ColorableItem) {
                colorableItem = slotStack.func_77946_l();
                continue;
            }
            if (DyeUtils.isDye((ItemStack)slotStack)) {
                dyes.add(slotStack);
                continue;
            }
            return ItemStack.field_190927_a;
        }
        return !colorableItem.func_190926_b() ? DyeItemRecipe.dyeItem(colorableItem, dyes) : colorableItem;
    }

    public static ItemStack dyeItem(ItemStack stack, List<ItemStack> dyes) {
        ColorableItem colorableItem = (ColorableItem)stack.func_77973_b();
        ItemStack resultStack = stack.func_77946_l();
        int[] resultRgb = new int[3];
        int i = 0;
        int j = 0;
        resultStack.func_190920_e(1);
        if (colorableItem.hasColor(stack)) {
            int rgb = colorableItem.getColor(resultStack);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            i = (int)((float)i + Math.max(r, Math.max(g, b)) * 255.0f);
            resultRgb[0] = (int)((float)resultRgb[0] + r * 255.0f);
            resultRgb[1] = (int)((float)resultRgb[1] + g * 255.0f);
            resultRgb[2] = (int)((float)resultRgb[2] + b * 255.0f);
            ++j;
        }
        for (ItemStack dye : dyes) {
            float[] dyeColor = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)dye).get()).func_193349_f();
            int dyeR = (int)(dyeColor[0] * 255.0f);
            int dyeG = (int)(dyeColor[1] * 255.0f);
            int dyeB = (int)(dyeColor[2] * 255.0f);
            i += Math.max(dyeR, Math.max(dyeG, dyeB));
            resultRgb[0] = resultRgb[0] + dyeR;
            resultRgb[1] = resultRgb[1] + dyeG;
            resultRgb[2] = resultRgb[2] + dyeB;
            ++j;
        }
        int r = resultRgb[0] / j;
        int g = resultRgb[1] / j;
        int b = resultRgb[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(r, Math.max(g, b));
        r = (int)((float)r * f3 / f4);
        g = (int)((float)g * f3 / f4);
        b = (int)((float)b * f3 / f4);
        int resultColor = (r << 8) + g;
        resultColor = (resultColor << 8) + b;
        colorableItem.setColor(resultStack, resultColor);
        return resultStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)inv.func_70301_a(i)));
        }
        return remainingItems;
    }

    public boolean func_192399_d() {
        return true;
    }
}

