/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.LinkingStateItemPropertyHandler;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CodebreakerItem
extends Item {
    public static final ResourceLocation STATE_PROPERTY = new ResourceLocation("securitycraft", "codebreaker_state");
    public static final String WORKING = "working";
    public static final String LAST_USED_TIME = "last_used_time";
    public static final String WAS_SUCCESSFUL = "was_successful";

    public CodebreakerItem() {
        this.field_77777_bU = 1;
        this.func_77656_e(4);
        this.func_185043_a(STATE_PROPERTY, (stack, world, entity) -> {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = stack.func_77978_p();
            boolean isPlayer = entity instanceof EntityPlayer;
            if (!(isPlayer && ((EntityPlayer)entity).func_184812_l_() || !CodebreakerItem.wasRecentlyUsed(stack))) {
                return tag.func_74767_n(WAS_SUCCESSFUL) ? 0.75f : 0.5f;
            }
            if (!isPlayer) {
                return 0.0f;
            }
            float state = LinkingStateItemPropertyHandler.getLinkingState(world, (EntityPlayer)entity, stack, (_level, pos) -> _level.func_175625_s(pos) instanceof ICodebreakable, 0, null, false, (_tag, pos) -> true);
            if (state == 0.75f || state == 0.5f) {
                return 0.25f;
            }
            return 0.0f;
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack briefcase;
        ItemStack codebreaker = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && (briefcase = player.func_184592_cb()).func_77973_b() == SCContent.briefcase) {
            if (BriefcaseItem.isOwnedBy(briefcase, player) && !player.func_184812_l_()) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), TextFormatting.RED);
            } else {
                double chance = ConfigHandler.codebreakerChance;
                if (chance < 0.0) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.briefcase, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
                } else {
                    codebreaker.func_77972_a(1, (EntityLivingBase)player);
                    if (!world.field_72995_K) {
                        if (!codebreaker.func_77942_o()) {
                            codebreaker.func_77982_d(new NBTTagCompound());
                        }
                        if (!player.func_184812_l_() && CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)codebreaker);
                        }
                        boolean isSuccessful = player.func_184812_l_() || SecurityCraft.RANDOM.nextDouble() < chance;
                        NBTTagCompound tag = codebreaker.func_77978_p();
                        tag.func_74772_a(LAST_USED_TIME, System.currentTimeMillis());
                        tag.func_74757_a(WAS_SUCCESSFUL, isSuccessful);
                        if (isSuccessful) {
                            player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.BRIEFCASE_INVENTORY.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        } else {
                            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                        }
                    }
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)codebreaker);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)codebreaker);
    }

    public static boolean wasRecentlyUsed(ItemStack stack) {
        long lastUsedTime = stack.func_77978_p().func_74763_f(LAST_USED_TIME);
        return lastUsedTime != 0L && System.currentTimeMillis() - lastUsedTime < 3000L;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

