/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecurityCamera
extends Entity
implements IEMPAffected {
    public static final DataParameter<Float> ZOOM_AMOUNT = EntityDataManager.func_187226_a(SecurityCamera.class, (DataSerializer)DataSerializers.field_187193_c);
    protected boolean zooming = false;
    private ForgeChunkManager.Ticket chunkTicket;
    private SecurityCameraBlockEntity be;

    public SecurityCamera(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_98038_p = true;
        this.field_70131_O = 1.0E-4f;
        this.field_70130_N = 1.0E-4f;
        if (!world.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public SecurityCamera(World world, double x, double y, double z) {
        this(world);
        this.field_70128_L = false;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof SecurityCameraBlockEntity)) {
            this.func_70106_y();
            return;
        }
        this.be = (SecurityCameraBlockEntity)te;
        x += 0.5;
        y += 0.5;
        z += 0.5;
        if (this.be.isDown()) {
            y += 0.25;
        }
        this.func_70107_b(x, y, z);
        this.func_70101_b(this.be.getInitialYRotation(), this.be.getInitialXRotation());
        this.setZoomAmount(this.be.getInitialZoom());
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177230_c() != SCContent.securityCamera) {
            this.func_70106_y();
        }
    }

    public float getZoomAmount() {
        return ((Float)this.field_70180_af.func_187225_a(ZOOM_AMOUNT)).floatValue();
    }

    public void setZoomAmount(float zoomAmount) {
        this.field_70180_af.func_187227_b(ZOOM_AMOUNT, (Object)Float.valueOf(zoomAmount));
    }

    public boolean isCameraDown() {
        return this.getBlockEntity() != null && !this.be.func_145837_r() && this.be.isDown();
    }

    protected void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.discardCamera();
    }

    public void stopViewing(EntityPlayerMP player) {
        if (!this.field_70170_p.field_72995_K) {
            WorldServer serverWorld = (WorldServer)this.field_70170_p;
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Chunk chunk = serverWorld.func_175726_f(pos);
            ChunkPos chunkPos = chunk.func_76632_l();
            ChunkPos playerChunkPos = new ChunkPos(player.func_180425_c());
            int viewDistance = player.field_71133_b.func_184103_al().func_72395_o();
            for (int cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (int cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    if (cx >= playerChunkPos.field_77276_a - viewDistance && cx <= playerChunkPos.field_77276_a + viewDistance && cz >= playerChunkPos.field_77275_b - viewDistance && cz <= playerChunkPos.field_77275_b + viewDistance) continue;
                    serverWorld.func_184164_w().func_187302_c(cx, cz).func_187277_b(player);
                }
            }
            serverWorld.func_184164_w().func_72683_a(player);
            player.field_175401_bS = player;
            SecurityCraft.network.sendTo((IMessage)new SetCameraView((Entity)player), player);
            for (EntityTrackerEntry entry : serverWorld.func_73039_n().field_72793_b) {
                if (entry.func_187260_b() == player) continue;
                entry.field_73134_o.remove(player);
                entry.func_73117_b(player);
            }
            this.func_70106_y();
            if (player.func_70660_b(MobEffects.field_76439_r) instanceof CameraNightVisionEffectInstance) {
                player.func_184589_d(MobEffects.field_76439_r);
            }
        }
    }

    @Deprecated
    public void discardCamera() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getBlockEntity() != null && !this.be.func_145837_r()) {
                this.be.stopViewing();
            }
            if (this.chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                this.chunkTicket = null;
            }
        }
    }

    public void setChunkTicket(ForgeChunkManager.Ticket chunkTicket) {
        this.chunkTicket = chunkTicket;
    }

    @Override
    public void shutDown() {
        this.func_184226_ay();
        this.func_70106_y();
    }

    @Override
    public boolean isShutDown() {
        return false;
    }

    @Override
    public void setShutDown(boolean shutDown) {
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ZOOM_AMOUNT, (Object)Float.valueOf(1.0f));
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74776_a("zoom_amount", this.getZoomAmount());
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(ZOOM_AMOUNT, (Object)Float.valueOf(tag.func_74760_g("zoom_amount")));
    }

    public SecurityCameraBlockEntity getBlockEntity() {
        if (this.be == null) {
            TileEntity te = this.field_70170_p.func_175625_s(this.func_180425_c().func_177977_b());
            if (te instanceof SecurityCameraBlockEntity) {
                this.be = (SecurityCameraBlockEntity)te;
            } else {
                SecurityCraft.LOGGER.warn("No security camera block entity was found at {}. Try breaking and replacing the block!", (Object)this.func_180425_c());
            }
        }
        return this.be;
    }
}

