/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="securitycraft", value={Side.CLIENT})
public class CameraController {
    public static int previousCameraType;
    private static final ViewMovementKeyHandler[] MOVE_KEY_HANDLERS;
    private static int screenshotSoundCooldown;

    private CameraController() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)renderViewEntity;
            if (event.phase == TickEvent.Phase.END) {
                for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
                    handler.tickEnd(cam);
                }
                if (KeyBindings.cameraZoomIn.func_151470_d()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.func_151470_d()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                KeyBindings.cameraEmitRedstone.tick(cam);
                KeyBindings.cameraActivateNightVision.tick(cam);
                KeyBindings.setDefaultViewingDirection.tick(cam);
                --screenshotSoundCooldown;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                double yRotChange = player.field_70177_z - player.field_175164_bL;
                double xRotChange = player.field_70125_A - player.field_175165_bM;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(player.field_70177_z, player.field_70125_A, player.field_70122_E));
                }
            }
        }
    }

    public static void handleKeybinds() {
        GameSettings options = Minecraft.func_71410_x().field_71474_y;
        for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
            handler.tickStart();
        }
        if (options.field_74311_E.func_151470_d()) {
            CameraController.dismount();
            KeyBinding.func_74510_a((int)options.field_74311_E.func_151463_i(), (boolean)false);
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player) && screenshotSoundCooldown <= 0) {
            screenshotSoundCooldown = 7;
            Minecraft.func_71410_x().field_71441_e.func_184156_a(player.func_180425_c(), SCSounds.CAMERASNAP.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    private static void dismount() {
        SecurityCraft.network.sendToServer((IMessage)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.field_70125_A - CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next > -25.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.field_70125_A + CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next < 60.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float next) {
        IBlockState state = cam.field_70170_p.func_180495_p(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v));
        if (state.func_177228_b().containsKey((Object)SecurityCameraBlock.FACING)) {
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            boolean shouldSetRotation = false;
            switch ((EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    shouldSetRotation = checkNext > 90.0f && checkNext < 270.0f;
                    break;
                }
                case SOUTH: {
                    shouldSetRotation = checkNext > 270.0f || checkNext < 90.0f;
                    break;
                }
                case EAST: {
                    shouldSetRotation = checkNext > 180.0f && checkNext < 360.0f;
                    break;
                }
                case WEST: {
                    shouldSetRotation = checkNext > 0.0f && checkNext < 180.0f;
                    break;
                }
                case DOWN: {
                    shouldSetRotation = true;
                    break;
                }
                default: {
                    shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.field_70177_z = next;
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.max(cam.getZoomAmount() - 0.1f, 0.1f));
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.min(cam.getZoomAmount() + 0.1f, 1.4f));
    }

    public static void toggleRedstone(SecurityCamera cam) {
        BlockPos pos = new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v);
        TileEntity be = cam.field_70170_p.func_175625_s(pos);
        if (be instanceof IModuleInventory && ((IModuleInventory)be).isModuleEnabled(ModuleType.REDSTONE)) {
            SecurityCraft.network.sendToServer((IMessage)new SetCameraPowered(pos, (Boolean)cam.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)SecurityCameraBlock.POWERED) == false));
        }
    }

    public static void toggleNightVision(SecurityCamera cam) {
        SecurityCraft.network.sendToServer((IMessage)new ToggleNightVision());
    }

    public static void setDefaultViewingDirection(SecurityCamera cam) {
        SecurityCraft.network.sendToServer((IMessage)new SetDefaultCameraViewingDirection(cam));
    }

    public static float getMovementSpeed(SecurityCamera cam) {
        SecurityCameraBlockEntity be = cam.getBlockEntity();
        if (be != null) {
            return (float)be.getMovementSpeed();
        }
        return 0.0f;
    }

    static {
        MOVE_KEY_HANDLERS = new ViewMovementKeyHandler[]{new ViewMovementKeyHandler(Minecraft.func_71410_x().field_71474_y.field_74351_w, CameraController::moveViewUp), new ViewMovementKeyHandler(Minecraft.func_71410_x().field_71474_y.field_74368_y, CameraController::moveViewDown), new ViewMovementKeyHandler(Minecraft.func_71410_x().field_71474_y.field_74370_x, cam -> CameraController.moveViewHorizontally(cam, cam.field_70177_z - CameraController.getMovementSpeed(cam) * cam.getZoomAmount())), new ViewMovementKeyHandler(Minecraft.func_71410_x().field_71474_y.field_74366_z, cam -> CameraController.moveViewHorizontally(cam, cam.field_70177_z + CameraController.getMovementSpeed(cam) * cam.getZoomAmount()))};
        screenshotSoundCooldown = 0;
    }

    public static class ViewMovementKeyHandler {
        private final KeyBinding key;
        private final Consumer<SecurityCamera> action;
        private boolean wasPressed;

        public ViewMovementKeyHandler(KeyBinding key, Consumer<SecurityCamera> action) {
            this.key = key;
            this.action = action;
        }

        public void tickStart() {
            this.wasPressed = this.key.func_151470_d();
            if (this.wasPressed) {
                KeyBinding.func_74510_a((int)this.key.func_151463_i(), (boolean)false);
            }
        }

        public void tickEnd(SecurityCamera cam) {
            if (this.wasPressed) {
                this.action.accept(cam);
                KeyBinding.func_74510_a((int)this.key.func_151463_i(), (boolean)true);
            }
        }
    }
}

