/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SpecialDoorBlock
extends BlockDoor
implements ITileEntityProvider,
IOverlayDisplay,
IDisguisable {
    protected SpecialDoorBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged((IBlockAccess)world, pos, fromPos);
    }

    public void onNeighborChanged(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        World world = (World)access;
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
            if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
                BlockPos blockBelow = pos.func_177977_b();
                IBlockState stateBelow = world.func_180495_p(blockBelow);
                if (stateBelow.func_177230_c() != this) {
                    world.func_175698_g(pos);
                } else if (neighborBlock != this) {
                    this.onNeighborChanged((IBlockAccess)world, blockBelow, neighbor);
                }
            } else {
                boolean drop = false;
                BlockPos blockAbove = pos.func_177984_a();
                IBlockState stateAbove = world.func_180495_p(blockAbove);
                if (stateAbove.func_177230_c() != this) {
                    world.func_175698_g(pos);
                    drop = true;
                }
                if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                    world.func_175698_g(pos);
                    drop = true;
                    if (stateAbove.func_177230_c() == this) {
                        world.func_175698_g(blockAbove);
                    }
                }
                if (drop && !world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            }
        }
    }

    public void func_180650_b(World world, BlockPos upperPos, IBlockState state, Random random) {
        IBlockState lowerState;
        BlockPos lowerPos;
        IBlockState upperState = world.func_180495_p(upperPos);
        if (!((Boolean)upperState.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
            return;
        }
        if (upperState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            lowerPos = upperPos;
            lowerState = upperState;
            upperPos = upperPos.func_177984_a();
            upperState = world.func_180495_p(upperPos);
        } else {
            lowerPos = upperPos.func_177977_b();
            lowerState = world.func_180495_p(lowerPos);
        }
        world.func_175656_a(upperPos, upperState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(lowerPos, lowerState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)));
        world.func_180498_a(null, 1011, upperPos, 0);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        if (te instanceof IPasscodeProtected) {
            SaltData.removeSalt(((IPasscodeProtected)te).getSaltKey());
        }
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.func_145842_c(id, param);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.getDoorItem();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            if (!((Boolean)state.func_177229_b((IProperty)field_176519_b)).booleanValue()) {
                actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
            }
        } else {
            SpecialDoorBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return IDisguisable.getDisguisedBlockFaceShape(world, state, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return IDisguisable.shouldDisguisedSideBeRendered(state, world, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack(this.getDoorItem());
    }

    public abstract Item getDoorItem();
}

