/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class UsernameLoggerBlockEntity
extends DisguisableBlockEntity
implements ITickable,
ILockable {
    private static final int TICKS_BETWEEN_ATTACKS = 80;
    private Option.IntOption searchRadius = new Option.IntOption(() -> ((UsernameLoggerBlockEntity)this).func_174877_v(), "searchRadius", 3, 1, 20, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Option.IntOption repeatedLogInterval = new Option.IntOption(() -> ((UsernameLoggerBlockEntity)this).func_174877_v(), "repeatedLogInterval", 1, 1, 120, 1);
    private String[] players = new String[100];
    private String[] uuids = new String[100];
    private long[] timestamps = new long[100];
    private int cooldown = 80;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDisabled()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
                long timestamp = System.currentTimeMillis();
                List nearbyPlayers = this.field_145850_b.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g((double)((Integer)this.searchRadius.get()).intValue()), e -> !e.func_175149_v() && (!this.isOwnedBy((Entity)e) || !this.ignoresOwner()) && !this.isAllowed((Entity)e) && !this.respectInvisibility.isConsideredInvisible((EntityLivingBase)e) && !this.wasPlayerRecentlyAdded(e.func_70005_c_(), timestamp));
                if (!nearbyPlayers.isEmpty()) {
                    boolean changed = false;
                    int playerIndex = 0;
                    for (int i = 0; i < this.getPlayers().length && playerIndex < nearbyPlayers.size(); ++i) {
                        if (this.getPlayers()[i] != null && !this.getPlayers()[i].equals("")) continue;
                        EntityPlayer player = (EntityPlayer)nearbyPlayers.get(playerIndex++);
                        this.getPlayers()[i] = player.func_70005_c_();
                        this.getUuids()[i] = player.func_146103_bH().getId().toString();
                        this.getTimestamps()[i] = timestamp;
                        changed = true;
                    }
                    if (changed) {
                        this.func_70296_d();
                        this.syncLoggedPlayersToClient();
                    }
                }
                this.cooldown = 80;
            }
        }
    }

    private boolean wasPlayerRecentlyAdded(String username, long timestamp) {
        long timeout = (long)((Integer)this.repeatedLogInterval.get()).intValue() * 1000L;
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null || !this.getPlayers()[i].equals(username) || this.getTimestamps()[i] + timeout <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            tag.func_74778_a("player" + i, this.getPlayers()[i] == null ? "" : this.getPlayers()[i]);
            tag.func_74778_a("uuid" + i, this.getUuids()[i] == null ? "" : this.getUuids()[i]);
            tag.func_74772_a("timestamp" + i, this.getTimestamps()[i]);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            this.getPlayers()[i] = tag.func_74779_i("player" + i);
            this.getUuids()[i] = tag.func_74779_i("uuid" + i);
            this.getTimestamps()[i] = tag.func_74763_f("timestamp" + i);
        }
    }

    public void syncLoggedPlayersToClient() {
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null) continue;
            SecurityCraft.network.sendToAllTracking((IMessage)new UpdateLogger(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), i, this.getPlayers()[i], this.getUuids()[i], this.getTimestamps()[i]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius, this.disabled, this.ignoreOwner, this.respectInvisibility, this.repeatedLogInterval};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public String[] getPlayers() {
        return this.players;
    }

    public void setPlayers(String[] players) {
        this.players = players;
    }

    public String[] getUuids() {
        return this.uuids;
    }

    public void setUuids(String[] uuids) {
        this.uuids = uuids;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(long[] timestamps) {
        this.timestamps = timestamps;
    }
}

