/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements IEMPAffectedBE,
ITickable,
IInventoryChangedListener,
SingleLensMenu.SingleLensContainer {
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private boolean down = false;
    private boolean initialized = false;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "opacity", 100, 0, 255, 1);
    private IItemHandler insertOnlyHandler;
    private IItemHandler lensHandler;
    private LensContainer lens = new LensContainer(1);
    private int playersViewing = 0;

    public SecurityCameraBlockEntity() {
        this.lens.func_110134_a(this);
    }

    public void func_73660_a() {
        if (!this.initialized) {
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SecurityCameraBlock.FACING), this.initialZoom);
            }
            this.initialized = true;
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                this.cameraRotation = (Double)this.customRotationOption.get();
                return;
            }
            if (this.addToRotation && this.getCameraRotation() <= (double)1.55f) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.getCameraRotation() >= (double)-1.55f) {
                this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void shutDown() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IEMPAffectedBE.super.shutDown();
        if (state.func_177230_c() == SCContent.securityCamera && ((Boolean)state.func_177229_b((IProperty)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("ShutDown", this.shutDown);
        tag.func_74768_a("PlayersViewing", this.playersViewing);
        tag.func_74782_a("lens", (NBTBase)this.lens.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        tag.func_74776_a("initial_x_rotation", this.initialXRotation);
        tag.func_74776_a("initial_y_rotation", this.initialYRotation);
        tag.func_74776_a("initial_zoom", this.initialZoom);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shutDown = tag.func_74767_n("ShutDown");
        this.playersViewing = tag.func_74762_e("PlayersViewing");
        this.lens.func_70299_a(0, new ItemStack(tag.func_74775_l("lens")));
        this.initialXRotation = tag.func_74760_g("initial_x_rotation");
        this.initialYRotation = tag.func_74760_g("initial_y_rotation");
        if (tag.func_74764_b("initial_zoom")) {
            this.initialZoom = tag.func_74760_g("initial_zoom");
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? this.getNormalHandler() : this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper((IInventory)this.lens);
        }
        return this.insertOnlyHandler;
    }

    private IItemHandler getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = new InvWrapper((IInventory)this.lens);
        }
        return this.lensHandler;
    }

    public void func_76316_a(IInventory container) {
        if (this.field_145850_b == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public LensContainer getLensContainer() {
        return this.lens;
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            IBlockState newState = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)newState.func_177229_b((IProperty)SecurityCameraBlock.FACING)).func_176734_d()), this.func_145838_q(), false);
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    @Override
    public void onLoad() {
        IBlockState state;
        super.onLoad();
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof SecurityCameraBlock) {
            this.down = state.func_177229_b((IProperty)SecurityCameraBlock.FACING) == EnumFacing.DOWN;
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    private void makeEveryoneStopViewingTheCamera() {
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayer p : ((WorldServer)this.field_145850_b).field_73010_i) {
                SecurityCamera camera;
                EntityPlayerMP player = (EntityPlayerMP)p;
                if (!(player.func_175398_C() instanceof SecurityCamera) || !(camera = (SecurityCamera)player.func_175398_C()).func_180425_c().equals((Object)this.field_174879_c)) continue;
                camera.stopViewing(player);
            }
        }
    }

    public void startViewing() {
        ++this.playersViewing;
        this.func_70296_d();
        this.sync();
    }

    public void stopViewing() {
        --this.playersViewing;
        this.func_70296_d();
        this.sync();
    }

    public boolean isSomeoneViewing() {
        return this.playersViewing > 0;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public void setDefaultViewingDirection(EnumFacing facing, float zoom) {
        float yRotation;
        switch (facing) {
            case NORTH: {
                yRotation = 180.0f;
                break;
            }
            case WEST: {
                yRotation = 90.0f;
                break;
            }
            case EAST: {
                yRotation = 270.0f;
                break;
            }
            default: {
                yRotation = 0.0f;
            }
        }
        this.setDefaultViewingDirection(this.down ? 75.0f : 30.0f, yRotation, zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.func_70296_d();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }
}

