/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SpawnInterfaceHighlightParticle;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecureRedstoneInterfaceBlockEntity
extends DisguisableBlockEntity
implements ITickable {
    public static final Vec3d SENDER_PARTICLE_COLOR = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d RECEIVER_PARTICLE_COLOR = new Vec3d(1.0, 1.0, 0.0);
    public static final Vec3d RECEIVER_PARTICLE_COLOR_NO_SIGNAL = new Vec3d(1.0, 1.0, 1.0);
    public static final Vec3d RECEIVER_PROTECTED_PARTICLE_COLOR = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL = new Vec3d(0.0, 0.0, 0.0);
    public final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private boolean tracked = false;
    private boolean refreshed = false;
    private boolean sender = true;
    private int power = 0;
    private int frequency = 0;
    private int senderRange = 24;
    private boolean protectedSignal = false;
    private boolean sendExactPower = true;
    private boolean receiveInvertedPower = false;
    private boolean highlightConnections = false;
    private float dishRotationDegrees = 0.0f;
    private float oDishRotationDegrees = 0.0f;
    private boolean changed = false;
    private boolean updateNeighbors = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Collection<EntityPlayerMP> players;
            if (!this.tracked) {
                if (this.isSender()) {
                    this.refreshPower();
                }
                BlockEntityTracker.SECURE_REDSTONE_INTERFACE.track(this);
                this.tracked = true;
            } else if (!this.refreshed) {
                this.refreshed = true;
                if (this.isSender()) {
                    this.tellSimilarReceiversToRefresh();
                }
            }
            if (this.changed || this.updateNeighbors) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (this.changed) {
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
                    this.changed = false;
                }
                if (this.updateNeighbors) {
                    BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, state.func_177230_c(), ((EnumFacing)state.func_177229_b((IProperty)SecureRedstoneInterfaceBlock.FACING)).func_176734_d());
                    this.updateNeighbors = false;
                }
            }
            if (this.shouldHighlightConnections() && this.field_145850_b.func_82737_E() % 5L == 0L && !(players = TeamUtils.getOnlinePlayersFromOwner(this.field_145850_b.func_73046_m(), this.getOwner())).isEmpty()) {
                WorldServer serverLevel = (WorldServer)this.field_145850_b;
                Vec3d myPos = Utils.atCenterOf(this.field_174879_c);
                if (this.isSender()) {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversISendTo()) {
                        if (be.isDisabled()) continue;
                        Vec3d receiverPos = Utils.atCenterOf(be.field_174879_c);
                        this.showParticleTrail(players, serverLevel, myPos, receiverPos, SENDER_PARTICLE_COLOR);
                    }
                } else {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe()) {
                        Vec3d senderPos = Utils.atCenterOf(be.field_174879_c);
                        Vec3d color = be.getPower() == 0 ? (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL : RECEIVER_PARTICLE_COLOR_NO_SIGNAL) : (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR : RECEIVER_PARTICLE_COLOR);
                        this.showParticleTrail(players, serverLevel, senderPos, myPos, color);
                    }
                }
            }
        } else {
            this.oDishRotationDegrees = this.dishRotationDegrees;
            if (!this.isDisabled()) {
                this.dishRotationDegrees = this.oDishRotationDegrees + 0.05f;
                if (this.dishRotationDegrees >= 360.0f) {
                    this.dishRotationDegrees = 0.0f;
                }
            }
        }
    }

    public void showParticleTrail(Collection<EntityPlayerMP> players, WorldServer level, Vec3d senderPos, Vec3d receiverPos, Vec3d color) {
        Vec3d senderToReceiver = receiverPos.func_178788_d(senderPos);
        double step = senderToReceiver.func_72433_c() * 6.0;
        Vec3d particleDirection = senderToReceiver.func_72432_b().func_186678_a((double)0.01f);
        int i = 0;
        while ((double)i < step) {
            Vec3d particlePos = Utils.lerp(receiverPos, senderPos, (double)i / step);
            for (EntityPlayerMP player : players) {
                SecurityCraft.network.sendTo((IMessage)new SpawnInterfaceHighlightParticle(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, color.field_72450_a, color.field_72448_b, color.field_72449_c, particleDirection.field_72450_a, particleDirection.field_72448_b, particleDirection.field_72449_c), player);
            }
            ++i;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            BlockEntityTracker.SECURE_REDSTONE_INTERFACE.stopTracking(this);
        }
    }

    @Override
    public void onOwnerChanged(IBlockState state, World level, BlockPos pos, EntityPlayer player, Owner oldOwner, Owner newOwner) {
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
        if (this.isSender()) {
            int currentFrequency = this.getFrequency();
            int range = this.getSenderRange();
            this.tellSimilarReceiversToRefresh(oldOwner, currentFrequency, range);
        } else {
            this.setPower(0);
        }
    }

    @Override
    public boolean needsValidation() {
        return true;
    }

    @Override
    public void onValidate() {
        this.refreshPower();
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled) {
            if (this.isDisabled()) {
                this.setPower(0);
            } else {
                this.refreshPower();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.sender = tag.func_74767_n("sender");
        this.power = tag.func_74762_e("power");
        this.frequency = tag.func_74762_e("frequency");
        this.senderRange = tag.func_74762_e("sender_range");
        this.protectedSignal = tag.func_74767_n("protected_signal");
        this.sendExactPower = tag.func_74767_n("send_exact_power");
        this.receiveInvertedPower = tag.func_74767_n("receive_inverted_power");
        this.highlightConnections = tag.func_74767_n("highlight_connections");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("sender", this.sender);
        tag.func_74768_a("power", this.power);
        tag.func_74768_a("frequency", this.frequency);
        tag.func_74768_a("sender_range", this.senderRange);
        tag.func_74757_a("protected_signal", this.protectedSignal);
        tag.func_74757_a("send_exact_power", this.sendExactPower);
        tag.func_74757_a("receive_inverted_power", this.receiveInvertedPower);
        tag.func_74757_a("highlight_connections", this.highlightConnections);
        return tag;
    }

    public boolean isSender() {
        return this.sender;
    }

    public void setSender(boolean sender) {
        if (this.isSender() == sender || !this.getOwner().isValidated()) {
            return;
        }
        this.sender = sender;
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SecureRedstoneInterfaceBlock.SENDER, (Comparable)Boolean.valueOf(sender)));
            this.func_70296_d();
            if (!this.isDisabled()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.updateNeighbors();
        }
    }

    public int getPower() {
        return this.power;
    }

    public void refreshPower() {
        this.refreshPower(this.getFrequency());
    }

    public void refreshPower(int frequency) {
        if (this.field_145850_b.field_72995_K || this.isDisabled() || !this.getOwner().isValidated()) {
            return;
        }
        if (this.isSender()) {
            int bestSignal = this.isProtectedSignal() ? (BlockUtils.hasActiveSCBlockNextTo(this.field_145850_b, this.field_174879_c) ? 15 : 0) : this.field_145850_b.func_175687_A(this.field_174879_c);
            if (this.sendsExactPower()) {
                this.setPower(bestSignal);
            } else {
                this.setPower(bestSignal > 0 ? 15 : 0);
            }
        } else {
            int highestPower = 0;
            boolean protectedSignal = true;
            boolean foundSender = false;
            for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe(frequency)) {
                int ownPower = be.getPower();
                foundSender = true;
                if (ownPower > highestPower) {
                    highestPower = ownPower;
                }
                if (!be.isProtectedSignal()) {
                    protectedSignal = false;
                }
                if (highestPower != 15 || protectedSignal) continue;
                break;
            }
            if (!foundSender) {
                protectedSignal = false;
            }
            if (this.receivesInvertedPower()) {
                highestPower = 15 - highestPower;
            }
            if (this.protectedSignal != protectedSignal) {
                this.protectedSignal = protectedSignal;
                this.updateNeighbors();
            }
            this.setPower(highestPower);
        }
    }

    public void setPower(int power) {
        if (this.getPower() == power) {
            return;
        }
        this.power = power;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.func_70296_d();
            this.updateNeighbors();
        }
    }

    public int getRedstonePowerOutput() {
        if (!this.isSender() && !this.isDisabled()) {
            return this.getPower();
        }
        return 0;
    }

    public boolean isProtectedSignal() {
        return this.protectedSignal;
    }

    public void setProtectedSignal(boolean protectedSignal) {
        if (this.isProtectedSignal() == protectedSignal || !this.getOwner().isValidated()) {
            return;
        }
        this.protectedSignal = protectedSignal;
        if (!this.field_145850_b.field_72995_K) {
            this.refreshPower();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            } else {
                this.updateNeighbors();
            }
            this.func_70296_d();
        }
    }

    public boolean sendsExactPower() {
        return this.sendExactPower;
    }

    public void setSendExactPower(boolean sendExactPower) {
        if (this.sendsExactPower() == sendExactPower || !this.getOwner().isValidated()) {
            return;
        }
        this.sendExactPower = sendExactPower;
        if (!this.field_145850_b.field_72995_K && this.isSender()) {
            this.refreshPower();
            this.func_70296_d();
            this.updateNeighbors();
        }
    }

    public boolean receivesInvertedPower() {
        return this.receiveInvertedPower;
    }

    public void setReceiveInvertedPower(boolean receiveInvertedPower) {
        if (this.receivesInvertedPower() == receiveInvertedPower || !this.getOwner().isValidated()) {
            return;
        }
        this.receiveInvertedPower = receiveInvertedPower;
        if (!this.field_145850_b.field_72995_K && !this.isSender()) {
            this.refreshPower();
            this.func_70296_d();
            this.updateNeighbors();
        }
    }

    public void tellSimilarReceiversToRefresh() {
        this.tellSimilarReceiversToRefresh(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public void tellSimilarReceiversToRefresh(Owner owner, int frequency, int range) {
        if (!this.field_145850_b.field_72995_K && this.getOwner().isValidated()) {
            for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversToSendTo(owner, frequency, range)) {
                be.refreshPower(frequency);
            }
        }
    }

    public void setFrequency(int frequency) {
        int oldFrequency = this.getFrequency();
        if (oldFrequency == frequency || !this.getOwner().isValidated()) {
            return;
        }
        this.frequency = frequency;
        if (!this.field_145850_b.field_72995_K) {
            Owner owner = this.getOwner();
            int range = this.getSenderRange();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh(owner, oldFrequency, range);
                this.tellSimilarReceiversToRefresh(owner, frequency, range);
            } else {
                this.refreshPower();
            }
            this.func_70296_d();
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isSameFrequency(int frequency) {
        return this.getFrequency() == frequency;
    }

    public void setSenderRange(int senderRange) {
        senderRange = MathHelper.func_76125_a((int)senderRange, (int)1, (int)64);
        if (this.getSenderRange() == senderRange || !this.getOwner().isValidated()) {
            return;
        }
        int oldRange = this.senderRange;
        this.senderRange = senderRange;
        if (!this.field_145850_b.field_72995_K && !this.isDisabled() && this.isSender()) {
            Owner owner = this.getOwner();
            int frequency = this.getFrequency();
            this.tellSimilarReceiversToRefresh(owner, frequency, Math.max(oldRange, senderRange));
            this.func_70296_d();
        }
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversISendTo() {
        return this.getReceiversToSendTo(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversToSendTo(Owner owner, int frequency, int range) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getTileEntitiesAround(this.field_145850_b, this.field_174879_c, range);
        all.removeIf(be -> be.isSender() || !be.isOwnedBy(owner) || !be.isSameFrequency(frequency));
        return all;
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe() {
        return this.getSendersThatSendToMe(this.getFrequency());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe(int frequency) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getTileEntitiesInRange(this.field_145850_b, this.field_174879_c);
        all.removeIf(be -> be.isDisabled() || !be.isSender() || !be.isOwnedBy(this.getOwner()) || !be.isSameFrequency(frequency));
        return all;
    }

    public int getSenderRange() {
        return this.senderRange;
    }

    public boolean shouldHighlightConnections() {
        return this.highlightConnections;
    }

    public void setHighlightConnections(boolean highlightConnections) {
        this.highlightConnections = highlightConnections;
        this.func_70296_d();
    }

    public void updateNeighbors() {
        this.updateNeighbors = true;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    public float getOriginalDishRotationDegrees() {
        return this.oDishRotationDegrees;
    }

    public float getDishRotationDegrees() {
        return this.dishRotationDegrees;
    }

    public void func_70296_d() {
        this.changed = true;
        super.func_70296_d();
    }
}

