/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class PortableRadarBlockEntity
extends CustomizableBlockEntity
implements ITickable {
    private Option.IntOption searchRadiusOption = new Option.IntOption(() -> ((PortableRadarBlockEntity)this).func_174877_v(), "searchRadius", 25, 1, 50, 1);
    private Option.IntOption searchDelayOption = new Option.IntOption(() -> ((PortableRadarBlockEntity)this).func_174877_v(), "searchDelay", 4, 4, 10, 1);
    private Option.BooleanOption repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Set<Owner> seenPlayers = new HashSet<Owner>();
    private int ticksUntilNextSearch = this.getSearchDelay();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !((Boolean)this.disabled.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getSearchRadius(), this.getSearchRadius(), this.getSearchRadius());
            List closebyPlayers = this.field_145850_b.func_175647_a(EntityPlayer.class, area, e -> (!this.isOwnedBy((Entity)e) || !this.ignoresOwner()) && (!this.isModuleEnabled(ModuleType.DENYLIST) && !this.isAllowed((Entity)e) || this.isDenied((Entity)e)) && !e.func_175149_v() && !this.respectInvisibility.isConsideredInvisible((EntityLivingBase)e));
            List closebyOwners = closebyPlayers.stream().map(Owner::new).collect(Collectors.toList());
            if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, !closebyPlayers.isEmpty());
            }
            if (!closebyPlayers.isEmpty()) {
                Collection<EntityPlayerMP> onlineTeamPlayers = TeamUtils.getOnlinePlayersFromOwner(this.field_145850_b.func_73046_m(), this.getOwner());
                for (EntityPlayer closebyPlayer : closebyPlayers) {
                    if (!this.shouldSendMessage(closebyPlayer)) continue;
                    String attackedName = TextFormatting.ITALIC + closebyPlayer.func_70005_c_() + TextFormatting.RESET;
                    TextComponentTranslation text = this.func_145818_k_() ? Utils.localize("messages.securitycraft:portableRadar.withName", attackedName, TextFormatting.ITALIC + this.func_70005_c_() + TextFormatting.RESET, this.field_174879_c) : Utils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, this.field_174879_c);
                    if (onlineTeamPlayers.isEmpty()) continue;
                    onlineTeamPlayers.forEach(arg_0 -> PortableRadarBlockEntity.lambda$update$1((ITextComponent)text, arg_0));
                }
            }
            this.seenPlayers.removeIf(owner -> !closebyOwners.contains(owner));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public void readOptions(NBTTagCompound tag) {
        if (tag.func_74764_b("enabled")) {
            tag.func_74757_a("disabled", !tag.func_74767_n("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public boolean shouldSendMessage(EntityPlayer player) {
        return this.seenPlayers.add(new Owner(player)) || (Boolean)this.repeatMessageOption.get() != false;
    }

    public double getSearchRadius() {
        return ((Integer)this.searchRadiusOption.get()).intValue();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.disabled, this.ignoreOwner, this.respectInvisibility};
    }

    private static /* synthetic */ void lambda$update$1(ITextComponent text, EntityPlayerMP player) {
        PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)Utils.localize(SCContent.portableRadar, new Object[0]), text, TextFormatting.BLUE);
    }
}

