/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IPasscodeProtected
extends ICodebreakable {
    default public void openPasscodeGUI(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && this.getPasscode() != null) {
            player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.INSERT_PASSCODE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    default public boolean verifyPasscodeSet(World world, BlockPos pos, IOwnable ownable, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (this.getPasscode() != null) {
                return true;
            }
            if (ownable.isOwnedBy((Entity)player)) {
                this.openSetPasscodeScreen((EntityPlayerMP)player, world, pos);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passcodeProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            }
        }
        return false;
    }

    default public void openSetPasscodeScreen(EntityPlayerMP player, World world, BlockPos pos) {
        player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.SETUP_PASSCODE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    default public boolean shouldAttemptCodebreak(EntityPlayer player) {
        if (this.getPasscode() == null) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passcodeProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            return false;
        }
        return true;
    }

    @Override
    default public void useCodebreaker(EntityPlayer player) {
        this.activate(player);
    }

    public void activate(EntityPlayer var1);

    public byte[] getPasscode();

    default public void hashAndSetPasscode(String passcode) {
        this.hashAndSetPasscode(passcode, b -> {});
    }

    default public void hashAndSetPasscode(String passcode, Consumer<byte[]> afterSetting) {
        this.hashAndSetPasscode(passcode, PasscodeUtils.generateSalt(), afterSetting);
    }

    default public void hashAndSetPasscode(String passcode, byte[] salt) {
        this.hashAndSetPasscode(passcode, salt, b -> {});
    }

    default public void hashAndSetPasscode(String passcode, byte[] salt, Consumer<byte[]> afterSetting) {
        Consumer<byte[]> afterHashing = this::setPasscode;
        SaltData.removeSalt(this.getSaltKey());
        this.setSaltKey(SaltData.putSalt(salt));
        PasscodeUtils.hashPasscode(passcode, salt, afterHashing.andThen(afterSetting));
    }

    public void setPasscode(byte[] var1);

    default public void loadSaltKey(NBTTagCompound tag) {
        UUID saltKey = tag.func_186855_b("saltKey") ? tag.func_186857_a("saltKey") : null;
        String passcode = tag.func_74779_i(tag.func_150297_b("Passcode", 8) ? "Passcode" : "passcode");
        if (passcode.length() == 32) {
            if (!SaltData.containsKey(saltKey)) {
                PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
                return;
            }
            if (SaltData.isKeyInUse(saltKey)) {
                saltKey = SaltData.copySaltToNewKey(saltKey);
            }
            this.setSaltKey(saltKey);
            SaltData.setKeyInUse(saltKey);
        }
    }

    default public void loadPasscode(NBTTagCompound tag) {
        String passcode = tag.func_74779_i(tag.func_150297_b("Passcode", 8) ? "Passcode" : "passcode");
        if (!passcode.isEmpty()) {
            if (passcode.length() <= 20) {
                this.hashAndSetPasscode(PasscodeUtils.hashPasscodeWithoutSalt(passcode));
            } else {
                this.setPasscode(PasscodeUtils.stringToBytes(passcode));
            }
        }
    }

    default public byte[] getSalt() {
        return SaltData.getSalt(this.getSaltKey());
    }

    public UUID getSaltKey();

    public void setSaltKey(UUID var1);

    public void startCooldown();

    public boolean isOnCooldown();

    public long getCooldownEnd();

    default public void onIncorrectPasscodeEntered(EntityPlayer player, String incorrectCode) {
        if (this instanceof IModuleInventory) {
            IModuleInventory moduleInv = (IModuleInventory)((Object)this);
            if (moduleInv.isModuleEnabled(ModuleType.SMART)) {
                this.startCooldown();
            }
            if (moduleInv.isModuleEnabled(ModuleType.HARMING) && player.func_70097_a(CustomDamageSources.INCORRECT_PASSCODE, (float)ConfigHandler.incorrectPasscodeDamage)) {
                player.func_71053_j();
            }
        }
    }
}

