/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.PortalSize;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SCWorldListener;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    public static final Map<String, String> TIPS_WITH_LINK = new HashMap<String, String>();
    public static final Map<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>> PLAYING_TUNES = new HashMap<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>();
    private static final Integer NOTE_DELAY = 9;

    private SCEventHandler() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    if (PlayerUtils.getItemStackFromAnyHand(player, SCContent.portableTunePlayer).func_190926_b()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    SonicSecuritySystemBlockEntity.NoteWrapper note = (SonicSecuritySystemBlockEntity.NoteWrapper)((Deque)pair.getRight()).poll();
                    if (note != null) {
                        SoundEvent sound = ((BlockNote)Blocks.field_150323_B).func_185576_e(NoteBlockEvent.Instrument.valueOf((String)note.instrumentName.toUpperCase()).ordinal());
                        float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.field_70170_p, player.func_180425_c(), note.noteID, note.instrumentName);
                        pair.setLeft((Object)NOTE_DELAY);
                    } else {
                        pair.setLeft((Object)-1);
                    }
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ConfigHandler.sayThanksMessage) {
            String tipKey = SCEventHandler.getRandomTip();
            ITextComponent message = new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] ").func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:thanks", SecurityCraft.getVersion())).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:tip", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize(tipKey, new Object[0]));
            if (TIPS_WITH_LINK.containsKey(tipKey.split("\\.")[2])) {
                message.func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a(ForgeHooks.newChatWithLinks((String)TIPS_WITH_LINK.get(tipKey.split("\\.")[2])));
            }
            event.player.func_145747_a(message);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (player.func_175398_C() instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)player.func_175398_C();
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v));
            if (player.func_70660_b(MobEffects.field_76439_r) instanceof CameraNightVisionEffectInstance) {
                player.func_184589_d(MobEffects.field_76439_r);
            }
            if (tile instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)tile).stopViewing();
            }
            cam.func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLevelLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world instanceof WorldServer && world.field_73011_w.getDimension() == 0) {
            SaltData.refreshLevel((WorldServer)world);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(WorldEvent.Unload event) {
        World level = event.getWorld();
        if (level instanceof WorldServer && level.field_73011_w.getDimension() == 0) {
            SaltData.invalidate();
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        EntityLivingBase entity;
        if (ConfigHandler.reinforcedSuffocationDamage != -1 && (entity = event.getEntityLiving()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            World level = player.field_70170_p;
            DamageSource damageSource = event.getSource();
            if (!player.func_184812_l_() && damageSource == DamageSource.field_76368_d && !player.func_180431_b(damageSource) && BlockUtils.isInsideUnownedReinforcedBlocks(level, (EntityPlayer)player, player.func_70047_e())) {
                player.func_70097_a(CustomDamageSources.IN_REINFORCED_WALL, (float)ConfigHandler.reinforcedSuffocationDamage);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            world.func_184133_a(null, entity.func_180425_c(), SCSounds.ELECTRIFIED.event, SoundCategory.BLOCKS, 0.25f, 1.0f);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && PlayerUtils.isPlayerMountedOnCamera(entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ((SecurityCamera)player.func_175398_C()).stopViewing(player);
        }
    }

    @SubscribeEvent
    public static void onDismount(EntityMountEvent event) {
        if (!event.getWorldObj().field_72995_K && ConfigHandler.preventReinforcedFloorGlitching && event.isDismounting() && event.getEntityBeingMounted() instanceof EntityBoat && event.getEntityMounting() instanceof EntityPlayer) {
            EntityBoat boat = (EntityBoat)event.getEntityBeingMounted();
            EntityPlayer player = (EntityPlayer)event.getEntityMounting();
            if (player.func_70089_S() && !player.field_71075_bZ.field_75102_a) {
                Vec3d oldPlayerPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                Vec3d incorrectDismountLocation = new Vec3d(boat.field_70165_t, boat.field_70163_u + (double)player.field_70131_O + 0.001, boat.field_70161_v);
                player.func_110145_l((Entity)boat);
                Vec3d dismountLocation = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                if (dismountLocation.equals((Object)incorrectDismountLocation) && (BlockUtils.isInsideUnownedReinforcedBlocks(player.field_70170_p, player, player.func_70047_e()) || BlockUtils.isInsideUnownedReinforcedBlocks(player.field_70170_p, player, player.field_70131_O / 2.0f) || BlockUtils.isInsideUnownedReinforcedBlocks(player.field_70170_p, player, 0.0))) {
                    player.field_70177_z = boat.field_70177_z + 180.0f;
                    player.func_70107_b(oldPlayerPos.field_72450_a, oldPlayerPos.field_72448_b, oldPlayerPos.field_72449_c);
                    player.func_110145_l((Entity)boat);
                    dismountLocation = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    if (dismountLocation.equals((Object)incorrectDismountLocation)) {
                        event.setCanceled(true);
                    }
                }
                player.func_70107_b(oldPlayerPos.field_72450_a, oldPlayerPos.field_72448_b, oldPlayerPos.field_72449_c);
            }
        }
    }

    @SubscribeEvent
    public static void onBucketUsed(FillBucketEvent event) {
        ItemStack result;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        World world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getTarget().func_178782_a()).func_177230_c();
        if (block == SCContent.fakeWater) {
            result = new ItemStack(SCContent.fWaterBucket, 1);
        } else if (block == SCContent.fakeLava) {
            result = new ItemStack(SCContent.fLavaBucket, 1);
        } else {
            return;
        }
        world.func_175698_g(pos);
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof INameSetter && ((INameSetter)te).func_145818_k_()) {
            ((ItemStack)event.getDrops().get(0)).func_151001_c(((INameSetter)te).func_70005_c_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(stack.func_190926_b() || item instanceof ItemBlock || item == SCContent.adminTool || item == SCContent.codebreaker || item == SCContent.universalBlockRemover || item == SCContent.universalBlockModifier || item == SCContent.universalKeyChanger || item == SCContent.universalOwnerChanger || item instanceof ModuleItem)) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (block == SCContent.keypadDoor) {
                event.setUseItem(Event.Result.DENY);
            } else if (block == SCContent.reinforcedDoor || block == SCContent.reinforcedIronTrapdoor || block == SCContent.scannerDoor) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Sentry sentry;
        IOwnable ownable;
        Object owner;
        EntityPlayer player = event.getEntityPlayer();
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        TileEntity te = world.func_175625_s(event.getPos());
        IBlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        EnumHand hand = event.getHand();
        if (te instanceof ILockable && ((ILockable)te).isLocked() && ((ILockable)te).disableInteractionWhenLocked(world, pos, player) && !player.func_70093_af()) {
            if (hand == EnumHand.MAIN_HAND) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", Utils.localize(block, new Object[0])), TextFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (te instanceof IOwnable && !((Owner)(owner = (ownable = (IOwnable)te).getOwner())).isValidated()) {
            if (ownable.isOwnedBy((Entity)player)) {
                ((Owner)owner).setValidated(true);
                ownable.onValidate();
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:ownable.validate", new Object[0]), TextFormatting.GREEN);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:ownable.ownerNotValidated", new Object[0]), TextFormatting.RED);
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (event.getItemStack().func_77973_b() == Items.field_151137_ax && te instanceof IEMPAffected && ((IEMPAffected)te).isShutDown()) {
            ((IEMPAffected)te).reactivate();
            if (!player.func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            player.func_184609_a(hand);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        Item heldItem = player.func_184586_b(hand).func_77973_b();
        if (heldItem == SCContent.keyPanel && (!(te instanceof IOwnable) || ((IOwnable)te).isOwnedBy((Entity)player))) {
            for (IPasscodeConvertible pc : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!pc.isUnprotectedBlock(state)) continue;
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.ALLOW);
            }
            return;
        }
        if (heldItem == SCContent.codebreaker && te instanceof ICodebreakable) {
            ((ICodebreakable)te).handleCodebreaking(player, event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (heldItem == SCContent.universalBlockModifier) {
            if (te instanceof DisplayCaseBlockEntity && ((DisplayCaseBlockEntity)te).isOpen() && ((DisplayCaseBlockEntity)te).getDisplayedStack().func_190926_b()) {
                return;
            }
            if (te instanceof IModuleInventory) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
                if (te instanceof IOwnable && !((IOwnable)te).isOwnedBy((Entity)player)) {
                    if (!(te.func_145838_q() instanceof IDisguisable) || ((IDisguisable)te.func_145838_q()).getDisguisedBlockState((IBlockAccess)world, pos).func_177230_c() instanceof IDisguisable) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalBlockModifier, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner())), TextFormatting.RED);
                    }
                    return;
                }
                player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.CUSTOMIZE_BLOCK.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return;
            }
        }
        if (block instanceof DisplayCaseBlock && event.getEntity().func_70093_af() && player.func_184614_ca().func_190926_b() && !player.func_184592_cb().func_190926_b()) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
            return;
        }
        List sentries = world.func_72872_a(Sentry.class, new AxisAlignedBB(pos));
        if (!sentries.isEmpty() && pos.equals((Object)(sentry = (Sentry)sentries.get(0)).func_180425_c())) {
            event.setCanceled(sentry.func_184645_a(player, hand));
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        Item held = stack.func_77973_b();
        if (held == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3) {
            UniversalBlockReinforcerItem.maybeRemoveMending(stack);
            if (UniversalBlockReinforcerItem.convertBlock(stack, event.getPos(), event.getEntityPlayer())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getPlayer().func_184812_l_() && !(sentries = world.func_72872_a(Sentry.class, new AxisAlignedBB(event.getPos()))).isEmpty() && event.getPos().equals((Object)((Sentry)sentries.get(0)).func_180425_c())) {
            event.setCanceled(true);
            return;
        }
        if (!world.field_72995_K) {
            IModuleInventory te;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IModuleInventory && (te = (IModuleInventory)tile).shouldDropModules()) {
                int i = 100;
                while (i - 100 < te.getMaxNumberOfModules()) {
                    if (!te.getStackInSlot(i).func_190926_b()) {
                        ItemStack stack = te.getStackInSlot(i);
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                        Utils.addScheduledTask(world, () -> world.func_72838_d((Entity)item));
                        te.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType(), false);
                        if (te instanceof LinkableBlockEntity) {
                            LinkableBlockEntity linkable = (LinkableBlockEntity)te;
                            linkable.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.func_77973_b()).getModuleType(), false), linkable);
                        }
                        if (te instanceof SecurityCameraBlockEntity) {
                            SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)te;
                            cam.func_145831_w().func_175685_c(cam.func_174877_v().func_177967_a((EnumFacing)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((IProperty)SecurityCameraBlock.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c(), true);
                        }
                    }
                    ++i;
                }
            }
            EntityPlayer player = event.getPlayer();
            IBlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTileEntitiesInRange(world, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.EnumDetectionMode.BREAK, pos, state));
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("securitycraft")) {
            ConfigManager.sync((String)"securitycraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_70005_c_();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        if (event.getState().func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian) {
            PortalSize portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
            if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                portalSize.placePortalBlocks();
            } else {
                portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z);
                if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                    portalSize.placePortalBlocks();
                }
            }
        }
        if (!world.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            BlockPos pos = event.getPos();
            IBlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTileEntitiesInRange(world, pos).forEach(detector -> detector.log((EntityPlayer)event.getEntity(), BlockChangeDetectorBlockEntity.EnumDetectionMode.PLACE, pos, state));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getEntity().func_180425_c();
            do {
                Object portalSize;
                if (event.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.X);
                    if (portalSize.func_150860_b()) {
                        double y = (double)pos.func_177956_o() + 0.5;
                        if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                            y -= 3.0;
                        }
                        event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                        break;
                    }
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.Z);
                    if (!portalSize.func_150860_b()) continue;
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                if (event.getWorld().func_180495_p(pos).func_177230_c() != SCContent.reinforcedObsidian) continue;
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.X);
                if (((PortalSize)portalSize).isValid()) {
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.Z);
                if (!((PortalSize)portalSize).isValid()) continue;
                double y = (double)pos.func_177956_o() + 0.5;
                if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                    y -= 3.0;
                }
                event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                break;
            } while ((pos = pos.func_177984_a()).func_177956_o() < Math.min(event.getWorld().func_72800_K(), 256));
        }
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150427_aO) {
            PortalSize portalSize;
            EnumFacing.Axis axis = (EnumFacing.Axis)event.getState().func_177229_b((IProperty)BlockPortal.field_176550_a);
            if (axis == EnumFacing.Axis.X) {
                PortalSize portalSize2 = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
                if (portalSize2.isValid() || portalSize2.getPortalBlockCount() > portalSize2.getWidth() * portalSize2.getHeight()) {
                    event.setCanceled(true);
                }
            } else if (axis == EnumFacing.Axis.Z && ((portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z)).isValid() || portalSize.getPortalBlockCount() > portalSize.getWidth() * portalSize.getHeight())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (event.getTarget() instanceof Sentry) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new SCWorldListener());
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer()) && event.getItemStack().func_77973_b() != SCContent.cameraMonitor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof EntityWither && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onEntityTeleport(EnderTeleportEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Vec3d target = new Vec3d(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        event.setCanceled(SCEventHandler.handleEntityTeleport(entity, entity.func_174791_d(), target, RiftStabilizerBlockEntity.TeleportationType.getTypeFromEvent(entity, target)));
    }

    public static boolean handleEntityTeleport(EntityLivingBase entity, Vec3d source, Vec3d target, RiftStabilizerBlockEntity.TeleportationType type) {
        World world = entity.func_130014_f_();
        List<RiftStabilizerBlockEntity> targetPosTileEntities = BlockEntityTracker.RIFT_STABILIZER.getTileEntitiesInRange(world, target);
        List<RiftStabilizerBlockEntity> sourcePosTileEntities = BlockEntityTracker.RIFT_STABILIZER.getTileEntitiesInRange(world, source);
        List<Object> tileEntities = new ArrayList<RiftStabilizerBlockEntity>();
        RiftStabilizerBlockEntity riftStabilizer = null;
        boolean targetPosProhibited = false;
        tileEntities.addAll(targetPosTileEntities);
        tileEntities.addAll(sourcePosTileEntities);
        tileEntities = tileEntities.stream().distinct().sorted(Comparator.comparingDouble(t -> Math.min(t.func_174877_v().func_177957_d(target.field_72450_a, target.field_72448_b, target.field_72449_c), t.func_174877_v().func_177957_d(source.field_72450_a, source.field_72448_b, source.field_72449_c)))).collect(Collectors.toList());
        for (RiftStabilizerBlockEntity riftStabilizerBlockEntity : tileEntities) {
            if (riftStabilizerBlockEntity.isDisabled() || !riftStabilizerBlockEntity.getFilter(type) || entity instanceof EntityPlayer && (riftStabilizerBlockEntity.isOwnedBy((Entity)entity) && riftStabilizerBlockEntity.ignoresOwner() || riftStabilizerBlockEntity.isAllowed((Entity)entity))) continue;
            riftStabilizer = riftStabilizerBlockEntity;
            targetPosProhibited = riftStabilizerBlockEntity.func_174877_v().func_177957_d(target.field_72450_a, target.field_72448_b, target.field_72449_c) < riftStabilizerBlockEntity.func_174877_v().func_177957_d(source.field_72450_a, source.field_72448_b, source.field_72449_c);
            break;
        }
        if (riftStabilizer != null) {
            BlockPos pos = riftStabilizer.func_174877_v();
            Vec3d vec3d = SCEventHandler.getCenter(new AxisAlignedBB(pos));
            Vec3d from = targetPosProhibited ? target : source;
            Vec3d distance = from.func_178788_d(vec3d);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                world.func_184148_a(null, source.field_72450_a, source.field_72448_b, source.field_72449_c, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.5f);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.riftStabilizer, new Object[0]), (ITextComponent)Utils.localize(targetPosProhibited ? "messages.securitycraft:rift_stabilizer.no_teleport_to" : "messages.securitycraft:rift_stabilizer.no_teleport_from", new Object[0]), TextFormatting.RED);
                if (riftStabilizer.isModuleEnabled(ModuleType.HARMING)) {
                    player.func_70097_a(DamageSource.field_76379_h, 5.0f);
                }
            }
            riftStabilizer.setLastTeleport(Math.max(Math.abs(distance.field_72450_a), Math.max(Math.abs(distance.field_72448_b), Math.abs(distance.field_72449_c))) - 0.5, type);
            if (riftStabilizer.isModuleEnabled(ModuleType.REDSTONE)) {
                int signalLength = riftStabilizer.getSignalLength();
                world.func_175656_a(pos, world.func_180495_p(pos).func_177231_a((IProperty)RiftStabilizerBlock.POWERED));
                BlockUtils.updateIndirectNeighbors(world, pos, SCContent.riftStabilizer);
                if (signalLength > 0) {
                    world.func_175684_a(pos, SCContent.riftStabilizer, signalLength);
                }
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote(event.getWorld(), event.getPos(), event.getVanillaNoteId(), event.getInstrument().name());
    }

    private static void handlePlayedNote(World world, BlockPos pos, int vanillaNoteId, String instrumentName) {
        List<SonicSecuritySystemBlockEntity> sonicSecuritySystems = BlockEntityTracker.SONIC_SECURITY_SYSTEM.getTileEntitiesInRange(world, pos);
        for (SonicSecuritySystemBlockEntity te : sonicSecuritySystems) {
            if (!te.isActive()) continue;
            if (te.isRecording()) {
                te.recordNote(vanillaNoteId, instrumentName);
                continue;
            }
            te.listenToNote(vanillaNoteId, instrumentName);
        }
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver", "messages.securitycraft:tip.outdated"};
        return tips[SecurityCraft.RANDOM.nextInt(SCEventHandler.isOutdated() ? tips.length : tips.length - 1)];
    }

    private static boolean isOutdated() {
        return ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer()).status == ForgeVersion.Status.OUTDATED;
    }

    private static Vec3d getCenter(AxisAlignedBB vec) {
        return new Vec3d(vec.field_72340_a + (vec.field_72336_d - vec.field_72340_a) * 0.5, vec.field_72338_b + (vec.field_72337_e - vec.field_72338_b) * 0.5, vec.field_72339_c + (vec.field_72334_f - vec.field_72339_c) * 0.5);
    }

    static {
        TIPS_WITH_LINK.put("patreon", "https://www.patreon.com/Geforce");
        TIPS_WITH_LINK.put("discord", "https://discord.gg/U8DvBAW");
        TIPS_WITH_LINK.put("outdated", "https://www.curseforge.com/minecraft/mc-mods/security-craft/files/all");
    }
}

