/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.items.TaserItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="securitycraft")
public class SCClientEventHandler {
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");

    private SCClientEventHandler() {
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient level = mc.field_71441_e;
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedTileEntities((World)level)) {
            BlockChangeDetectorBlockEntity bcd;
            TileEntity be = level.func_175625_s(bcdPos);
            if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Entity)mc.field_71439_g)) continue;
            for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                BlockPos pos = changeEntry.pos;
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - x), (double)((double)pos.func_177956_o() - y), (double)((double)pos.func_177952_p() - z));
                ClientUtils.renderBoxInLevel(0.0, 1.0, 0.0, 1.0, 1.0, bcd.getColor());
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderSpecificHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            event.setCanceled(true);
        } else {
            boolean mainHandTaser = player.func_184614_ca().func_77973_b() instanceof TaserItem;
            boolean offhandTaser = player.func_184592_cb().func_77973_b() instanceof TaserItem;
            if (mainHandTaser || offhandTaser) {
                boolean isMainHand;
                boolean isRightHanded = mc.field_71474_y.field_186715_A == EnumHandSide.RIGHT;
                boolean bl = isMainHand = event.getHand() == EnumHand.MAIN_HAND;
                if (mainHandTaser && offhandTaser) {
                    event.setCanceled(!isMainHand);
                } else if (isMainHand && offhandTaser || !isMainHand && mainHandTaser) {
                    event.setCanceled(true);
                    return;
                }
                if (isRightHanded == isMainHand) {
                    GlStateManager.func_179109_b((float)-0.54f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179109_b((float)0.58f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClickInput(MouseEvent event) {
        if (event.getButton() == 0 && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR || event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && ClientProxy.isPlayerMountedOnCamera()) {
            GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.getResolution(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().func_175606_aa().func_180425_c().func_177977_b());
        }
    }
}

