/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="securitycraft", category="options")
@Mod.EventBusSubscriber(modid="securitycraft")
public class ConfigHandler {
    @Config.Name(value="codebreaker_chance")
    @Config.RangeDouble(min=-1.0, max=1.0)
    @Config.Comment(value={"The chance for the codebreaker to successfully hack a block. 0.33 is 33%. Set to a negative value to disable the codebreaker.", "Using the codebreaker when this is set to 0.0 will still damage the item, while negative values do not damage it."})
    public static double codebreakerChance = 0.33;
    @Config.Name(value="Is admin tool allowed?")
    @Config.LangKey(value="config.securitycraft:allowAdminTool")
    public static boolean allowAdminTool = true;
    @Config.Name(value="Mine(s) spawn fire when detonated?")
    @Config.LangKey(value="config.securitycraft:shouldSpawnFire")
    public static boolean shouldSpawnFire = true;
    @Config.Name(value="Are mines breakable?")
    @Config.LangKey(value="config.securitycraft:ableToBreakMines")
    @Config.RequiresMcRestart
    public static boolean ableToBreakMines = true;
    @Config.Name(value="Craftable level 1 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard1")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard1 = true;
    @Config.Name(value="Craftable level 2 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard2")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard2 = true;
    @Config.Name(value="Craftable level 3 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard3")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard3 = true;
    @Config.Name(value="Craftable level 4 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard4")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard4 = true;
    @Config.Name(value="Craftable level 5 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard5")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard5 = true;
    @Config.Name(value="Craftable Limited Use keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftLUKeycard")
    @Config.RequiresMcRestart
    public static boolean ableToCraftLUKeycard = true;
    @Config.Name(value="Mines use a smaller explosion?")
    @Config.LangKey(value="config.securitycraft:smallerMineExplosion")
    public static boolean smallerMineExplosion = false;
    @Config.Name(value="Mines explode when broken in Creative?")
    @Config.LangKey(value="config.securitycraft:mineExplodesWhenInCreative")
    public static boolean mineExplodesWhenInCreative = true;
    @Config.Name(value="Do mines' explosions break blocks?")
    @Config.LangKey(value="config.securitycraft:mineExplosionsBreakBlocks")
    public static boolean mineExplosionsBreakBlocks = true;
    @Config.Name(value="Display a 'tip' message at spawn?")
    @Config.LangKey(value="config.securitycraft:sayThanksMessage")
    public static boolean sayThanksMessage = true;
    @Config.Name(value="Should check for updates on Github?")
    @Config.LangKey(value="config.securitycraft:checkForUpdates")
    public static boolean checkForUpdates = true;
    @Config.Name(value="Laser range:")
    @Config.LangKey(value="config.securitycraft:laserBlockRange")
    public static int laserBlockRange = 5;
    @Config.Name(value="Inventory Scanner range:")
    @Config.LangKey(value="config.securitycraft:inventoryScannerRange")
    public static int inventoryScannerRange = 2;
    @Config.Name(value="Maximum Alarm range:")
    @Config.LangKey(value="config.securitycraft:maxAlarmRange")
    @Config.RangeInt(min=1)
    public static int maxAlarmRange = 100;
    @Config.Name(value="Allow claiming unowned blocks?")
    @Config.LangKey(value="config.securitycraft:allowBlockClaim")
    public static boolean allowBlockClaim = false;
    @Config.Name(value="Darker reinforced block textures?")
    @Config.LangKey(value="config.securitycraft:reinforcedBlockTint")
    public static boolean reinforcedBlockTint = true;
    @Config.Name(value="Craftable mines?")
    @Config.LangKey(value="config.securitycraft:ableToCraftMines")
    public static boolean ableToCraftMines = true;
    @Config.Name(value="Display owner face on retinal scanner?")
    @Config.LangKey(value="config.securitycraft:retinalScannerFace")
    public static boolean retinalScannerFace = true;
    @Config.Name(value="Enable team ownership?")
    @Config.LangKey(value="config.securitycraft:enableTeamOwnership")
    public static boolean enableTeamOwnership = false;
    @Config.Name(value="Trick scanners with player heads?")
    @Config.LangKey(value="config.securitycraft:trickScannersWithPlayerHeads")
    public static boolean trickScannersWithPlayerHeads = false;
    @Config.Name(value="Prevent reinforced floor glitching?")
    @Config.LangKey(value="config.securitycraft:preventReinforcedFloorGlitching")
    public static boolean preventReinforcedFloorGlitching = false;
    @Config.Name(value="Taser damage")
    @Config.LangKey(value="config.securitycraft:taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double taserDamage = 1.0;
    @Config.Name(value="Powered taser damage")
    @Config.LangKey(value="config.securitycraft:powered_taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double poweredTaserDamage = 2.0;
    @Config.Name(value="Reinforced block tint color")
    @Config.RangeInt(min=0, max=0xFFFFFF)
    @Config.Comment(value={"Set the color that reinforced blocks' textures have when reinforced_block_tint is enabled. This cannot be overridden by servers, and will be applied the same to all blocks. Grayscale values look best.", "Format: 0xRRGGBB"})
    public static int reinforcedBlockTintColor = 0x999999;
    @Config.Name(value="Laser damage")
    @Config.RangeDouble(min=0.0)
    @Config.Comment(value={"Defines the damage inflicted to an entity if it passes through a laser with installed harming module. This is given in health points, meaning 2 health points = 1 heart"})
    public static double laserDamage = 10.0;
    @Config.Name(value="Incorrect Passcode Damage")
    @Config.RangeInt(min=1)
    @Config.Comment(value={"Defines the damage that a block requiring a passcode deals to the player, if the player enters an incorrect code. This only works if a harming module is installed.", "Default is two hearts of damage."})
    public static int incorrectPasscodeDamage = 4;
    @Config.Name(value="Sentry Bullet Damage")
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Set the amount of damage the default Sentry bullet inflicts onto the mobs it hits. This will not affect other projectiles the Sentry can use, like arrows.", "Default is one heart."})
    public static int sentryBulletDamage = 2;
    @Config.Name(value="Sentry Attackable Entities Allowlist")
    @Config.Comment(value={"Add entities to this list that the Sentry currently does not attack, but that you want the Sentry to attack. The denylist takes priority over the allowlist."})
    public static String[] sentryAttackableEntitiesAllowlist = new String[0];
    @Config.Name(value="Sentry Attackable Entities Denylist")
    @Config.Comment(value={"Add entities to this list that the Sentry currently attacks, but that you want the Sentry to NOT attack. The denylist takes priority over the allowlist."})
    public static String[] sentryAttackableEntitiesDenylist = new String[0];
    @Config.Name(value="Reinforced Suffocation Damage")
    @Config.Comment(value={"Set the amount of damage the player receives when they are suffocating in a reinforced block. The default is two and a half hearts. If the value is set to -1, vanilla suffocation damage will be used."})
    @Config.RangeInt(min=-1)
    public static int reinforcedSuffocationDamage = 5;
    @Config.Name(value="Allow Camera Night Vision")
    @Config.Comment(value={"Set this to false to disallow players to activate night vision without having the potion effect when looking through cameras."})
    public static boolean allowCameraNightVision = true;
    @Config.Name(value="Passcode Check Cooldown")
    @Config.RangeInt(min=0, max=2000)
    @Config.Comment(value={"Defines the amount of time in milliseconds that needs to pass between two separate attempts from a player to enter a passcode."})
    public static int passcodeCheckCooldown = 250;
    @Config.Name(value="Passcode Spam Log Warning Enabled")
    @Config.Comment(value={"Set this to false to disable the log warning that is sent whenever a player tries to enter a passcode while on passcode cooldown."})
    public static boolean passcodeSpamLogWarningEnabled = true;
    @Config.Name(value="Passcode Spam Log Warning")
    @Config.Comment(value={"The warning that is sent into the server log whenever a player tries to enter a passcode while on passcode cooldown. \"%1$s\" will be replaced with the player's name, \"%2$s\" with the passcode-protected object's name and \"%3$s\" with the object's position and dimension."})
    public static String passcodeSpamLogWarning = "Player \"%1$s\" tried to enter a passcode into \"%2$s\" at position [%3$s] too quickly!";
    @Deprecated
    @Config.Name(value="Taser effects")
    @Config.Comment(value={"Add effects to this list that you want the taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] taserEffectsValue = new String[]{"minecraft:weakness|200|2", "minecraft:nausea|200|2", "minecraft:slowness|200|2"};
    @Deprecated
    @Config.Name(value="Powered taser effects")
    @Config.Comment(value={"Add effects to this list that you want the powered taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] poweredTaserEffectsValue = new String[]{"minecraft:weakness|400|5", "minecraft:nausea|400|5", "minecraft:slowness|400|5"};
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> POWERED_TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();

    private ConfigHandler() {
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("securitycraft".equals(event.getModID())) {
            ConfigHandler.loadEffects();
        }
    }

    public static void loadEffects() {
        ConfigHandler.loadEffects(taserEffectsValue, TASER_EFFECTS);
        ConfigHandler.loadEffects(poweredTaserEffectsValue, POWERED_TASER_EFFECTS);
    }

    private static void loadEffects(String[] effectsValue, List<Supplier<PotionEffect>> effects) {
        effects.clear();
        for (String entry : effectsValue) {
            String[] split = entry.split("\\|");
            if (split.length != 3) {
                SecurityCraft.LOGGER.warn("Not enough information provided for effect \"{}\", skipping", (Object)entry);
                continue;
            }
            int duration = Integer.parseInt(split[1]);
            int amplifier = Integer.parseInt(split[2]);
            if (!ConfigHandler.validateValue(duration, entry) || !ConfigHandler.validateValue(amplifier, entry)) continue;
            ResourceLocation effectLocation = new ResourceLocation(split[0]);
            if (!ForgeRegistries.POTIONS.containsKey(effectLocation)) {
                SecurityCraft.LOGGER.warn("Effect \"{}\" does not exist, skipping", (Object)effectLocation);
                continue;
            }
            effects.add(() -> new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(effectLocation), duration, amplifier - 1));
        }
    }

    private static boolean validateValue(int value, String entry) {
        if (value <= 0) {
            SecurityCraft.LOGGER.warn("Value \"{}\" cannot be less than or equal to zero for entry \"{}\", skipping", (Object)value, (Object)entry);
            return false;
        }
        return true;
    }
}

