/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.additionalstructures.world;

import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import xxrexraptorxx.additionalstructures.config.ConfigGeneral;
import xxrexraptorxx.additionalstructures.config.ConfigStructures;
import xxrexraptorxx.additionalstructures.world.StructureGenerator;
import xxrexraptorxx.additionalstructures.world.StructureList;

public class WorldGenStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76089_r() && world.func_175624_G() != WorldType.field_77138_c) {
            int blockX = chunkX * 16 + random.nextInt(16);
            int blockZ = chunkZ * 16 + random.nextInt(16);
            if (world.field_73011_w.getDimension() == DimensionType.THE_END.func_186068_a()) {
                if (ConfigGeneral.activateEndGeneration) {
                    this.generateEndFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                }
            } else if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
                if (ConfigGeneral.activateNetherGeneration) {
                    this.generateNetherFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
                }
            } else if (ConfigGeneral.additionalDimensions.length > 0) {
                for (int i = 0; i < ConfigGeneral.additionalDimensions.length; ++i) {
                    int dimension = ConfigGeneral.additionalDimensions[i];
                    if (world.field_73011_w.getDimension() != dimension || !ConfigGeneral.activateOverworldGeneration) continue;
                    this.generateOverworldFeatures(world, random, blockX, blockZ);
                }
            }
        }
    }

    protected void generateEndFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.BONE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBones, set);
        this.generateStructure(StructureList.BONE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBones, set);
        this.generateDownsetStructure(StructureList.END_ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.END_ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.END_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndBuildings, set);
        this.generateDownsetStructure(StructureList.END_VILLA, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndBuildings, set);
        this.generateDownsetStructure(StructureList.END_PILLARS, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateDownsetStructure(StructureList.END_TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, set);
        this.generateDownsetStructure(StructureList.END_TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, set);
        this.generateDownsetStructure(StructureList.END_TOWER_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, set);
        this.generateDownsetStructure(StructureList.END_TOWER_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, set);
        this.generateStructure(StructureList.END_WALL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, set);
        this.generateStructure(StructureList.END_WALL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, set);
        this.generateStructure(StructureList.END_WALL_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, set);
        this.generateStructure(StructureList.END_CRYSTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndCrystals, set);
        this.generateStructure(StructureList.FOSSIL_ENDERDRAGON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, set);
        this.generateStructure(StructureList.FOSSIL_ENDERDRAGON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, set);
        this.generateDownsetStructure(StructureList.FOSSIL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, set);
        this.generateDownsetStructure(StructureList.FOSSIL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, set);
        this.generateStructure(StructureList.SKULL_WITHER, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, set);
        this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, set);
        this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, set);
        this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_BROKEN_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, set);
        this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_BROKEN_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, set);
        this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateUndergroundStructure(StructureList.END_DUNGEON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateDownsetStructure(StructureList.END_RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, set);
        this.generateDownsetStructure(StructureList.ENDBRICK_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateDownsetStructure(StructureList.ENDBRICK_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, set);
        this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, set);
        this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, set);
        this.generateBuryStructure(StructureList.END_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTrees, set);
        this.generateBuryStructure(StructureList.END_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTrees, set);
        this.generateBuryStructure(StructureList.SHULKER_CLUSTER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceShulkerClusters, set);
        this.generateBuryStructure(StructureList.SHULKER_CLUSTER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceShulkerClusters, set);
    }

    protected void generateNetherFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
    }

    protected void generateOverworldFeatures(World world, Random random, int blockX, int blockZ) {
        this.generateDesertFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        this.generateSnowFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
        this.generateJungleFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        this.generateSwampFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        this.generateForestFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        this.generatePlainsFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        this.generateMountainFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        this.generateMesaFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
        this.generateOceanFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        this.generateSavannaFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        this.generateWastelandFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
        this.generateSpookyFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
    }

    protected void generateDesertFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.BIG_CACTUS, world, random, blockX, blockZ, ConfigStructures.spawnchanceBiggerCacti, set);
        this.generateStructure(StructureList.HUGE_CACTUS, world, random, blockX, blockZ, ConfigStructures.spawnchanceBiggerCacti, set);
        this.generateStructure(StructureList.SMALL_PYRAMIDE, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramides, set);
        this.generateStructure(StructureList.PYRAMIDE_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceTemple, set);
        this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.SAND_ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.SAND_ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.SAND_ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateDownsetStructure(StructureList.DESERT_PILLARS_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDesertPillars, set);
        this.generateDownsetStructure(StructureList.DESERT_PILLARS_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDesertPillars, set);
        this.generateDownsetStructure(StructureList.SAND_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, set);
        this.generateStructure(StructureList.SAND_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, set);
        this.generateDownsetStructure(StructureList.SAND_TOTEM_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, set);
        this.generateBuryStructure(StructureList.OASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceOasis, set);
        this.generateDownsetStructure(StructureList.OASE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceOasis, set);
        this.generateStructure(StructureList.PALM_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, set);
        this.generateStructure(StructureList.PALM_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, set);
        this.generateStructure(StructureList.PALM_1, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, set);
        this.generateStructure(StructureList.PALM_2, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, set);
        this.generateUndergroundStructure(StructureList.DESERT_TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateBuryStructure(StructureList.PYRAMIDE_DUNGEON, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramideDungeon, set);
        this.generateDownsetStructure(StructureList.SPHINX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSphinx, set);
        this.generateDownsetStructure(StructureList.PYRAMIDE_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramides, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_PALM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_PALM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateUndergroundStructure(StructureList.SARCOPHAGUS_ROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
    }

    protected void generateSnowFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.SNOWMAN, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowmen, set);
        this.generateStructure(StructureList.SNOWMAN_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowmen, set);
        this.generateStructure(StructureList.DEAD_SPRUCE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SPRUCE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.FALLEN_SPRUCE_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_SPRUCE_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.SNOW_PILE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, set);
        this.generateStructure(StructureList.SNOW_PILE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, set);
        this.generateStructure(StructureList.SNOW_PILE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, set);
    }

    protected void generateSwampFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.WITCH_BREWING_STAND, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, set);
        this.generateStructure(StructureList.ILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceIllagerHouses, set);
        this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.OAK_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateBuryStructure(StructureList.HORCRUX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpecials, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
    }

    protected void generateJungleFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.TREE_HOLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.DEAD_JUNGLE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.JUNGLE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.BIG_JUNGLE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.FALLEN_JUNGLE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateBuryStructure(StructureList.MAYA_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceMayaTemple, set);
        this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.JUNGLE_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceTemple, set);
        this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms, set);
        this.generateStructure(StructureList.STONE_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
    }

    protected void generateForestFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.OAK_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SPRUCE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SPRUCE_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.LOG_BUNDLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogBundle, set);
        this.generateStructure(StructureList.DEAD_OAK_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.BUSH_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, set);
        this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_COBBLE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_COBBLE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_COBBLE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.FALLEN_OAK_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_OAK_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateBuryStructure(StructureList.GRAVE, world, random, blockX, blockZ, ConfigStructures.spawnchanceGrave, set);
        this.generateStructure(StructureList.ILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceIllagerHouses, set);
        this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateStructure(StructureList.VILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, set);
        this.generateStructure(StructureList.VILLAGER_HOUSE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, set);
        this.generateBuryStructure(StructureList.WELL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, set);
        this.generateBuryStructure(StructureList.WELL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, set);
        this.generateStructure(StructureList.VILLAGER_HOUSE_BROCKEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses + 500, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateStructure(StructureList.RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, set);
        this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateBuryStructure(StructureList.CHEST_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTraps, set);
        this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
    }

    protected void generatePlainsFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateDownsetStructure(StructureList.CAMP, world, random, blockX, blockZ, ConfigStructures.spawnchanceCamps, set);
        this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, set);
        this.generateStructure(StructureList.BUSH_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.BUSH_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, set);
        this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, set);
        this.generateBuryStructure(StructureList.GRAVE, world, random, blockX, blockZ, ConfigStructures.spawnchanceGrave, set);
        this.generateBuryStructure(StructureList.MINE_ENTRY, world, random, blockX, blockZ, ConfigStructures.spawnchanceMineEntry, set);
        this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.STONE_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateStructure(StructureList.VILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, set);
        this.generateStructure(StructureList.VILLAGER_HOUSE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, set);
        this.generateBuryStructure(StructureList.WALL_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, set);
        this.generateStructure(StructureList.WALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, set);
        this.generateStructure(StructureList.WHEAT_BALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceWheatBalls, set);
        this.generateBuryStructure(StructureList.WELL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, set);
        this.generateBuryStructure(StructureList.WELL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, set);
        this.generateDownsetStructure(StructureList.FARM, world, random, blockX, blockZ, ConfigStructures.spawnchanceFarm, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateStructure(StructureList.RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, set);
        this.generateBuryStructure(StructureList.STONE_CIRCLE_RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, set);
        this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms + 5000, set);
    }

    protected void generateMountainFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.ROCK_COBBLE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_COBBLE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.ROCK_COBBLE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, set);
        this.generateStructure(StructureList.STONE_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateBuryStructure(StructureList.LAVA_FOUNTAIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceLavaFountain, set);
        this.generateBuryStructure(StructureList.METEOR, world, random, blockX, blockZ, ConfigStructures.spawnchanceMeteor, set);
        this.generateBuryStructure(StructureList.MINE_ENTRY, world, random, blockX, blockZ, ConfigStructures.spawnchanceMineEntry, set);
        this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateBuryStructure(StructureList.FLAG, world, random, blockX, blockZ, ConfigStructures.spawnchanceOthers + 1500, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.SPIDER_NEST_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, set);
        this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, set);
    }

    protected void generateMesaFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateBuryStructure(StructureList.LAVA_FOUNTAIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceLavaFountain, set);
        this.generateStructure(StructureList.SAND_TOTEM_RED, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, set);
        this.generateDownsetStructure(StructureList.SAND_TOTEM_RED_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, set);
        this.generateStructure(StructureList.STONE_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
        this.generateStructure(StructureList.STONE_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, set);
    }

    protected void generateOceanFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateDownsetStructure(StructureList.BOAT, world, random, blockX, blockZ, ConfigStructures.spawnchanceBoats, set);
        this.generateDownsetStructure(StructureList.RAFT, world, random, blockX, blockZ, ConfigStructures.spawnchanceBoats, set);
        this.generateDownsetStructure(StructureList.OAK_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, set);
        this.generateDownsetStructure(StructureList.FLOTSAM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, set);
        this.generateDownsetStructure(StructureList.FLOTSAM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, set);
        this.generateDownsetStructure(StructureList.FLOTSAM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, set);
    }

    protected void generateSavannaFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
    }

    protected void generateWastelandFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, set);
        this.generateBuryStructure(StructureList.HORCRUX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpecials, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, set);
        this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, set);
        this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, set);
        this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
    }

    protected void generateSpookyFeatures(World world, Random random, int blockX, int blockZ, Set<Biome> set) {
        this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, set);
        this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, set);
        this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, set);
        this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
        this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, set);
    }

    private boolean generationChanceRoll(Random random, int chance) {
        if (chance <= 0) {
            return false;
        }
        return random.nextInt(Math.max((int)(ConfigStructures.generationModifier * (float)chance), 1)) == 0;
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        boolean rollPassed = this.generationChanceRoll(random, chance);
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY + 1, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if ((set == null || set.contains(biome)) && rollPassed) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateDownsetStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        boolean rollPassed = this.generationChanceRoll(random, chance);
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if ((set == null || set.contains(biome)) && rollPassed) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateBuryStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        boolean rollPassed = this.generationChanceRoll(random, chance);
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY - 2, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if ((set == null || set.contains(biome)) && rollPassed) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateUndergroundStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        boolean rollPassed = this.generationChanceRoll(random, chance);
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, (int)(Math.random() * (double)(blockY - 20 - 25 + 1)) + 25, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if ((set == null || set.contains(biome)) && rollPassed) {
            generator.func_180709_b(world, random, pos);
        }
    }
}

