/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettermineshafts.util.BlockSetSelector;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariants;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;

public abstract class MineshaftPiece
extends StructureComponent {
    protected MineshaftVariantSettings settings;
    protected int pieceChainLen;
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final Set<Material> LIQUIDS = ImmutableSet.of((Object)Material.field_151587_i, (Object)Material.field_151586_h);

    public MineshaftPiece() {
    }

    public MineshaftPiece(int i, int pieceChainLen, MineshaftVariantSettings settings) {
        super(i);
        this.settings = settings;
        this.pieceChainLen = pieceChainLen;
    }

    protected void func_143012_a(NBTTagCompound tag) {
        int index = MineshaftVariants.get().getVariants().indexOf(this.settings);
        tag.func_74768_a("MST", index);
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        int index = tagCompound.func_74762_e("MST");
        this.settings = index < MineshaftVariants.get().getVariants().size() && index >= 0 ? MineshaftVariants.get().getVariants().get(index) : MineshaftVariants.get().getDefault();
    }

    public void setBoundingBox(StructureBoundingBox boundingBox) {
        this.field_74887_e = boundingBox;
    }

    public MineshaftVariantSettings getSettings() {
        return this.settings;
    }

    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        return this.settings.mainSelector;
    }

    protected BlockSetSelector getFloorSelector() {
        return this.settings.floorSelector;
    }

    protected BlockSetSelector getBrickSelector() {
        return this.settings.brickSelector;
    }

    protected BlockSetSelector getLegSelector() {
        return this.settings.legSelector;
    }

    protected IBlockState getMainBlock() {
        return this.settings.mainBlock;
    }

    protected IBlockState getSupportBlock() {
        return this.settings.supportBlock;
    }

    protected IBlockState getMainSlab() {
        return this.settings.slabBlock;
    }

    protected IBlockState getGravel() {
        return this.settings.gravelBlock;
    }

    protected IBlockState getMainDoorwayWall() {
        return this.settings.stoneWallBlock;
    }

    protected IBlockState getMainDoorwaySlab() {
        return this.settings.stoneSlabBlock;
    }

    protected IBlockState getTrapdoor() {
        return Blocks.field_150415_aT.func_176223_P();
    }

    protected void addVines(World world, StructureBoundingBox boundingBox, EnumFacing facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    EnumFacing dir;
                    mutable.func_181079_c(x, y, z);
                    EnumFacing enumFacing = dir = facing.func_176740_k() == EnumFacing.Axis.X ? facing : facing.func_176734_d();
                    if (this.func_175807_a(world, x, y, z, boundingBox).func_177230_c() != Blocks.field_150350_a || this.func_175807_a(world, x + facing.func_82601_c(), y, z + facing.func_82599_e(), boundingBox).func_193401_d((IBlockAccess)world, new BlockPos(x + dir.func_82599_e(), y, z + dir.func_82599_e()), dir.func_176734_d()) != BlockFaceShape.SOLID || !(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(dir == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(dir == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(dir == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(dir == EnumFacing.WEST)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(World world, StructureBoundingBox boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.settings.vineChance <= 0.0f) {
            return;
        }
        this.addVines(world, boundingBox, EnumFacing.EAST, random, this.settings.vineChance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, EnumFacing.WEST, random, this.settings.vineChance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, EnumFacing.NORTH, random, this.settings.vineChance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, EnumFacing.SOUTH, random, this.settings.vineChance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(World world, StructureBoundingBox box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                    IBlockState state = this.func_175807_a(world, x, y, z, box);
                    IBlockState stateBelow = this.func_175807_a(world, x, y - 1, z, box);
                    Block blockBelow = stateBelow.func_177230_c();
                    if (this.settings.snowChance > 0.0f && random.nextFloat() < this.settings.snowChance && state == AIR && blockBelow != Blocks.field_150432_aD && blockBelow != Blocks.field_150403_cj && blockBelow != Blocks.field_180401_cv && stateBelow.isSideSolid((IBlockAccess)world, blockPos.func_177977_b(), EnumFacing.UP)) {
                        this.func_175811_a(world, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if (this.settings.cactusChance > 0.0f && random.nextFloat() < this.settings.cactusChance && state == AIR && blockBelow == Blocks.field_150354_m) {
                        this.func_175811_a(world, Blocks.field_150434_aF.func_176223_P().func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.func_175807_a(world, x, y + 1, z, box) == AIR) {
                            this.func_175811_a(world, Blocks.field_150434_aF.func_176223_P().func_177226_a((IProperty)BlockCactus.field_176587_a, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (this.settings.deadBushChance > 0.0f && random.nextFloat() < this.settings.deadBushChance && state == AIR && (blockBelow == Blocks.field_150354_m || blockBelow == Blocks.field_150406_ce || blockBelow == Blocks.field_150405_ch || blockBelow == Blocks.field_150346_d)) {
                        this.func_175811_a(world, Blocks.field_150330_I.func_176223_P(), x, y, z, box);
                    }
                    if (!(this.settings.mushroomChance > 0.0f) || state != AIR || blockBelow != Blocks.field_150391_bh && blockBelow != Blocks.field_150346_d) continue;
                    float r = random.nextFloat();
                    if (r < this.settings.mushroomChance / 2.0f) {
                        this.func_175811_a(world, Blocks.field_150337_Q.func_176223_P(), x, y, z, box);
                        continue;
                    }
                    if (!(r < this.settings.mushroomChance)) continue;
                    this.func_175811_a(world, Blocks.field_150338_P.func_176223_P(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(World world, Random random, StructureBoundingBox box, int x, int z, BlockSetSelector selector) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, -1, z);
        IBlockState state = this.getBlockStateFromPos(world, (BlockPos)mutable, box);
        while (this.func_74862_a(mutable.func_177956_o()) > 0 && (state == AIR || LIQUIDS.contains(state.func_185904_a()))) {
            this.func_175811_a(world, selector.get(random), x, mutable.func_177956_o(), z, box);
            mutable.func_189536_c(EnumFacing.DOWN);
            state = this.getBlockStateFromPos(world, (BlockPos)mutable, box);
        }
    }

    protected void fill(World world, StructureBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void fill(World world, StructureBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(World world, StructureBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox);
                    if (currState == null || currState != AIR) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(World world, StructureBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox);
                    if (currState == null || currState != AIR) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(World world, StructureBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox);
                    if (currState == null || currState == AIR) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(World world, StructureBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox);
                    if (currState == null || currState == AIR) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox)) == null || currState != AIR) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox)) == null || currState != AIR) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox)) == null || currState == AIR) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(World world, StructureBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed(world, x, y, z, blockBox)) == null || currState == AIR) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceAddBlock(World world, Random random, float chance, IBlockState block, int x, int y, int z, StructureBoundingBox blockBox) {
        if (random.nextFloat() < chance) {
            this.func_175811_a(world, block, x, y, z, blockBox);
        }
    }

    protected IBlockState getBlockStateFromPosFixed(World world, int x, int y, int z, StructureBoundingBox blockBox) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockPos = new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z));
        return !blockBox.func_175898_b((Vec3i)blockPos) ? null : world.func_180495_p(blockPos);
    }

    protected IBlockState getBlockStateFromPos(World worldIn, BlockPos pos, StructureBoundingBox boundingboxIn) {
        return super.func_175807_a(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), boundingboxIn);
    }

    protected boolean isInOcean(World world, int localX, int localZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_74865_a(localX, localZ), 1, this.func_74873_b(localX, localZ));
        return BiomeDictionary.hasType((Biome)world.func_180494_b((BlockPos)pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
    }
}

