/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.integration;

import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.integration.CompatModule;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noppes.vc.VCBlocks;
import noppes.vc.blocks.tiles.TileCandle;
import noppes.vc.blocks.tiles.TileLamp;

public class VariedCommoditiesModule
extends CompatModule {
    public VariedCommoditiesModule() {
        super("variedcommodities");
    }

    @Override
    public void enable() {
        super.enable();
        if (VCBlocks.lamp != null) {
            this.addIfAbsent(this.lanterns, VCBlocks.lamp.func_176223_P());
        }
        if (VCBlocks.candle != null) {
            this.addIfAbsent(this.lanterns, VCBlocks.candle.func_176223_P());
            this.addIfAbsent(this.leftTorches, VCBlocks.candle.func_176223_P());
            this.addIfAbsent(this.rightTorches, VCBlocks.candle.func_176223_P());
        }
    }

    @Override
    public boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && Configuration.modCompat.variedcommoditiesCandlesEnabled;
    }

    public boolean isTorchVariedCommoditiesCandle(IBlockState torchBlock) {
        return this.isEnabled() && torchBlock == VCBlocks.candle.func_176223_P();
    }

    public boolean isLanternVariedCommoditiesCandle(IBlockState lanternBlock) {
        return this.isEnabled() && lanternBlock == VCBlocks.candle.func_176223_P();
    }

    public boolean isLanternVariedCommoditiesLamp(IBlockState lanternBlock) {
        return this.isEnabled() && lanternBlock == VCBlocks.lamp.func_176223_P();
    }

    public void spawnCandleTorchEntity(World world, int x, int y, int z, int rotation) {
        this.spawnCandleEntity(world, x, y, z, rotation, 2);
    }

    public void spawnCandleLanternEntity(World world, int x, int y, int z) {
        int rotation = x % 2 == 0 ? 6 : 3;
        this.spawnCandleEntity(world, x, y, z, rotation, 1);
    }

    public void spawnLampLanternEntity(World world, int x, int y, int z) {
        int rotation = x % 2 == 0 ? 5 : 2;
        TileEntity lampEntity = this.tryToGetEntity(world, x, y, z);
        if (lampEntity instanceof TileLamp) {
            ((TileLamp)lampEntity).rotation = rotation;
            ((TileLamp)lampEntity).color = 1;
        }
    }

    private void spawnCandleEntity(World world, int x, int y, int z, int rotation, int color) {
        TileEntity candleEntity = this.tryToGetEntity(world, x, y, z);
        if (candleEntity instanceof TileCandle) {
            ((TileCandle)candleEntity).rotation = rotation;
            ((TileCandle)candleEntity).color = color;
        }
    }

    private TileEntity tryToGetEntity(World world, int x, int y, int z) {
        TileEntity candleEntity = world.func_175625_s(new BlockPos((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
        if (candleEntity == null) {
            candleEntity = world.func_175625_s(new BlockPos((double)x - 0.5, (double)y + 0.5, (double)z - 0.5));
        }
        if (candleEntity == null) {
            candleEntity = world.func_175625_s(new BlockPos((double)x + 0.5, (double)y + 0.5, (double)z - 0.5));
        }
        if (candleEntity == null) {
            candleEntity = world.func_175625_s(new BlockPos((double)x - 0.5, (double)y + 0.5, (double)z + 0.5));
        }
        if (candleEntity == null) {
            candleEntity = world.func_175625_s(new BlockPos((double)x, (double)y + 0.5, (double)z));
        }
        return candleEntity;
    }
}

