/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity;

import com.mrcrayfish.device.tileentity.TileEntitySync;
import com.mrcrayfish.device.util.IColored;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.StringUtils;

public abstract class TileEntityDevice
extends TileEntitySync
implements ITickable {
    private EnumDyeColor color = EnumDyeColor.RED;
    private UUID deviceId;
    private String name;

    public final UUID getId() {
        if (this.deviceId == null) {
            this.deviceId = UUID.randomUUID();
        }
        return this.deviceId;
    }

    public abstract String getDeviceName();

    public String getCustomName() {
        return this.hasCustomName() ? this.name : this.getDeviceName();
    }

    public void setCustomName(String name) {
        this.name = name;
    }

    public boolean hasCustomName() {
        return !StringUtils.isEmpty((CharSequence)this.name);
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getCustomName());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("deviceId", this.getId().toString());
        if (this.hasCustomName()) {
            compound.func_74778_a("name", this.name);
        }
        compound.func_74774_a("color", (byte)this.color.func_176765_a());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("deviceId", 8)) {
            this.deviceId = UUID.fromString(compound.func_74779_i("deviceId"));
        }
        if (compound.func_150297_b("name", 8)) {
            this.name = compound.func_74779_i("name");
        }
        if (compound.func_150297_b("color", 1)) {
            this.color = EnumDyeColor.func_176764_b((int)compound.func_74771_c("color"));
        }
    }

    @Override
    public NBTTagCompound writeSyncTag() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.hasCustomName()) {
            tag.func_74778_a("name", this.name);
        }
        tag.func_74774_a("color", (byte)this.color.func_176765_a());
        return tag;
    }

    public static abstract class Colored
    extends TileEntityDevice
    implements IColored {
        private EnumDyeColor color = EnumDyeColor.RED;

        @Override
        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            if (compound.func_150297_b("color", 1)) {
                this.color = EnumDyeColor.func_176764_b((int)compound.func_74771_c("color"));
            }
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            compound.func_74774_a("color", (byte)this.color.func_176765_a());
            return compound;
        }

        @Override
        public NBTTagCompound writeSyncTag() {
            NBTTagCompound tag = super.writeSyncTag();
            tag.func_74774_a("color", (byte)this.color.func_176765_a());
            return tag;
        }

        @Override
        public final void setColor(EnumDyeColor color) {
            this.color = color;
        }

        @Override
        public final EnumDyeColor getColor() {
            return this.color;
        }
    }
}

