/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.proxy;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.init.DeviceBlocks;
import com.mrcrayfish.device.network.PacketHandler;
import com.mrcrayfish.device.network.task.MessageSyncApplications;
import com.mrcrayfish.device.network.task.MessageSyncConfig;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.system.SystemApplication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonProxy {
    List<AppInfo> allowedApps;
    int hashCode = -1;

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
    }

    public void postInit() {
    }

    @Nullable
    public Application registerApplication(ResourceLocation identifier, Class<? extends Application> clazz) {
        if (this.allowedApps == null) {
            this.allowedApps = new ArrayList<AppInfo>();
        }
        if (SystemApplication.class.isAssignableFrom(clazz)) {
            this.allowedApps.add(new AppInfo(identifier, true));
        } else {
            this.allowedApps.add(new AppInfo(identifier, false));
        }
        return null;
    }

    public boolean registerPrint(ResourceLocation identifier, Class<? extends IPrint> classPrint) {
        return true;
    }

    public boolean hasAllowedApplications() {
        return this.allowedApps != null;
    }

    public List<AppInfo> getAllowedApplications() {
        if (this.allowedApps == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.allowedApps);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.allowedApps != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncApplications(this.allowedApps), (EntityPlayerMP)event.player);
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncConfig(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() == Items.field_151121_aF && world.func_180495_p(event.getPos()).func_177230_c() == DeviceBlocks.PRINTER) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public void showNotification(NBTTagCompound tag) {
    }
}

