/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.proxy;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.api.print.PrintingManager;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.client.ClientNotification;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.proxy.CommonProxy;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import com.mrcrayfish.device.tileentity.TileEntityOfficeChair;
import com.mrcrayfish.device.tileentity.TileEntityPaper;
import com.mrcrayfish.device.tileentity.TileEntityPrinter;
import com.mrcrayfish.device.tileentity.TileEntityRouter;
import com.mrcrayfish.device.tileentity.render.LaptopRenderer;
import com.mrcrayfish.device.tileentity.render.OfficeChairRenderer;
import com.mrcrayfish.device.tileentity.render.PaperRenderer;
import com.mrcrayfish.device.tileentity.render.PrinterRenderer;
import com.mrcrayfish.device.tileentity.render.RouterRenderer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientProxy
extends CommonProxy
implements IResourceManagerReloadListener {
    @Override
    public void preInit() {
        super.preInit();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaptop.class, (TileEntitySpecialRenderer)new LaptopRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPrinter.class, (TileEntitySpecialRenderer)new PrinterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPaper.class, (TileEntitySpecialRenderer)new PaperRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRouter.class, (TileEntitySpecialRenderer)new RouterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityOfficeChair.class, (TileEntitySpecialRenderer)new OfficeChairRenderer());
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_1.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_2.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_3.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_4.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_5.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_6.png"));
        Laptop.addWallpaper(new ResourceLocation("cdm:textures/gui/laptop_wallpaper_7.png"));
    }

    @Override
    public void postInit() {
        this.generateIconAtlas();
    }

    private void generateIconAtlas() {
        int ICON_SIZE = 14;
        int index = 0;
        BufferedImage atlas = new BufferedImage(224, 224, 2);
        Graphics2D g = atlas.createGraphics();
        try {
            BufferedImage icon = TextureUtil.func_177053_a((InputStream)ClientProxy.class.getResourceAsStream("/assets/cdm/textures/app/icon/missing.png"));
            g.drawImage(icon, 0, 0, 14, 14, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++index;
        for (AppInfo info : ApplicationManager.getAllApplications()) {
            if (info.getIcon() == null) continue;
            ResourceLocation identifier = info.getId();
            ResourceLocation iconResource = new ResourceLocation(info.getIcon());
            String path = "/assets/" + iconResource.func_110624_b() + "/" + iconResource.func_110623_a();
            try {
                InputStream input = ClientProxy.class.getResourceAsStream(path);
                if (input != null) {
                    BufferedImage icon = TextureUtil.func_177053_a((InputStream)input);
                    if (icon.getWidth() != 14 || icon.getHeight() != 14) {
                        MrCrayfishDeviceMod.getLogger().error("Incorrect icon size for " + identifier.toString() + " (Must be 14 by 14 pixels)");
                        continue;
                    }
                    int iconU = index % 16 * 14;
                    int iconV = index / 16 * 14;
                    g.drawImage(icon, iconU, iconV, 14, 14, null);
                    this.updateIcon(info, iconU, iconV);
                    ++index;
                    continue;
                }
                MrCrayfishDeviceMod.getLogger().error("Icon for application '" + identifier.toString() + "' could not be found at '" + path + "'");
            }
            catch (Exception e) {
                MrCrayfishDeviceMod.getLogger().error("Unable to load icon for " + identifier.toString());
            }
        }
        g.dispose();
        Minecraft.func_71410_x().func_110434_K().func_110579_a(Laptop.ICON_TEXTURES, (ITextureObject)new DynamicTexture(atlas));
    }

    private void updateIcon(AppInfo info, int iconU, int iconV) {
        ReflectionHelper.setPrivateValue(AppInfo.class, (Object)info, (Object)iconU, (String[])new String[]{"iconU"});
        ReflectionHelper.setPrivateValue(AppInfo.class, (Object)info, (Object)iconV, (String[])new String[]{"iconV"});
    }

    @Override
    @Nullable
    public Application registerApplication(ResourceLocation identifier, Class<? extends Application> clazz) {
        if ("minecraft".equals(identifier.func_110624_b())) {
            throw new IllegalArgumentException("Invalid identifier domain");
        }
        try {
            Application application = clazz.newInstance();
            List APPS = (List)ReflectionHelper.getPrivateValue(Laptop.class, null, (String[])new String[]{"APPLICATIONS"});
            APPS.add(application);
            Field field = Application.class.getDeclaredField("info");
            field.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(application, this.generateAppInfo(identifier, clazz));
            return application;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private AppInfo generateAppInfo(ResourceLocation identifier, Class<? extends Application> clazz) {
        AppInfo info = new AppInfo(identifier, SystemApplication.class.isAssignableFrom(clazz));
        info.reload();
        return info;
    }

    @Override
    public boolean registerPrint(ResourceLocation identifier, Class<? extends IPrint> classPrint) {
        try {
            Constructor<? extends IPrint> constructor = classPrint.getConstructor(new Class[0]);
            IPrint print = constructor.newInstance(new Object[0]);
            Class<? extends IPrint.Renderer> classRenderer = print.getRenderer();
            try {
                IPrint.Renderer renderer = classRenderer.newInstance();
                HashMap<String, IPrint.Renderer> idToRenderer = (HashMap<String, IPrint.Renderer>)ReflectionHelper.getPrivateValue(PrintingManager.class, null, (String[])new String[]{"registeredRenders"});
                if (idToRenderer == null) {
                    idToRenderer = new HashMap<String, IPrint.Renderer>();
                    ReflectionHelper.setPrivateValue(PrintingManager.class, null, idToRenderer, (String[])new String[]{"registeredRenders"});
                }
                idToRenderer.put(identifier.toString(), renderer);
            }
            catch (InstantiationException e) {
                MrCrayfishDeviceMod.getLogger().error("The print renderer '" + classRenderer.getName() + "' is missing an empty constructor and could not be registered!");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            MrCrayfishDeviceMod.getLogger().error("The print '" + classPrint.getName() + "' is missing an empty constructor and could not be registered!");
            return false;
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        if (ApplicationManager.getAllApplications().size() > 0) {
            ApplicationManager.getAllApplications().forEach(AppInfo::reload);
            this.generateIconAtlas();
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.allowedApps = null;
        DeviceConfig.restore();
    }

    @Override
    public void showNotification(NBTTagCompound tag) {
        ClientNotification notification = ClientNotification.loadFromTag(tag);
        notification.push();
    }
}

