/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.email.object;

import com.mrcrayfish.device.api.io.File;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Email {
    private String subject;
    private String author;
    private String message;
    private File attachment;
    private boolean read;

    public Email(String subject, String message, @Nullable File file) {
        this.subject = subject;
        this.message = message;
        this.attachment = file;
        this.read = false;
    }

    public Email(String subject, String author, String message, @Nullable File attachment) {
        this(subject, message, attachment);
        this.author = author;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public File getAttachment() {
        return this.attachment;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("subject", this.subject);
        if (this.author != null) {
            nbt.func_74778_a("author", this.author);
        }
        nbt.func_74778_a("message", this.message);
        nbt.func_74757_a("read", this.read);
        if (this.attachment != null) {
            NBTTagCompound fileTag = new NBTTagCompound();
            fileTag.func_74778_a("file_name", this.attachment.getName());
            fileTag.func_74782_a("data", (NBTBase)this.attachment.toTag());
            nbt.func_74782_a("attachment", (NBTBase)fileTag);
        }
    }

    public static Email readFromNBT(NBTTagCompound nbt) {
        File attachment = null;
        if (nbt.func_150297_b("attachment", 10)) {
            NBTTagCompound fileTag = nbt.func_74775_l("attachment");
            attachment = File.fromTag(fileTag.func_74779_i("file_name"), fileTag.func_74775_l("data"));
        }
        Email email = new Email(nbt.func_74779_i("subject"), nbt.func_74779_i("author"), nbt.func_74779_i("message"), attachment);
        email.setRead(nbt.func_74767_n("read"));
        return email;
    }
}

