/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.network.task;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.proxy.CommonProxy;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MessageSyncApplications
implements IMessage,
IMessageHandler<MessageSyncApplications, MessageSyncApplications> {
    private List<AppInfo> allowedApps;

    public MessageSyncApplications() {
    }

    public MessageSyncApplications(List<AppInfo> allowedApps) {
        this.allowedApps = allowedApps;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.allowedApps.size());
        for (AppInfo appInfo : this.allowedApps) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)appInfo.getId().toString());
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < size; ++i) {
            String appId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            AppInfo info = ApplicationManager.getApplication(appId);
            if (info != null) {
                builder.add((Object)info);
                continue;
            }
            MrCrayfishDeviceMod.getLogger().error("Missing application '" + appId + "'");
        }
        this.allowedApps = builder.build();
    }

    public MessageSyncApplications onMessage(MessageSyncApplications message, MessageContext ctx) {
        ReflectionHelper.setPrivateValue(CommonProxy.class, (Object)MrCrayfishDeviceMod.proxy, message.allowedApps, (String[])new String[]{"allowedApps"});
        return null;
    }
}

