/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core;

import com.mrcrayfish.device.tileentity.TileEntityDevice;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Device {
    protected UUID id;
    protected String name;
    protected BlockPos pos;

    protected Device() {
    }

    public Device(TileEntityDevice device) {
        this.id = device.getId();
        this.update(device);
    }

    public Device(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void update(TileEntityDevice device) {
        this.name = device.getCustomName();
        this.pos = device.func_174877_v();
    }

    @Nullable
    public TileEntityDevice getDevice(World world) {
        TileEntityDevice tileEntityDevice;
        if (this.pos == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.pos);
        if (tileEntity instanceof TileEntityDevice && (tileEntityDevice = (TileEntityDevice)tileEntity).getId().equals(this.getId())) {
            return tileEntityDevice;
        }
        return null;
    }

    public NBTTagCompound toTag(boolean includePos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.id.toString());
        tag.func_74778_a("name", this.name);
        if (includePos && this.pos != null) {
            tag.func_74772_a("pos", this.pos.func_177986_g());
        }
        return tag;
    }

    public static Device fromTag(NBTTagCompound tag) {
        Device device = new Device();
        device.id = UUID.fromString(tag.func_74779_i("id"));
        device.name = tag.func_74779_i("name");
        if (tag.func_150297_b("pos", 4)) {
            device.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        }
        return device;
    }
}

