/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.print;

import com.google.common.collect.HashBiMap;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.print.IPrint;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PrintingManager {
    private static HashBiMap<String, Class<? extends IPrint>> registeredPrints = HashBiMap.create();
    @SideOnly(value=Side.CLIENT)
    private static Map<String, IPrint.Renderer> registeredRenders;

    public static void registerPrint(ResourceLocation identifier, Class<? extends IPrint> classPrint) {
        try {
            classPrint.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (MrCrayfishDeviceMod.proxy.registerPrint(identifier, classPrint)) {
                MrCrayfishDeviceMod.getLogger().info("Registering print '" + classPrint.getName() + "'");
                registeredPrints.put((Object)identifier.toString(), classPrint);
            } else {
                MrCrayfishDeviceMod.getLogger().error("The print '" + classPrint.getName() + "' could not be registered due to a critical error!");
            }
        }
        catch (NoSuchMethodException e) {
            MrCrayfishDeviceMod.getLogger().error("The print '" + classPrint.getName() + "' is missing an empty constructor and could not be registered!");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            MrCrayfishDeviceMod.getLogger().error("The print '" + classPrint.getName() + "' could not be registered due to a critical error!");
        }
    }

    public static boolean isRegisteredPrint(Class<? extends IPrint> clazz) {
        return registeredPrints.containsValue(clazz);
    }

    @Nullable
    public static IPrint getPrint(String identifier) {
        Class clazz = (Class)registeredPrints.get((Object)identifier);
        if (clazz != null) {
            try {
                return (IPrint)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static IPrint.Renderer getRenderer(IPrint print) {
        String id = PrintingManager.getPrintIdentifier(print);
        return registeredRenders.get(id);
    }

    @SideOnly(value=Side.CLIENT)
    public static IPrint.Renderer getRenderer(String identifier) {
        return registeredRenders.get(identifier);
    }

    public static String getPrintIdentifier(IPrint print) {
        return (String)registeredPrints.inverse().get(print.getClass());
    }
}

