/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app.component;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.IIcon;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Spinner;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Image
extends Component {
    public static final Map<String, CachedImage> CACHE = new HashMap<String, CachedImage>();
    private Spinner spinner;
    protected ImageLoader loader;
    protected CachedImage image;
    protected boolean initialized = false;
    protected boolean drawFull = false;
    protected int imageU;
    protected int imageV;
    protected int imageWidth;
    protected int imageHeight;
    protected int sourceWidth;
    protected int sourceHeight;
    protected int componentWidth;
    protected int componentHeight;
    private float alpha = 1.0f;
    private boolean hasBorder = false;
    private int borderColor = Color.BLACK.getRGB();
    private int borderThickness = 1;

    public Image(int left, int top, int width, int height) {
        super(left, top);
        this.componentWidth = width;
        this.componentHeight = height;
    }

    public Image(int left, int top, int imageU, int imageV, int imageWidth, int imageHeight, ResourceLocation resource) {
        this(left, top, imageWidth, imageHeight, imageU, imageV, imageWidth, imageHeight, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, ResourceLocation resource) {
        this(left, top, componentWidth, componentHeight, imageU, imageV, imageWidth, imageHeight, 256, 256, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, int sourceWidth, int sourceHeight, ResourceLocation resource) {
        super(left, top);
        this.loader = new StandardLoader(resource);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = imageU;
        this.imageV = imageV;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
    }

    public Image(int left, int top, int componentWidth, int componentHeight, String url) {
        super(left, top);
        this.loader = new DynamicLoader(url);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.drawFull = true;
    }

    public Image(int left, int top, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = icon.getIconSize();
        this.componentHeight = icon.getIconSize();
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    public Image(int left, int top, int componentWidth, int componentHeight, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    @Override
    public void init(Layout layout) {
        this.spinner = new Spinner(this.left + this.componentWidth / 2 - 6, this.top + this.componentHeight / 2 - 6);
        layout.addComponent(this.spinner);
        this.initialized = true;
    }

    @Override
    public void handleLoad() {
        this.reload();
    }

    @Override
    protected void handleUnload() {
        this.initialized = false;
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            if (this.loader != null && this.loader.setup) {
                this.image = this.loader.load(this);
                this.spinner.setVisible(false);
                this.loader.setup = false;
            }
            if (this.hasBorder) {
                Image.func_73734_a((int)x, (int)y, (int)(x + this.componentWidth), (int)(y + this.componentHeight), (int)this.borderColor);
            }
            if (this.image != null && this.image.textureId != -1) {
                this.image.restore();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179144_i((int)this.image.textureId);
                if (this.hasBorder) {
                    if (this.drawFull) {
                        RenderUtil.drawRectWithFullTexture(x + this.borderThickness, y + this.borderThickness, this.imageU, this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2);
                    } else {
                        RenderUtil.drawRectWithTexture(x + this.borderThickness, y + this.borderThickness, this.imageU, this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2, this.imageWidth, this.imageHeight, this.sourceWidth, this.sourceHeight);
                    }
                } else if (this.drawFull) {
                    RenderUtil.drawRectWithFullTexture(x, y, this.imageU, this.imageV, this.componentWidth, this.componentHeight);
                } else {
                    RenderUtil.drawRectWithTexture(x, y, this.imageU, this.imageV, this.componentWidth, this.componentHeight, this.imageWidth, this.imageHeight, this.sourceWidth, this.sourceHeight);
                }
            } else if (this.hasBorder) {
                Image.func_73734_a((int)(x + this.borderThickness), (int)(y + this.borderThickness), (int)(x + this.componentWidth - this.borderThickness), (int)(y + this.componentHeight - this.borderThickness), (int)Color.LIGHT_GRAY.getRGB());
            } else {
                Image.func_73734_a((int)x, (int)y, (int)(x + this.componentWidth), (int)(y + this.componentHeight), (int)Color.LIGHT_GRAY.getRGB());
            }
        }
    }

    public void reload() {
        if (this.loader != null) {
            this.loader.setup(this);
        }
    }

    public void setImage(ResourceLocation resource) {
        this.setLoader(new StandardLoader(resource));
        this.drawFull = true;
    }

    public void setImage(String url) {
        this.setLoader(new DynamicLoader(url));
        this.drawFull = true;
    }

    private void setLoader(ImageLoader loader) {
        this.loader = loader;
        if (this.initialized) {
            loader.setup(this);
            this.spinner.setVisible(true);
        }
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f) {
            this.alpha = 0.0f;
            return;
        }
        if (alpha > 1.0f) {
            this.alpha = 1.0f;
            return;
        }
        this.alpha = alpha;
    }

    public void setBorderVisible(boolean show) {
        this.hasBorder = show;
    }

    private void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setBorderThickness(int thickness) {
        this.borderThickness = thickness;
    }

    public void setDrawFull(boolean drawFull) {
        this.drawFull = drawFull;
    }

    public static class CachedImage {
        private final int textureId;
        private final int width;
        private final int height;
        private boolean dynamic;
        private boolean delete = false;

        private CachedImage(int textureId, int width, int height, boolean dynamic) {
            this.textureId = textureId;
            this.width = width;
            this.height = height;
            this.dynamic = dynamic;
        }

        public int getTextureId() {
            return this.textureId;
        }

        public void restore() {
            this.delete = false;
        }

        public void delete() {
            this.delete = true;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public boolean isPendingDeletion() {
            return this.delete;
        }
    }

    private static class ImageCache
    extends LinkedHashMap<String, CachedImage> {
        private final int CAPACITY;

        private ImageCache(int capacity) {
            super(capacity, 1.0f, true);
            this.CAPACITY = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedImage> eldest) {
            if (this.size() > this.CAPACITY) {
                eldest.getValue().delete = true;
                return true;
            }
            return false;
        }
    }

    private static class DynamicTexture
    extends AbstractTexture {
        private BufferedImage image;

        private DynamicTexture(BufferedImage image) {
            this.image = image;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.image, (boolean)false, (boolean)true);
        }
    }

    private static class DynamicLoader
    extends ImageLoader {
        private AbstractTexture texture;
        private String url;

        public DynamicLoader(String url) {
            this.url = url;
        }

        @Override
        public void setup(Image image) {
            if (CACHE.containsKey(this.url)) {
                this.setup = true;
                return;
            }
            Runnable r = () -> {
                try {
                    URL url = new URL(this.url);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0");
                    BufferedImage bufferedImage = ImageIO.read(conn.getInputStream());
                    image.imageWidth = bufferedImage.getWidth();
                    image.imageHeight = bufferedImage.getHeight();
                    this.texture = new DynamicTexture(bufferedImage);
                    this.setup = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            Thread thread = new Thread(r, "Image Loader");
            thread.start();
        }

        @Override
        public CachedImage load(Image image) {
            if (CACHE.containsKey(this.url)) {
                CachedImage cachedImage = CACHE.get(this.url);
                image.imageWidth = cachedImage.width;
                image.imageHeight = cachedImage.height;
                return cachedImage;
            }
            try {
                this.texture.func_110551_a(Minecraft.func_71410_x().func_110442_L());
                CachedImage cachedImage = new CachedImage(this.texture.func_110552_b(), image.imageWidth, image.imageHeight, true);
                CACHE.put(this.url, cachedImage);
                return cachedImage;
            }
            catch (IOException e) {
                return new CachedImage(TextureUtil.field_111001_a.func_110552_b(), 0, 0, true);
            }
        }
    }

    private static class StandardLoader
    extends ImageLoader {
        private final AbstractTexture texture;
        private final ResourceLocation resource;

        public StandardLoader(ResourceLocation resource) {
            this.texture = new SimpleTexture(resource);
            this.resource = resource;
        }

        @Override
        protected void setup(Image image) {
            this.setup = true;
        }

        @Override
        public CachedImage load(Image image) {
            ITextureObject textureObj = Minecraft.func_71410_x().func_110434_K().func_110581_b(this.resource);
            if (textureObj != null) {
                return new CachedImage(textureObj.func_110552_b(), 0, 0, false);
            }
            SimpleTexture texture = new SimpleTexture(this.resource);
            if (Minecraft.func_71410_x().func_110434_K().func_110579_a(this.resource, (ITextureObject)texture)) {
                return new CachedImage(texture.func_110552_b(), 0, 0, false);
            }
            return new CachedImage(TextureUtil.field_111001_a.func_110552_b(), 0, 0, false);
        }
    }

    private static abstract class ImageLoader {
        protected boolean setup = false;

        private ImageLoader() {
        }

        public final boolean isSetup() {
            return this.setup;
        }

        protected void setup(Image image) {
            this.setup = false;
        }

        public abstract CachedImage load(Image var1);
    }
}

