/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.mushroomtower;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.lichtower.ComponentTFTowerWing;
import twilightforest.structures.mushroomtower.ComponentTFMushroomTowerBridge;
import twilightforest.structures.mushroomtower.ComponentTFMushroomTowerMainBridge;
import twilightforest.structures.mushroomtower.ComponentTFTowerRoofMushroom;
import twilightforest.util.RotationUtil;

public class ComponentTFMushroomTowerWing
extends ComponentTFTowerWing {
    private static final int RANGE = 200;
    protected static final int FLOOR_HEIGHT = 4;
    protected static final int MAIN_SIZE = 15;
    boolean hasBase = false;
    public boolean isAscender = false;

    public ComponentTFMushroomTowerWing() {
    }

    protected ComponentTFMushroomTowerWing(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, EnumFacing direction) {
        super(feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74757_a("hasBase", this.hasBase);
        tagCompound.func_74757_a("isAscender", this.isAscender);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
        super.func_143011_b(tagCompound, templateManager);
        this.hasBase = tagCompound.func_74767_n("hasBase");
        this.isAscender = tagCompound.func_74767_n("isAscender");
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponentOld) {
            this.deco = ((StructureTFComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        boolean bl = this.hasBase = this.size > 3;
        if (this.isAscender) {
            int[] dest = this.getValidOpening(rand, Rotation.CLOCKWISE_180);
            dest[1] = this.height - 3;
            int childHeight = (rand.nextInt(3) + rand.nextInt(3) + 2) * 4 + 1;
            boolean madeIt = this.makeMainBridge(list, rand, this.func_74877_c() + 1, dest[0], dest[1], dest[2], this.size + 4, childHeight, Rotation.CLOCKWISE_180);
            if (!madeIt) {
                TwilightForestMod.LOGGER.info("Did not make bridge back to new main");
            } else {
                TwilightForestMod.LOGGER.debug("Made bridge back to new main");
            }
        }
        if (this.func_74877_c() < 5 && this.size > 6) {
            for (Rotation i : RotationUtil.ROTATIONS) {
                if (this.size < 15 && i == Rotation.CLOCKWISE_180) continue;
                int[] dest = this.getValidOpening(rand, i);
                int childHeight = (rand.nextInt(2) + rand.nextInt(2) + 2) * 4 + 1;
                this.makeBridge(list, rand, this.func_74877_c() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, i);
            }
        }
        if (this.isHighest(this.field_74887_e, this.size, list) || !this.hasBase) {
            this.makeARoof(parent, list, rand);
        }
    }

    private boolean isOutOfRange(StructureComponent parent, int nx, int ny, int nz, int range) {
        StructureBoundingBox sbb = parent.func_74874_b();
        int centerX = sbb.field_78897_a + (sbb.field_78893_d - sbb.field_78897_a + 1) / 2;
        int centerZ = sbb.field_78896_c + (sbb.field_78892_f - sbb.field_78896_c + 1) / 2;
        return Math.abs(nx - centerX) > range || Math.abs(nz - centerZ) > range;
    }

    @Override
    public boolean makeTowerWing(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        ComponentTFMushroomTowerWing wing;
        StructureComponent intersect;
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (this.isOutOfRange(list.get(0), dx[0], dx[1], dx[2], 200)) {
            return false;
        }
        if (wingSize > 3) {
            dx = this.adjustCoordinates(dx[0], dx[1], dx[2], wingSize, direction, list);
        }
        if ((intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)(wing = new ComponentTFMushroomTowerWing(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction)).func_74874_b())) == null || intersect == this || intersect instanceof ComponentTFTowerRoofMushroom) {
            if (this instanceof ComponentTFMushroomTowerBridge && this.isAscender) {
                wing.isAscender = true;
            }
            list.add(wing);
            wing.func_74861_a(list.get(0), list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    protected int[] adjustCoordinates(int x, int y, int z, int wingSize, EnumFacing direction, List<StructureComponent> list) {
        for (StructureComponent obj : list) {
            if (!(obj instanceof ComponentTFTowerWing) || obj instanceof ComponentTFMushroomTowerBridge) continue;
            ComponentTFTowerWing otherWing = (ComponentTFTowerWing)obj;
            if (wingSize != otherWing.size || !otherWing.func_74874_b().func_78885_a(x - 3, z - 3, x + 3, z + 3)) continue;
            switch (direction) {
                case SOUTH: {
                    return new int[]{otherWing.func_74874_b().field_78897_a, y, otherWing.func_74874_b().field_78896_c};
                }
                case WEST: {
                    return new int[]{otherWing.func_74874_b().field_78893_d, y, otherWing.func_74874_b().field_78896_c};
                }
                case NORTH: {
                    return new int[]{otherWing.func_74874_b().field_78893_d, y, otherWing.func_74874_b().field_78892_f};
                }
                case EAST: {
                    return new int[]{otherWing.func_74874_b().field_78897_a, y, otherWing.func_74874_b().field_78892_f};
                }
            }
            return new int[]{x, y, z};
        }
        return new int[]{x, y, z};
    }

    private boolean isHighest(StructureBoundingBox boundingBox, int size, List<StructureComponent> list) {
        StructureBoundingBox boxAbove = new StructureBoundingBox(boundingBox);
        boxAbove.field_78894_e = 256;
        for (StructureComponent obj : list) {
            if (this == obj || !(obj instanceof ComponentTFTowerWing) || obj instanceof ComponentTFMushroomTowerBridge) continue;
            ComponentTFTowerWing otherWing = (ComponentTFTowerWing)obj;
            if (size != otherWing.size || !otherWing.func_74874_b().func_78884_a(boxAbove)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void makeARoof(StructureComponent parent, List<StructureComponent> list, Random rand) {
        ComponentTFTowerRoofMushroom roof = new ComponentTFTowerRoofMushroom(this.getFeatureType(), this.func_74877_c() + 1, this, 1.6f);
        if (StructureComponent.func_74883_a(list, (StructureBoundingBox)roof.func_74874_b()) instanceof ComponentTFTowerRoofMushroom) {
            list.add(roof);
            roof.func_74861_a(this, list, rand);
        } else {
            roof = new ComponentTFTowerRoofMushroom(this.getFeatureType(), this.func_74877_c() + 1, this, 1.0f);
            if (StructureComponent.func_74883_a(list, (StructureBoundingBox)roof.func_74874_b()) instanceof ComponentTFTowerRoofMushroom) {
                list.add(roof);
                roof.func_74861_a(this, list, rand);
            } else {
                roof = new ComponentTFTowerRoofMushroom(this.getFeatureType(), this.func_74877_c() + 1, this, 0.6f);
                list.add(roof);
                roof.func_74861_a(this, list, rand);
            }
        }
    }

    @Override
    protected boolean makeBridge(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation, false);
    }

    protected boolean makeBridge(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation, boolean ascender) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        if (wingSize == 3) {
            wingHeight = 4;
        }
        ComponentTFMushroomTowerBridge bridge = new ComponentTFMushroomTowerBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        bridge.isAscender = ascender;
        StructureComponent intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)bridge.func_74874_b());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    private boolean makeMainBridge(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        ComponentTFMushroomTowerMainBridge bridge = new ComponentTFMushroomTowerMainBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(bridge);
        bridge.func_74861_a(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    @Override
    public int[] getValidOpening(Random rand, Rotation direction) {
        int wLength = Math.min(this.size / 3, 3);
        int offset = (this.size - wLength) / 2;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = this.getYByStairs(rz, rand, direction);
            return new int[]{rx, ry, rz};
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    protected int getYByStairs(int rx, Random rand, Rotation direction) {
        int floors = this.height / 4;
        return 5 + rand.nextInt(floors - 1) * 4;
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.makeTrunk(world, sbb);
        this.makeFloorsForTower(world, decoRNG, sbb);
        this.nullifySkyLightForBoundingBox(world);
        this.makeOpenings(world, sbb);
        return true;
    }

    private void makeTrunk(World world, StructureBoundingBox sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        int cx = diameter;
        int cz = diameter;
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int dy;
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > diameter) continue;
                this.func_175811_a(world, this.deco.floorState, dx + cx, 0, dz + cz, sbb);
                this.func_175811_a(world, this.deco.floorState, dx + cx, this.height, dz + cz, sbb);
                if (dist > hollow) {
                    for (dy = 0; dy <= this.height; ++dy) {
                        this.func_175811_a(world, this.deco.blockState, dx + cx, dy, dz + cz, sbb);
                    }
                } else {
                    for (dy = 1; dy <= this.height - 1; ++dy) {
                        this.func_175811_a(world, AIR, dx + cx, dy, dz + cz, sbb);
                    }
                }
                if (!this.hasBase) continue;
                this.func_175808_b(world, this.deco.blockState, dx + cx, -1, dz + cz, sbb);
            }
        }
    }

    private void makeFloorsForTower(World world, Random decoRNG, StructureBoundingBox sbb) {
        int floors = this.height / 4;
        int ladderDir = 3;
        int downLadderDir = -1;
        for (int i = 0; i < floors; ++i) {
            this.placeFloor(world, i * 4, sbb);
            downLadderDir = ladderDir++;
            ladderDir %= 4;
        }
    }

    private void placeFloor(World world, int dy, StructureBoundingBox sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        int cx = diameter;
        int cz = diameter;
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > hollow) continue;
                this.func_175811_a(world, this.isAscender ? this.deco.floorState.func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE) : this.deco.floorState, dx + cx, dy, dz + cz, sbb);
            }
        }
    }

    @Override
    protected void makeDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (this.func_175807_a(world, dx, dy + 2, dz, sbb).func_177230_c() != Blocks.field_150350_a) {
            this.func_175811_a(world, this.deco.accentState, dx, dy + 2, dz, sbb);
        }
    }

    @Override
    protected void decorateFloor(World world, Random rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, StructureBoundingBox sbb) {
    }
}

