/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeMedBranch;
import twilightforest.world.feature.TFGenerator;

public class ComponentTFHollowTreeRoot
extends ComponentTFHollowTreeMedBranch {
    protected int groundLevel = -1;
    protected static final Predicate<IBlockState> isGround = state -> {
        Material material = state.func_185904_a();
        return material == Material.field_151578_c || material == Material.field_151576_e || material == Material.field_151577_b;
    };

    public ComponentTFHollowTreeRoot() {
    }

    public ComponentTFHollowTreeRoot(TFFeature feature, int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(feature, i, sx, sy, sz, length, angle, tilt, leafy);
        this.field_74887_e = new StructureBoundingBox((Vec3i)this.src, (Vec3i)this.dest);
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb, boolean drawLeaves) {
        if (!drawLeaves) {
            if (this.groundLevel < 0) {
                this.groundLevel = this.findGroundLevel(world, sbb, 90, isGround);
                if (this.groundLevel < 0) {
                    return true;
                }
                int dy = this.groundLevel + 5 - this.src.func_177956_o();
                this.src = this.src.func_177982_a(0, dy, 0);
                this.dest = this.dest.func_177982_a(0, dy, 0);
            }
            BlockPos rSrc = this.src.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
            BlockPos rDest = this.dest.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
            this.drawRootLine(world, sbb, rSrc.func_177958_n(), rSrc.func_177956_o(), rSrc.func_177952_p(), rDest.func_177958_n(), rDest.func_177956_o(), rDest.func_177952_p(), TFBlocks.root.func_176223_P());
            this.drawRootLine(world, sbb, rSrc.func_177958_n(), rSrc.func_177956_o() - 1, rSrc.func_177952_p(), rDest.func_177958_n(), rDest.func_177956_o() - 1, rDest.func_177952_p(), TFBlocks.root.func_176223_P());
        }
        return true;
    }

    protected void drawRootLine(World world, StructureBoundingBox sbb, int x1, int y1, int z1, int x2, int y2, int z2, IBlockState blockValue) {
        BlockPos[] lineCoords;
        for (BlockPos coords : lineCoords = TFGenerator.getBresehnamArrays(x1, y1, z1, x2, y2, z2)) {
            IBlockState block = this.func_175807_a(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), sbb);
            if (!block.func_185915_l() || block.func_177230_c() != Blocks.field_150350_a && block.func_185904_a() == Material.field_151577_b) {
                IBlockState log = TFBlocks.twilight_log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
                this.func_175811_a(world, log, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), sbb);
                continue;
            }
            if (block.func_177230_c() != Blocks.field_150350_a && block.func_185904_a() == Material.field_151575_d) continue;
            this.func_175811_a(world, blockValue, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), sbb);
        }
    }
}

