/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.TFBlocks;
import twilightforest.enums.MazestoneVariant;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.world.feature.TFGenCanopyTree;

public class TFMaze {
    public int width;
    public int depth;
    public int oddBias = 3;
    public int evenBias = 1;
    public int tall = 3;
    public int head = 0;
    public int roots = 0;
    public int worldX;
    public int worldY;
    public int worldZ;
    public int type;
    public StructureComponent.BlockSelector wallBlocks;
    public IBlockState wallBlockState = TFBlocks.maze_stone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.CHISELED));
    public IBlockState headBlockState;
    public IBlockState rootBlockState = TFBlocks.maze_stone.func_176223_P();
    public IBlockState pillarBlockState = null;
    public IBlockState doorBlockState;
    public float doorRarity = 0.0f;
    public IBlockState torchBlockState = Blocks.field_150478_aa.func_176223_P();
    public float torchRarity = 0.75f;
    protected int rawWidth;
    protected int rawDepth;
    protected int[] storage;
    public static final int OUT_OF_BOUNDS = Integer.MIN_VALUE;
    public static final int OOB = Integer.MIN_VALUE;
    public static final int ROOM = 5;
    public static final int DOOR = 6;
    public Random rand;

    public TFMaze(int cellsWidth, int cellsDepth) {
        this.width = cellsWidth;
        this.depth = cellsDepth;
        this.rawWidth = this.width * 2 + 1;
        this.rawDepth = this.depth * 2 + 1;
        this.storage = new int[this.rawWidth * this.rawDepth];
        this.rand = new Random();
    }

    private int getCell(int x, int z) {
        return this.getRaw(x * 2 + 1, z * 2 + 1);
    }

    private void putCell(int x, int z, int value) {
        this.putRaw(x * 2 + 1, z * 2 + 1, value);
    }

    private boolean cellEquals(int x, int z, int value) {
        return this.getCell(x, z) == value;
    }

    private int getWall(int sx, int sz, int dx, int dz) {
        if (dx == sx + 1 && dz == sz) {
            return this.getRaw(sx * 2 + 2, sz * 2 + 1);
        }
        if (dx == sx - 1 && dz == sz) {
            return this.getRaw(sx * 2 + 0, sz * 2 + 1);
        }
        if (dx == sx && dz == sz + 1) {
            return this.getRaw(sx * 2 + 1, sz * 2 + 2);
        }
        if (dx == sx && dz == sz - 1) {
            return this.getRaw(sx * 2 + 1, sz * 2 + 0);
        }
        TwilightForestMod.LOGGER.info("Wall check out of bounds; s = {}, {}; d = {}, {}", (Object)sx, (Object)sz, (Object)dx, (Object)dz);
        return Integer.MIN_VALUE;
    }

    public void putWall(int sx, int sz, int dx, int dz, int value) {
        if (dx == sx + 1 && dz == sz) {
            this.putRaw(sx * 2 + 2, sz * 2 + 1, value);
        }
        if (dx == sx - 1 && dz == sz) {
            this.putRaw(sx * 2 + 0, sz * 2 + 1, value);
        }
        if (dx == sx && dz == sz + 1) {
            this.putRaw(sx * 2 + 1, sz * 2 + 2, value);
        }
        if (dx == sx && dz == sz - 1) {
            this.putRaw(sx * 2 + 1, sz * 2 + 0, value);
        }
    }

    public boolean isWall(int sx, int sz, int dx, int dz) {
        return this.getWall(sx, sz, dx, dz) == 0;
    }

    public void putRaw(int rawx, int rawz, int value) {
        if (rawx >= 0 && rawx < this.rawWidth && rawz >= 0 && rawz < this.rawDepth) {
            this.storage[rawz * this.rawWidth + rawx] = value;
        }
    }

    private int getRaw(int rawx, int rawz) {
        if (rawx < 0 || rawx >= this.rawWidth || rawz < 0 || rawz >= this.rawDepth) {
            return Integer.MIN_VALUE;
        }
        return this.storage[rawz * this.rawWidth + rawx];
    }

    public void setSeed(long newSeed) {
        this.rand.setSeed(newSeed);
    }

    public void copyToWorld(World world, int dx, int dy, int dz) {
        this.worldX = dx;
        this.worldY = dy;
        this.worldZ = dz;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z = 0; z < this.rawDepth; ++z) {
                int y;
                int odd;
                int even;
                if (this.getRaw(x, z) != 0) continue;
                int mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (this.isEven(x) && this.isEven(z)) {
                    if (this.type == 4 && this.shouldTree(x, z)) {
                        new TFGenCanopyTree().func_180709_b(world, this.rand, new BlockPos(mdx, dy, mdz));
                    } else {
                        int y2;
                        for (y2 = 0; y2 < this.head; ++y2) {
                            this.putHeadBlock(world, mdx, dy + this.tall + y2, mdz);
                        }
                        for (y2 = 0; y2 < this.tall; ++y2) {
                            this.putWallBlock(world, mdx, dy + y2, mdz);
                        }
                        for (y2 = 1; y2 <= this.roots; ++y2) {
                            this.putRootBlock(world, mdx, dy - y2, mdz);
                        }
                    }
                }
                if (this.isEven(x) && !this.isEven(z)) {
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            for (y = 0; y < this.head; ++y) {
                                this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd);
                            }
                            for (y = 0; y < this.tall; ++y) {
                                this.putWallBlock(world, mdx + even, dy + y, mdz + odd);
                            }
                            for (y = 1; y <= this.roots; ++y) {
                                this.putRootBlock(world, mdx + even, dy - y, mdz + odd);
                            }
                        }
                    }
                }
                if (this.isEven(x) || !this.isEven(z)) continue;
                for (even = 0; even < this.evenBias; ++even) {
                    for (odd = 1; odd <= this.oddBias; ++odd) {
                        for (y = 0; y < this.head; ++y) {
                            this.putHeadBlock(world, mdx + odd, dy + this.tall + y, mdz + even);
                        }
                        for (y = 0; y < this.tall; ++y) {
                            this.putWallBlock(world, mdx + odd, dy + y, mdz + even);
                        }
                        for (y = 1; y <= this.roots; ++y) {
                            this.putRootBlock(world, mdx + odd, dy - y, mdz + even);
                        }
                    }
                }
            }
        }
        this.placeTorches(world);
    }

    public void carveToWorld(World world, int dx, int dy, int dz) {
        this.worldX = dx;
        this.worldY = dy;
        this.worldZ = dz;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z = 0; z < this.rawDepth; ++z) {
                int y;
                int i;
                if (this.getRaw(x, z) == 0) continue;
                int mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (this.isEven(x) && this.isEven(z)) {
                    for (int y2 = 0; y2 < this.tall; ++y2) {
                        this.carveBlock(world, mdx, dy + y2, mdz);
                    }
                    continue;
                }
                if (this.isEven(x) && !this.isEven(z)) {
                    for (i = 1; i <= this.oddBias; ++i) {
                        for (y = 0; y < this.tall; ++y) {
                            this.carveBlock(world, mdx, dy + y, mdz + i);
                        }
                    }
                    continue;
                }
                if (!this.isEven(x) && this.isEven(z)) {
                    for (i = 1; i <= this.oddBias; ++i) {
                        for (y = 0; y < this.tall; ++y) {
                            this.carveBlock(world, mdx + i, dy + y, mdz);
                        }
                    }
                    continue;
                }
                if (this.isEven(x) || this.isEven(z)) continue;
                for (int mx = 1; mx <= this.oddBias; ++mx) {
                    for (int mz = 1; mz <= this.oddBias; ++mz) {
                        for (int y3 = 0; y3 < this.tall; ++y3) {
                            this.carveBlock(world, mdx + mx, dy + y3, mdz + mz);
                        }
                    }
                }
            }
        }
        this.placeTorches(world);
    }

    public void copyToStructure(World world, int dx, int dy, int dz, StructureTFComponentOld component, StructureBoundingBox sbb) {
        int mdx;
        int z;
        int x;
        for (x = 0; x < this.rawWidth; ++x) {
            for (z = 0; z < this.rawDepth; ++z) {
                int odd;
                int y;
                int even;
                int mdz;
                if (this.getRaw(x, z) == 0) {
                    mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                    mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                    if (this.evenBias > 1) {
                        --mdx;
                        --mdz;
                    }
                    if (this.isEven(x) && this.isEven(z)) {
                        if (this.type == 4 && this.shouldTree(x, z)) {
                            this.putCanopyTree(world, mdx, dy, mdz, component, sbb);
                        } else {
                            for (even = 0; even < this.evenBias; ++even) {
                                for (int even2 = 0; even2 < this.evenBias; ++even2) {
                                    for (y = 0; y < this.head; ++y) {
                                        this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 0; y < this.tall; ++y) {
                                        if (this.shouldPillar(x, z)) {
                                            this.putPillarBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                            continue;
                                        }
                                        this.putWallBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 1; y <= this.roots; ++y) {
                                        this.putRootBlock(world, mdx + even, dy - y, mdz + even2, component, sbb);
                                    }
                                }
                            }
                        }
                    }
                    if (this.isEven(x) && !this.isEven(z)) {
                        for (even = 0; even < this.evenBias; ++even) {
                            for (odd = 1; odd <= this.oddBias; ++odd) {
                                this.makeWallThing(world, dy, component, sbb, mdx, mdz, even, odd);
                            }
                        }
                    }
                    if (this.isEven(x) || !this.isEven(z)) continue;
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            this.makeWallThing(world, dy, component, sbb, mdx, mdz, odd, even);
                        }
                    }
                    continue;
                }
                if (this.getRaw(x, z) != 6) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (this.evenBias > 1) {
                    --mdx;
                    --mdz;
                }
                if (this.isEven(x) && !this.isEven(z)) {
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            for (y = 0; y < this.head; ++y) {
                                this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
                            }
                            for (y = 0; y < this.tall; ++y) {
                                this.putDoorBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
                            }
                            for (y = 1; y <= this.roots; ++y) {
                                this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
                            }
                        }
                    }
                }
                if (this.isEven(x) || !this.isEven(z)) continue;
                for (even = 0; even < this.evenBias; ++even) {
                    for (odd = 1; odd <= this.oddBias; ++odd) {
                        for (y = 0; y < this.head; ++y) {
                            this.putHeadBlock(world, mdx + odd, dy + this.tall + y, mdz + even, component, sbb);
                        }
                        for (y = 0; y < this.tall; ++y) {
                            this.putDoorBlock(world, mdx + odd, dy + y, mdz + even, component, sbb);
                        }
                        for (y = 1; y <= this.roots; ++y) {
                            this.putRootBlock(world, mdx + odd, dy - y, mdz + even, component, sbb);
                        }
                    }
                }
            }
        }
        for (x = 0; x < this.rawWidth; ++x) {
            for (z = 0; z < this.rawDepth; ++z) {
                if (this.getRaw(x, z) != 0) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdy = dy + 1;
                int mdz = dz + z / 2 * (this.evenBias + this.oddBias);
                if (!this.isEven(x) || !this.isEven(z) || !this.shouldTorch(x, z) || component.func_175807_a(world, mdx, mdy, mdz, sbb).func_177230_c() != this.wallBlockState.func_177230_c()) continue;
                component.func_175811_a(world, this.torchBlockState, mdx, mdy, mdz, sbb);
            }
        }
    }

    private void makeWallThing(World world, int dy, StructureTFComponentOld component, StructureBoundingBox sbb, int mdx, int mdz, int even, int odd) {
        int y;
        for (y = 0; y < this.head; ++y) {
            this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
        }
        for (y = 0; y < this.tall; ++y) {
            this.putWallBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
        }
        for (y = 1; y <= this.roots; ++y) {
            this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
        }
    }

    private void putPillarBlock(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        component.func_175811_a(world, this.pillarBlockState, x, y, z, sbb);
    }

    private void putWallBlock(World world, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x, y, z), this.wallBlockState, 2);
    }

    private void putWallBlock(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        if (this.wallBlocks != null) {
            this.wallBlocks.func_75062_a(this.rand, x, y, z, true);
            component.func_175811_a(world, this.wallBlocks.func_180780_a(), x, y, z, sbb);
        } else {
            component.func_175811_a(world, this.wallBlockState, x, y, z, sbb);
        }
    }

    private void putDoorBlock(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        component.func_175811_a(world, this.doorBlockState, x, y, z, sbb);
    }

    private void carveBlock(World world, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
    }

    private void putHeadBlock(World world, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x, y, z), this.headBlockState, 2);
    }

    private void putHeadBlock(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        component.func_175811_a(world, this.headBlockState, x, y, z, sbb);
    }

    private void putRootBlock(World world, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x, y, z), this.rootBlockState, 2);
    }

    private void putRootBlock(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        component.func_175811_a(world, this.rootBlockState, x, y, z, sbb);
    }

    private void putCanopyTree(World world, int x, int y, int z, StructureTFComponentOld component, StructureBoundingBox sbb) {
        BlockPos pos = component.getBlockPosWithOffset(x, y, z);
        if (sbb.func_175898_b((Vec3i)pos)) {
            new TFGenCanopyTree().func_180709_b(world, this.rand, pos);
        }
    }

    private final boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void placeTorches(World world) {
        int torchHeight = 1;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z = 0; z < this.rawDepth; ++z) {
                if (this.getRaw(x, z) != 0) continue;
                int mdx = this.worldX + x / 2 * (this.evenBias + this.oddBias);
                int mdy = this.worldY + torchHeight;
                int mdz = this.worldZ + z / 2 * (this.evenBias + this.oddBias);
                BlockPos pos = new BlockPos(mdx, mdy, mdz);
                if (!this.isEven(x) || !this.isEven(z) || !this.shouldTorch(x, z) || world.func_180495_p(pos).func_177230_c() != this.wallBlockState.func_177230_c()) continue;
                world.func_180501_a(pos, this.torchBlockState, 2);
            }
        }
    }

    public boolean shouldTorch(int rx, int rz) {
        if (this.getRaw(rx + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        if (this.getRaw(rx + 1, rz) == 0 && this.getRaw(rx - 1, rz) == 0 || this.getRaw(rx, rz + 1) == 0 && this.getRaw(rx, rz - 1) == 0) {
            return false;
        }
        return this.rand.nextFloat() <= this.torchRarity;
    }

    public boolean shouldPillar(int rx, int rz) {
        if (this.pillarBlockState == null) {
            return false;
        }
        if (this.getRaw(rx + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        return (this.getRaw(rx + 1, rz) != 0 || this.getRaw(rx - 1, rz) != 0) && (this.getRaw(rx, rz + 1) != 0 || this.getRaw(rx, rz - 1) != 0);
    }

    public boolean shouldTree(int rx, int rz) {
        if (!(rx != 0 && rx != this.rawWidth - 1 || this.getRaw(rx, rz + 1) == 0 && this.getRaw(rx, rz - 1) == 0)) {
            return true;
        }
        if (!(rz != 0 && rz != this.rawDepth - 1 || this.getRaw(rx + 1, rz) == 0 && this.getRaw(rx - 1, rz) == 0)) {
            return true;
        }
        return this.rand.nextInt(50) == 0;
    }

    int getWorldX(int x) {
        return this.worldX + x * (this.evenBias + this.oddBias) + 1;
    }

    int getWorldZ(int z) {
        return this.worldZ + z * (this.evenBias + this.oddBias) + 1;
    }

    public void carveRoom0(int cx, int cz) {
        this.putCell(cx, cz, 5);
        this.putCell(cx + 1, cz, 5);
        this.putWall(cx, cz, cx + 1, cz, 5);
        this.putCell(cx - 1, cz, 5);
        this.putWall(cx, cz, cx - 1, cz, 5);
        this.putCell(cx, cz + 1, 5);
        this.putWall(cx, cz, cx, cz + 1, 5);
        this.putCell(cx, cz - 1, 5);
        this.putWall(cx, cz, cx, cz - 1, 5);
    }

    public void carveRoom1(int cx, int cz) {
        int rx = cx * 2 + 1;
        int rz = cz * 2 + 1;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                this.putRaw(rx + i, rz + j, 5);
            }
        }
        this.putCell(rx, rz + 1, 0);
        this.putCell(rx, rz - 1, 0);
        this.putCell(rx + 1, rz, 0);
        this.putCell(rx - 1, rz, 0);
        if (this.getRaw(rx, rz + 4) != Integer.MIN_VALUE) {
            this.putRaw(rx, rz + 3, 5);
        }
        if (this.getRaw(rx, rz - 4) != Integer.MIN_VALUE) {
            this.putRaw(rx, rz - 3, 5);
        }
        if (this.getRaw(rx + 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx + 3, rz, 5);
        }
        if (this.getRaw(rx - 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx - 3, rz, 5);
        }
    }

    public void add4Exits() {
        int hx = this.rawWidth / 2 + 1;
        int hz = this.rawDepth / 2 + 1;
        this.putRaw(hx, 0, 5);
        this.putRaw(hx, this.rawDepth - 1, 5);
        this.putRaw(0, hz, 5);
        this.putRaw(this.rawWidth - 1, hz, 5);
    }

    public void generateRecursiveBacktracker(int sx, int sz) {
        this.rbGen(sx, sz);
    }

    public void rbGen(int sx, int sz) {
        this.putCell(sx, sz, 1);
        int unvisited = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz - 1, 0)) {
            ++unvisited;
        }
        if (unvisited == 0) {
            return;
        }
        int rn = this.rand.nextInt(unvisited);
        int dz = 0;
        int dx = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            if (rn == 0) {
                dx = sx + 1;
                dz = sz;
            }
            --rn;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            if (rn == 0) {
                dx = sx - 1;
                dz = sz;
            }
            --rn;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            if (rn == 0) {
                dx = sx;
                dz = sz + 1;
            }
            --rn;
        }
        if (this.cellEquals(sx, sz - 1, 0) && rn == 0) {
            dx = sx;
            dz = sz - 1;
        }
        if (this.rand.nextFloat() <= this.doorRarity) {
            this.putWall(sx, sz, dx, dz, 6);
        } else {
            this.putWall(sx, sz, dx, dz, 2);
        }
        this.rbGen(dx, dz);
        this.rbGen(sx, sz);
        this.rbGen(sx, sz);
    }
}

