/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomes;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFBreathAttack;

public class EntityTFWinterWolf
extends EntityTFHostileWolf
implements IBreathAttacker {
    public static final ResourceLocation LOOT_TABLE = TwilightForestMod.prefix("entities/winter_wolf");
    private static final DataParameter<Boolean> BREATH_FLAG = EntityDataManager.func_187226_a(EntityTFWinterWolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final float BREATH_DAMAGE = 2.0f;

    public EntityTFWinterWolf(World world) {
        super(world);
        this.func_70105_a(1.4f, 1.9f);
        this.func_175547_a(EnumDyeColor.LIGHT_BLUE);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, new EntityAITFBreathAttack<EntityTFWinterWolf>(this, 1.0f, 5.0f, 30, 0.1f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void setAttributes() {
        super.setAttributes();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BREATH_FLAG, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBreathing()) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnBreathParticles();
            }
            this.playBreathSound();
        }
    }

    private void spawnBreathParticles() {
        Vec3d look = this.func_70040_Z();
        double dist = 0.5;
        double px = this.field_70165_t + look.field_72450_a * 0.5;
        double py = this.field_70163_u + 1.25 + look.field_72448_b * 0.5;
        double pz = this.field_70161_v + look.field_72449_c * 0.5;
        for (int i = 0; i < 10; ++i) {
            double dx = look.field_72450_a;
            double dy = look.field_72448_b;
            double dz = look.field_72449_c;
            double spread = 5.0 + this.func_70681_au().nextDouble() * 2.5;
            double velocity = 3.0 + this.func_70681_au().nextDouble() * 0.15;
            dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            dy += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            TwilightForestMod.proxy.spawnParticle(TFParticleType.SNOW, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }

    private void playBreathSound() {
        this.func_184185_a(SoundEvents.field_187557_bK, this.field_70146_Z.nextFloat() * 0.5f, this.field_70146_Z.nextFloat() * 0.5f);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.field_70180_af.func_187225_a(BREATH_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.field_70180_af.func_187227_b(BREATH_FLAG, (Object)flag);
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
    }

    @Override
    protected boolean isValidLightLevel() {
        return this.field_70170_p.func_180494_b(new BlockPos((Entity)this)) == TFBiomes.snowy_forest || super.isValidLightLevel();
    }

    @Override
    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }
}

