/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.enums.Diagonals;
import twilightforest.item.TFItems;

public class BlockTFSpiralBrick
extends Block
implements ModelRegisterCallback {
    public static final IProperty<Diagonals> DIAGONAL = PropertyEnum.func_177709_a((String)"diagonal", Diagonals.class);
    public static final IProperty<EnumFacing.Axis> AXIS_FACING = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockTFSpiralBrick() {
        super(Material.field_151576_e, MapColor.field_151665_m);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.TOP_RIGHT)).func_177226_a(AXIS_FACING, (Comparable)EnumFacing.Axis.X));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS_FACING, DIAGONAL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing.Axis)state.func_177229_b(AXIS_FACING)).ordinal() << 2 | ((Diagonals)((Object)state.func_177229_b(DIAGONAL))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.values()[meta & 3])).func_177226_a(AXIS_FACING, (Comparable)EnumFacing.Axis.values()[(meta & 0xC) >> 2]);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (!placer.func_70093_af() && worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() instanceof BlockTFSpiralBrick) {
            EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS_FACING);
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS_FACING, (Comparable)axis).func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.func_177229_b(DIAGONAL)), facing.func_176740_k() == EnumFacing.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK)));
        }
        EnumFacing playerFacing = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS_FACING, (Comparable)playerFacing.func_176740_k()).func_177226_a(DIAGONAL, (Comparable)((Object)BlockTFSpiralBrick.getDiagonalFromPlayerPlacement(placer, facing)));
    }

    private static Diagonals getDiagonalFromPlayerPlacement(EntityLivingBase placer, EnumFacing facing) {
        int angleX = (int)((placer.field_70125_A + 180.0f) / 180.0f) & 1;
        int angleY = (int)((placer.field_70177_z + 180.0f) / 90.0f) & 3;
        switch (facing) {
            case DOWN: 
            case UP: {
                switch (angleY) {
                    default: {
                        return Diagonals.TOP_RIGHT;
                    }
                    case 1: {
                        return Diagonals.BOTTOM_RIGHT;
                    }
                    case 2: {
                        return Diagonals.BOTTOM_LEFT;
                    }
                    case 3: 
                }
                return Diagonals.TOP_LEFT;
            }
            case NORTH: {
                return Diagonals.getDiagonalFromUpDownLeftRight(BlockTFSpiralBrick.isEast(angleY), angleX < 1);
            }
            case SOUTH: {
                return Diagonals.getDiagonalFromUpDownLeftRight(!BlockTFSpiralBrick.isEast(angleY), angleX < 1);
            }
            case EAST: {
                return Diagonals.getDiagonalFromUpDownLeftRight(BlockTFSpiralBrick.isNorth(angleY), angleX < 1);
            }
            case WEST: {
                return Diagonals.getDiagonalFromUpDownLeftRight(!BlockTFSpiralBrick.isNorth(angleY), angleX < 1);
            }
        }
        return Diagonals.TOP_RIGHT;
    }

    private static boolean isNorth(int intIn) {
        return intIn == 0 || intIn == 3;
    }

    private static boolean isEast(int intIn) {
        return intIn == 0 || intIn == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        StateMap stateMapper = new StateMap.Builder().func_178440_a(AXIS_FACING).func_178439_a("_spiral_bricks").func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMapper);
        ModelUtils.registerToState(this, 0, this.func_176223_P().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.BOTTOM_LEFT)), (IStateMapper)stateMapper);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS_FACING);
        if (axis == EnumFacing.Axis.Y) {
            return state.func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.rotate((Diagonals)((Object)state.func_177229_b(DIAGONAL)), rot)));
        }
        if (rot == Rotation.CLOCKWISE_180 || axis == EnumFacing.Axis.X && rot == Rotation.COUNTERCLOCKWISE_90 || axis == EnumFacing.Axis.Z && rot == Rotation.CLOCKWISE_90) {
            state = state.func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.func_177229_b(DIAGONAL)), Mirror.LEFT_RIGHT)));
        }
        return rot.ordinal() % 2 == 0 ? state : state.func_177226_a(AXIS_FACING, (Comparable)(axis == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.mirrorOn((EnumFacing.Axis)state.func_177229_b(AXIS_FACING), (Diagonals)((Object)state.func_177229_b(DIAGONAL)), mirrorIn)));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        if (facing.func_176740_k() == state.func_177229_b(AXIS_FACING)) {
            state = state.func_177231_a(DIAGONAL);
        } else {
            switch (facing.func_176740_k()) {
                case X: {
                    state = state.func_177226_a(AXIS_FACING, (Comparable)(state.func_177229_b(AXIS_FACING) == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y));
                    break;
                }
                case Y: {
                    state = state.func_177226_a(AXIS_FACING, (Comparable)(state.func_177229_b(AXIS_FACING) == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
                    break;
                }
                case Z: {
                    state = state.func_177226_a(AXIS_FACING, (Comparable)(state.func_177229_b(AXIS_FACING) == EnumFacing.Axis.Y ? EnumFacing.Axis.X : EnumFacing.Axis.Y));
                }
            }
        }
        world.func_175656_a(pos, state);
        return true;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.values();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS_FACING);
        if (face.func_176740_k() == axis) {
            return BlockFaceShape.UNDEFINED;
        }
        EnumFacing top = axis == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.UP;
        EnumFacing left = axis == EnumFacing.Axis.X ? EnumFacing.SOUTH : EnumFacing.WEST;
        Diagonals diagonal = (Diagonals)((Object)state.func_177229_b(DIAGONAL));
        if (face == (diagonal.isLeft() ? left : left.func_176734_d()) || face == (diagonal.isTop() ? top : top.func_176734_d())) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_193383_a(world, state, pos, face) == BlockFaceShape.SOLID;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }
}

