/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.enums.SaplingVariant;
import twilightforest.item.TFItems;
import twilightforest.world.feature.IBlockSettable;
import twilightforest.world.feature.TFGenCanopyTree;
import twilightforest.world.feature.TFGenDarkCanopyTree;
import twilightforest.world.feature.TFGenHollowTree;
import twilightforest.world.feature.TFGenLargeRainboak;
import twilightforest.world.feature.TFGenMangroveTree;
import twilightforest.world.feature.TFGenMinersTree;
import twilightforest.world.feature.TFGenSmallRainboak;
import twilightforest.world.feature.TFGenSmallTwilightOak;
import twilightforest.world.feature.TFGenSortingTree;
import twilightforest.world.feature.TFGenTreeOfTime;
import twilightforest.world.feature.TFGenTreeOfTransformation;

public class BlockTFSapling
extends BlockBush
implements IGrowable,
ModelRegisterCallback {
    public static final IProperty<SaplingVariant> TF_TYPE = PropertyEnum.func_177709_a((String)"tf_type", SaplingVariant.class);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    protected BlockTFSapling() {
        this.func_149647_a(TFItems.creativeTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TF_TYPE, (Comparable)((Object)SaplingVariant.OAK)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TF_TYPE});
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        IBlockSettable treeGenerator;
        switch ((SaplingVariant)((Object)state.func_177229_b(TF_TYPE))) {
            case CANOPY: {
                treeGenerator = new TFGenCanopyTree(true);
                break;
            }
            case MANGROVE: {
                treeGenerator = new TFGenMangroveTree(true);
                break;
            }
            case DARKWOOD: {
                treeGenerator = new TFGenDarkCanopyTree(true);
                break;
            }
            case HOLLOW_OAK: {
                treeGenerator = new TFGenHollowTree(true);
                break;
            }
            case TIME: {
                treeGenerator = new TFGenTreeOfTime(true);
                break;
            }
            case TRANSFORMATION: {
                treeGenerator = new TFGenTreeOfTransformation(true);
                break;
            }
            case MINING: {
                treeGenerator = new TFGenMinersTree(true);
                break;
            }
            case SORTING: {
                treeGenerator = new TFGenSortingTree(true);
                break;
            }
            case RAINBOW: {
                treeGenerator = rand.nextInt(7) == 0 ? new TFGenLargeRainboak(true) : new TFGenSmallRainboak(true);
                break;
            }
            default: {
                treeGenerator = new TFGenSmallTwilightOak(true);
            }
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!treeGenerator.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 3));
        list.add((Object)new ItemStack((Block)this, 1, 4));
        list.add((Object)new ItemStack((Block)this, 1, 5));
        list.add((Object)new ItemStack((Block)this, 1, 6));
        list.add((Object)new ItemStack((Block)this, 1, 7));
        list.add((Object)new ItemStack((Block)this, 1, 8));
        list.add((Object)new ItemStack((Block)this, 1, 9));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingVariant)((Object)state.func_177229_b(TF_TYPE))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TF_TYPE, (Comparable)((Object)SaplingVariant.values()[meta % SaplingVariant.values().length]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < SaplingVariant.values().length; ++i) {
            String variant = "inventory_" + SaplingVariant.values()[i].func_176610_l();
            ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), variant);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }
}

